---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-Avro出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：ドキュメントやコードに明示的な記載なし

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroFormatFactory.java`（行55-130）
- E-02: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroRowDataSerializationSchema.java`（行41-142）
- E-03: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroFormatOptions.java`（行32-87）
- E-04: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/RowDataToAvroConverters.java`（行48-353）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行4）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AvroRowDataSerializationSchemaはSerializationSchemaを実装 | E-02 行41 | ○ |
| C-02 | エンコーディングのデフォルトはBINARY | E-03 行39-47 | ○ |
| C-03 | 圧縮コーデックのデフォルトはsnappy | E-03 行34-38 | ○ |
| C-04 | レガシータイムスタンプマッピングのデフォルトはtrue | E-03 行73-84 | ○ |
| C-05 | AvroEncodingにはBINARY/JSONの2モード | E-03 行50-71 | ○ |
| C-06 | RowDataToAvroConverterでRowDataをAvroに変換 | E-04 行58-61 | ○ |
| C-07 | TYPEINTはintValue()でAvro intに変換 | E-04 行93-103 | ○ |
| C-08 | SMALLINTはintValue()でAvro intに変換 | E-04 行104-114 | ○ |
| C-09 | CHAR/VARCHARはUtf8オブジェクトに変換 | E-04 行134-145 | ○ |
| C-10 | BINARY/VARBINARYはByteBufferに変換 | E-04 行146-157 | ○ |
| C-11 | TIMESTAMPはtoEpochMilli()でlong値に変換 | E-04 行158-183 | ○ |
| C-12 | TIMESTAMP_LTZはレガシーモードでサポート外 | E-04 行184-198 | ○ |
| C-13 | DECIMALはtoUnscaledBytes()でバイト配列に変換 | E-04 行199-209 | ○ |
| C-14 | RAW型はサポートされない | E-04 行220-222 | ○ |
| C-15 | createEncodingFormatでSerializationSchemaを生成 | E-01 行89-111 | ○ |
| C-16 | AvroRowDataSerializationSchemaのインスタンス化 | E-01 行102-103 | ○ |
| C-17 | serialize()でRowDataをGenericRecord経由でbyte[]に変換 | E-02 行116-124 | ○ |
| C-18 | エラー時に "Fail to serialize at field:" メッセージ | E-04 行288-291 | ○ |
| C-19 | エラー時に "Failed to serialize row." メッセージ | E-02 行122 | ○ |
| C-20 | 不正なUNIONスキーマエラー | E-04 行245-246 | ○ |
| C-21 | createRowConverter()で行全体の変換器を生成 | E-04 行256-297 | ○ |
| C-22 | createArrayConverter()でARRAY型を変換 | E-04 行299-322 | ○ |
| C-23 | createMapConverter()でMAP型を変換 | E-04 行324-352 | ○ |
| C-24 | AvroFormatFactoryのIDENTIFIERは"avro" | E-01 行57 | ○ |
| C-25 | NestedSchemaを使用してGenericRecordをシリアライズ | E-02 行45-46 | ○ |
| C-26 | パフォーマンス要件：リアルタイム処理対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（スループット、レイテンシ等）についての公式ドキュメントやベンチマーク結果が見つからない
  - 候補：Flink公式ドキュメント / ベンチマーク資料 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接確認可能な技術仕様の記載
- 0: 低リスク - 設定オプションの仕様はAvroFormatOptions.javaで確認済み
- 0: 低リスク - 型変換処理はRowDataToAvroConverters.javaで詳細に確認済み
- 1: 中リスク - パフォーマンス要件は具体的数値がなく一般的な記載

## 6) レビュアーチェックリスト（最小）
- [ ] AvroRowDataSerializationSchema.javaのserialize実装が設計書と一致するか確認
- [ ] AvroFormatOptions.javaの各オプションのデフォルト値が正しいか確認
- [ ] RowDataToAvroConverters.javaの型変換マッピングが網羅されているか確認
- [ ] レガシータイムスタンプマッピングとTIMESTAMP_LTZ型の制約確認
- [ ] エラーメッセージの記載がソースコードと一致するか確認
- [ ] パフォーマンス要件について、必要に応じて具体的な数値を補完
