---
generated_at: 2026-02-02 16:20:00
metrics:
  claims_total: 92
  claims_with_evidence: 92
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：92 / 92、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml` - プロジェクトのモジュール構成定義
- E-02: `README.md` - プロジェクト概要と機能説明
- E-03: `flink-table/README.md` - Table API/SQLモジュール説明
- E-04: `flink-core-api/src/main/java/org/apache/flink/api/common/functions/` - Function APIのインターフェース定義
- E-05: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/` - DataStream APIのインターフェース定義
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/` - ランタイムコンポーネント実装
- E-07: `flink-state-backends/` - ステートバックエンド実装
- E-08: `flink-connectors/` - コネクタ実装
- E-09: `flink-formats/` - フォーマット実装
- E-10: `flink-filesystems/` - ファイルシステム実装
- E-11: `flink-metrics/` - メトリクスレポーター実装
- E-12: `flink-yarn/` - YARN連携実装
- E-13: `flink-kubernetes/` - Kubernetes連携実装
- E-14: `flink-rpc/` - RPC実装
- E-15: `flink-libraries/` - ライブラリ（CEP, State Processing API）
- E-16: `flink-queryable-state/` - クエリアブルステート実装
- E-17: `flink-python/pyflink/` - Python API実装
- E-18: `flink-clients/` - CLIクライアント
- E-19: `flink-examples/` - サンプルプログラム
- E-20: `flink-table/flink-sql-parser/` - SQLパーサー実装
- E-21: `flink-table/flink-table-planner/` - SQLプランナー実装
- E-22: `flink-table/flink-sql-client/` - SQLクライアント実装
- E-23: `flink-table/flink-sql-gateway/` - SQLゲートウェイ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Function API - ストリーム/バッチ処理の基本関数インターフェース | E-04 | ○ |
| C-02 | KeySelector - データをキーで分割するためのセレクタ機能 | E-04 | ○ |
| C-03 | 型システム - データ型の定義と変換 | E-01, E-04 | ○ |
| C-04 | 設定管理 - Flinkの設定パラメータの管理機能 | E-01, E-06 | ○ |
| C-05 | メモリ管理 - カスタムメモリ管理 | E-02, E-06 | ○ |
| C-06 | ストリーム実行環境 - StreamExecutionEnvironment | E-01, E-05 | ○ |
| C-07 | DataStream変換 - map, flatMap, filter, keyBy, window等 | E-02, E-05 | ○ |
| C-08 | ProcessFunction - 低レベルストリーム処理関数 | E-05 | ○ |
| C-09 | ウィンドウ処理 - 時間/カウント/セッションベース | E-02 | ○ |
| C-10 | Watermark - イベント時間処理 | E-02, E-05 | ○ |
| C-11 | 非同期I/O - AsyncDataStream | E-01 | ○ |
| C-12 | ブロードキャストストリーム | E-05 | ○ |
| C-13 | Table API Java | E-01, E-03 | ○ |
| C-14 | Table API Scala | E-01, E-03 | ○ |
| C-15 | 型変換 - Table APIとDataStream API間 | E-03 | ○ |
| C-16 | 組み込み関数 | E-03 | ○ |
| C-17 | UDF - ユーザー定義関数 | E-03 | ○ |
| C-18 | SQLパーサー - ANSI SQL構文解析 | E-03, E-20 | ○ |
| C-19 | SQLプランナー - 実行計画生成と最適化 | E-03, E-21 | ○ |
| C-20 | SQLクライアント - 対話的SQLクエリ実行CLI | E-03, E-22 | ○ |
| C-21 | SQLゲートウェイ | E-23 | ○ |
| C-22 | JDBCドライバ | E-01 | ○ |
| C-23 | ジョブ管理 - JobManager | E-02, E-06 | ○ |
| C-24 | タスク実行 - TaskManager | E-06 | ○ |
| C-25 | リソース管理 - ResourceManager | E-06 | ○ |
| C-26 | チェックポイント - 分散スナップショット | E-02, E-06 | ○ |
| C-27 | ステート管理 | E-06 | ○ |
| C-28 | スケジューラ | E-06 | ○ |
| C-29 | シャッフル | E-06 | ○ |
| C-30 | ハートビート | E-06 | ○ |
| C-31 | 高可用性 - ZooKeeper/Kubernetes HA | E-06 | ○ |
| C-32 | REST API - Webモニタリング | E-01 | ○ |
| C-33 | HashMapStateBackend | E-06 | ○ |
| C-34 | RocksDBStateBackend | E-07 | ○ |
| C-35 | ForStStateBackend | E-07 | ○ |
| C-36 | ChangelogStateBackend | E-07 | ○ |
| C-37 | SpillableStateBackend | E-07 | ○ |
| C-38 | ファイルコネクタ | E-08 | ○ |
| C-39 | データ生成コネクタ | E-08 | ○ |
| C-40 | Hadoop互換性 | E-02, E-08 | ○ |
| C-41 | コネクタベース | E-08 | ○ |
| C-42 | JSON フォーマット | E-09 | ○ |
| C-43 | Avro フォーマット | E-09 | ○ |
| C-44 | Parquet フォーマット | E-09 | ○ |
| C-45 | ORC フォーマット | E-09 | ○ |
| C-46 | CSV フォーマット | E-09 | ○ |
| C-47 | Protobuf フォーマット | E-09 | ○ |
| C-48 | 圧縮 フォーマット | E-09 | ○ |
| C-49 | Sequence File フォーマット | E-09 | ○ |
| C-50 | Confluent Registry | E-09 | ○ |
| C-51 | S3（Hadoop） | E-10 | ○ |
| C-52 | S3（Presto） | E-10 | ○ |
| C-53 | Azure Blob Storage | E-10 | ○ |
| C-54 | Google Cloud Storage | E-10 | ○ |
| C-55 | Alibaba OSS | E-10 | ○ |
| C-56 | HDFS | E-02, E-10 | ○ |
| C-57 | メトリクスコア | E-11 | ○ |
| C-58 | JMX メトリクス | E-11 | ○ |
| C-59 | Prometheus メトリクス | E-11 | ○ |
| C-60 | Graphite メトリクス | E-11 | ○ |
| C-61 | InfluxDB メトリクス | E-11 | ○ |
| C-62 | Datadog メトリクス | E-11 | ○ |
| C-63 | StatsD メトリクス | E-11 | ○ |
| C-64 | SLF4J メトリクス | E-11 | ○ |
| C-65 | OpenTelemetry メトリクス | E-11 | ○ |
| C-66 | Dropwizard メトリクス | E-11 | ○ |
| C-67 | YARN デプロイメント | E-01, E-02, E-12 | ○ |
| C-68 | Kubernetes デプロイメント | E-01, E-13 | ○ |
| C-69 | スタンドアロン デプロイメント | E-01 | ○ |
| C-70 | コンテナ サポート | E-01 | ○ |
| C-71 | RPCシステム | E-01, E-14 | ○ |
| C-72 | Pekko RPC | E-14 | ○ |
| C-73 | CEP | E-02, E-15 | ○ |
| C-74 | State Processing API | E-15 | ○ |
| C-75 | クエリアブルステートクライアント | E-16 | ○ |
| C-76 | クエリアブルステートランタイム | E-16 | ○ |
| C-77 | PyFlink DataStream | E-17 | ○ |
| C-78 | PyFlink Table | E-17 | ○ |
| C-79 | PyFlinkコネクタ | E-17 | ○ |
| C-80 | PyFlinkフォーマット | E-17 | ○ |
| C-81 | Flink CLI | E-01, E-18 | ○ |
| C-82 | ストリーム例 | E-19 | ○ |
| C-83 | Table例 | E-19 | ○ |
| C-84 | チュートリアル | E-01 | ○ |
| C-85 | テストユーティリティ | E-01 | ○ |
| C-86 | API アノテーション | E-01 | ○ |
| C-87 | 依存性チェック | E-01 | ○ |
| C-88 | ドキュメント生成 | E-01 | ○ |
| C-89 | プロジェクトテンプレート | E-01 | ○ |
| C-90 | GPUリソース | E-01 | ○ |
| C-91 | ステートログ | E-01 | ○ |
| C-92 | 機械学習モデル | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全ての機能はソースコードのディレクトリ構成、pom.xml、README.md等から確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能はプロジェクトのソースコード構造から直接確認可能
- 備考：外部化されたコネクタ（Kafka, Elasticsearch, MongoDB等）はREADME.mdに記載されているが、本プロジェクトには含まれていないため機能一覧には含めていない

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か確認する
- [ ] 機能の説明が正確か確認する
- [ ] 重要な機能の抜け漏れがないか確認する
- [ ] モジュール名（備考欄）が正確か確認する
- [ ] 外部化されたコネクタを含める必要があるか検討する
