# 機能設計書 23-ジョブ管理

## 概要

本ドキュメントは、Apache Flinkのジョブ管理機能（flink-runtime モジュール内JobMaster）の設計仕様を記述する。ジョブ管理機能は、Flinkジョブのスケジューリング、タスク実行監視、障害復旧を担当するJobManager/JobMasterコンポーネントが提供する。

### 本機能の処理概要

JobMasterは、単一のFlinkジョブ（ExecutionPlan）の実行を担当するコンポーネントであり、タスクの配置・監視・チェックポイント調整・リソース要求を行う。

**業務上の目的・背景**：分散ストリーム/バッチ処理において、ジョブの実行計画を実際のタスク実行に変換し、クラスタ全体でのタスク配置と監視を行う。障害発生時の自動復旧やチェックポイントによる状態保存を通じて、Exactly-once処理保証を実現する。

**機能の利用シーン**：
- Flinkジョブのサブミットと実行開始
- ジョブの実行状態監視とメトリクス収集
- タスク障害時の自動復旧
- チェックポイント/セーブポイントのトリガー
- ジョブのキャンセルとリソース解放

**主要な処理内容**：
1. ExecutionGraphの作成とタスクへの分解
2. ResourceManagerとの連携によるスロット取得
3. TaskManagerへのタスクデプロイ
4. タスク実行状態の監視とハートビート管理
5. チェックポイントの調整（CheckpointCoordinator経由）
6. 障害検出とリカバリ処理

**関連システム・外部連携**：
- ResourceManager（リソース割り当て）
- TaskManager（タスク実行）
- HighAvailabilityServices（HAサービス）
- CheckpointCoordinator（チェックポイント）

**権限による制御**：JobMasterIdによる認証、FencingTokenによる分散環境での一貫性保証。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行中ジョブ一覧 | 主機能 | 実行中ジョブ一覧の取得・表示 |
| 4 | 完了済みジョブ一覧 | 補助機能 | ジョブステータスのフィルタリング |
| 5 | ジョブ詳細 | 補助機能 | ジョブのキャンセル操作 |
| 6 | ジョブ概要（DAGグラフ） | 補助機能 | サブタスク情報の取得 |
| 8 | 例外情報 | 補助機能 | 例外履歴の一覧表示 |

## 機能種別

計算処理 / スケジューリング / 障害復旧

## 入力仕様

### 入力パラメータ

#### ジョブサブミット

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| executionPlan | ExecutionPlan | Yes | 実行計画（JobGraph） | 有効なDAG構造 |
| jobMasterConfiguration | JobMasterConfiguration | Yes | JobMaster設定 | 必須設定項目あり |
| highAvailabilityServices | HighAvailabilityServices | Yes | HAサービス | null不可 |

#### タスク状態更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| taskExecutionState | TaskExecutionState | Yes | タスク実行状態 | 有効な状態遷移 |

### 入力データソース

- JobGraph（ユーザーアプリケーションから）
- TaskExecutorからのタスク状態更新
- ResourceManagerからのスロット通知

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| JobStatus | JobStatus | ジョブステータス（CREATED/RUNNING/FINISHED/CANCELED/FAILED） |
| ExecutionGraphInfo | ExecutionGraphInfo | 実行グラフ情報 |
| CheckpointStatsSnapshot | CheckpointStatsSnapshot | チェックポイント統計 |
| AccumulatorSnapshot | AccumulatorSnapshot | アキュムレータ値 |

### 出力先

- REST API（ジョブ情報取得）
- TaskManager（タスクデプロイメント）
- ResourceManager（リソース要求）

## 処理フロー

### 処理シーケンス

```
1. JobMaster起動（onStart）
   └─ startJobExecution() でジョブ実行開始

2. ResourceManagerへ接続
   └─ ResourceManagerLeaderRetrieverでリーダー検出
   └─ registerJobMaster() でジョブ登録

3. スロット要求とタスクデプロイ
   └─ SlotPoolService経由でスロット取得
   └─ SchedulerNGがタスク配置を決定
   └─ TaskExecutorにタスクをデプロイ

4. タスク実行監視
   └─ TaskManagerHeartbeatManagerでハートビート監視
   └─ updateTaskExecutionState() で状態更新受信

5. チェックポイント調整
   └─ CheckpointCoordinatorがチェックポイントトリガー
   └─ acknowledgeCheckpoint() でACK受信

6. ジョブ完了/障害処理
   └─ ジョブステータス更新
   └─ リソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[JobMaster起動] --> B[startJobExecution]
    B --> C[ResourceManager接続]
    C --> D[スロット要求]
    D --> E{スロット取得成功?}
    E -->|Yes| F[タスクデプロイ]
    E -->|No| G[リトライ/失敗]

    F --> H[タスク実行監視]
    H --> I{タスク状態}
    I -->|RUNNING| H
    I -->|FINISHED| J[ジョブ完了]
    I -->|FAILED| K[障害処理]

    K --> L{リカバリ可能?}
    L -->|Yes| F
    L -->|No| M[ジョブ失敗]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ジョブ状態遷移 | CREATED→RUNNING→FINISHED/CANCELED/FAILEDの遷移のみ許可 | 全状態変更時 |
| BR-002 | タスク障害リトライ | 設定されたリトライ回数まで自動リトライ | タスク失敗時 |
| BR-003 | ハートビートタイムアウト | タイムアウト時はTaskManager障害とみなす | ハートビート監視 |
| BR-004 | チェックポイント間隔 | 最小間隔以上の間隔でチェックポイント実行 | チェックポイント時 |

### 計算ロジック

- ExecutionGraphからの並列度計算
- スロット共有による効率的なリソース利用

## データベース操作仕様

### 操作別データベース影響一覧

本機能は直接データベースを操作しない。チェックポイントストレージへの保存は別機能で実施。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| JobMasterException | システムエラー | JobMaster起動失敗 | 設定確認・再試行 |
| FlinkException | システムエラー | タスクデプロイ失敗 | リソース確認 |
| TimeoutException | タイムアウト | RPC呼び出しタイムアウト | タイムアウト設定調整 |
| FlinkJobNotFoundException | ビジネスエラー | 存在しないジョブへのアクセス | ジョブID確認 |

### リトライ仕様

- タスク障害時: 設定された回数までリトライ
- ResourceManager接続失敗時: 定期的に再接続を試行

## トランザクション仕様

分散トランザクションはチェックポイントによるExactly-once保証で実現。

## パフォーマンス要件

- ジョブ起動: 数秒以内
- タスク状態更新処理: ミリ秒オーダー
- ハートビート間隔: デフォルト10秒

## セキュリティ考慮事項

- JobMasterIdによるフェンシングで不正アクセス防止
- SSL/TLSによるRPC通信暗号化（オプション）

## 備考

- Adaptive Schedulerによる動的並列度変更をサポート
- Reactive Modeでの自動スケーリングに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JobMasterで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecutionPlan.java | `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/graph/ExecutionPlan.java` | 実行計画のインターフェース |
| 1-2 | JobMasterId.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterId.java` | JobMaster識別子 |
| 1-3 | TaskManagerRegistration.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/TaskManagerRegistration.java` | TM登録情報 |

#### Step 2: エントリーポイントを理解する

JobMasterの起動とライフサイクルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JobMaster.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMaster.java` | メインクラス |
| 2-2 | JobMasterGateway.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterGateway.java` | RPCインターフェース |

**主要処理フロー**:
1. **253-412行目**: コンストラクタでSchedulerNG、SlotPoolService、HeartbeatManager初期化
2. **472-482行目**: onStart()でstartJobExecution()呼び出し
3. **486-499行目**: onStop()でジョブ停止処理

#### Step 3: スケジューラを理解する

タスクスケジューリングの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SchedulerNG.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/SchedulerNG.java` | スケジューラインターフェース |
| 3-2 | DefaultScheduler.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/DefaultScheduler.java` | デフォルト実装 |
| 3-3 | AdaptiveScheduler.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/AdaptiveScheduler.java` | アダプティブ実装 |

#### Step 4: スロットプールを理解する

リソース管理との連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SlotPoolService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/slotpool/SlotPoolService.java` | スロットプールサービス |

### プログラム呼び出し階層図

```
JobMaster
    │
    ├─ onStart()
    │      └─ startJobExecution()
    │             ├─ startJobMasterServices()
    │             │      ├─ startHeartbeatServices()
    │             │      └─ startResourceManagerConnection()
    │             │
    │             └─ schedulerNG.startScheduling()
    │
    ├─ updateTaskExecutionState()
    │      └─ schedulerNG.updateTaskExecutionState()
    │
    ├─ registerTaskManager()
    │      ├─ taskManagerHeartbeatManager.monitorTarget()
    │      └─ slotPoolService.registerTaskManager()
    │
    └─ acknowledgeCheckpoint()
           └─ schedulerNG.acknowledgeCheckpoint()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JobGraph ──────────────▶ JobMaster ──────────────────▶ ジョブ状態
                              │
                              ▼
                        SchedulerNG
                              │
           ┌──────────────────┼──────────────────┐
           │                  │                  │
           ▼                  ▼                  ▼
    SlotPoolService   CheckpointCoordinator  HeartbeatManager
           │                  │                  │
           ▼                  ▼                  ▼
    ResourceManager    チェックポイント     TaskManager監視
           │             ストレージ              │
           ▼                                     ▼
       スロット割当                         タスク状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JobMaster.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMaster.java` | ソース | JobMasterメインクラス |
| JobMasterGateway.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterGateway.java` | ソース | RPCゲートウェイ |
| JobMasterService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterService.java` | ソース | サービスインターフェース |
| SchedulerNG.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/SchedulerNG.java` | ソース | スケジューラインターフェース |
| SlotPoolService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/slotpool/SlotPoolService.java` | ソース | スロットプール |
| JobManagerSharedServices.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobManagerSharedServices.java` | ソース | 共有サービス |
