# 機能設計書 25-リソース管理

## 概要

本ドキュメントは、Apache Flinkのリソース管理機能（flink-runtime モジュール内ResourceManager）の設計仕様を記述する。リソース管理機能は、クラスタ全体のリソース（スロット）の管理と割り当てを担当する。

### 本機能の処理概要

ResourceManagerは、Flinkクラスタのリソースを一元管理するコンポーネントであり、TaskExecutorの登録管理、スロットの割り当て、およびリソースの動的スケーリングを担当する。

**業務上の目的・背景**：分散クラスタにおいて、複数のジョブからのリソース要求を効率的に管理し、リソースの公平な配分と最適な利用を実現する。YARN、Kubernetes、スタンドアロンなど様々なデプロイメント環境に対応。

**機能の利用シーン**：
- TaskExecutorのクラスタ登録
- ジョブからのスロット要求への応答
- リソースの動的スケーリング（拡張/縮小）
- TaskExecutor障害時のリソース再割り当て

**主要な処理内容**：
1. TaskExecutorの登録とハートビート監視
2. JobMasterからのスロット要求の受付
3. SlotManagerによるスロット割り当て決定
4. リソースの動的割り当て（Active RM）
5. クラスタパーティションの追跡

**関連システム・外部連携**：
- JobMaster（スロット要求）
- TaskExecutor（リソース登録）
- YARN/Kubernetes/Mesos（外部リソース管理）
- HighAvailabilityServices（HAサービス）

**権限による制御**：ResourceManagerIdによるフェンシング、セキュリティトークンによる認証。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ジョブ概要（DAGグラフ） | 補助機能 | ジョブリソース要件の変更 |
| 31 | TaskManager一覧 | 関連機能 | TaskManagerリソース情報表示 |

## 機能種別

リソース管理 / クラスタ管理

## 入力仕様

### 入力パラメータ

#### JobMaster登録

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| jobMasterId | JobMasterId | Yes | JobMaster識別子 | null不可 |
| jobId | JobID | Yes | ジョブID | UUID形式 |
| resourceId | ResourceID | Yes | リソースID | null不可 |

#### TaskExecutor登録

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| taskExecutorRegistration | TaskExecutorRegistration | Yes | TM登録情報 | null不可 |
| slotReport | SlotReport | Yes | スロットレポート | null不可 |

### 入力データソース

- JobMasterからのスロット要求
- TaskExecutorからの登録とスロットレポート
- HAサービスからのリーダー選出通知

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RegistrationResponse | RegistrationResponse | 登録結果 |
| Acknowledge | Acknowledge | 処理確認 |
| ClusterOverview | ClusterOverview | クラスタ概要 |

### 出力先

- JobMaster（スロット割り当て通知）
- TaskExecutor（登録確認）
- REST API（クラスタ情報）

## 処理フロー

### 処理シーケンス

```
1. ResourceManager起動
   └─ HAサービスでリーダー選出
   └─ onStart() でサービス開始

2. TaskExecutor登録
   └─ registerTaskExecutor() で登録受付
   └─ SlotManager.registerTaskManager() でスロット登録
   └─ ハートビート監視開始

3. JobMaster登録
   └─ registerJobMaster() でジョブ登録
   └─ ハートビート監視開始

4. スロット要求処理
   └─ declareRequiredResources() でリソース要求
   └─ SlotManager.processResourceRequirements()
   └─ 必要に応じてリソース割り当て

5. リソース解放
   └─ ジョブ完了/キャンセル時
   └─ スロット解放とリソース回収
```

### フローチャート

```mermaid
flowchart TD
    A[ResourceManager起動] --> B[HAリーダー選出]
    B --> C{リーダー?}
    C -->|Yes| D[サービス開始]
    C -->|No| E[スタンバイ]

    D --> F[TaskExecutor登録受付]
    D --> G[JobMaster登録受付]

    F --> H[SlotManager登録]
    G --> I[ジョブ管理登録]

    H --> J[スロット要求処理]
    I --> J

    J --> K{リソース十分?}
    K -->|Yes| L[スロット割り当て]
    K -->|No| M[リソース要求]

    M --> N[新規TaskExecutor起動]
    N --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | リーダー選出 | 単一のResourceManagerのみがアクティブ | HA環境 |
| BR-002 | スロット割り当て | 要求に最も適合するスロットを割り当て | スロット要求時 |
| BR-003 | ハートビートタイムアウト | タイムアウト時はコンポーネント障害とみなす | 監視時 |
| BR-004 | リソーススケーリング | 最小/最大リソース数の範囲内でスケール | Active RM |

### 計算ロジック

- スロットマッチング（リソースプロファイル比較）
- リソース要求量の計算

## データベース操作仕様

### 操作別データベース影響一覧

本機能は直接データベースを操作しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ResourceManagerException | システムエラー | RM起動失敗 | 設定確認・再起動 |
| UnknownTaskExecutorException | ビジネスエラー | 未登録TM操作 | TM登録確認 |
| DuplicateJobSubmissionException | ビジネスエラー | 重複ジョブ登録 | ジョブID確認 |

### リトライ仕様

- リーダー選出失敗時: HAサービスが再選出
- TaskExecutor登録失敗時: TM側で再登録

## トランザクション仕様

リソース割り当てはSlotManager内で原子的に処理。

## パフォーマンス要件

- 登録処理: 100ms以内
- スロット割り当て決定: 数十ミリ秒

## セキュリティ考慮事項

- ResourceManagerIdによるフェンシング
- DelegationTokenによる認証（Hadoop連携時）

## 備考

- StandaloneResourceManager: スタンドアロン環境向け
- YarnResourceManager: YARN環境向け
- KubernetesResourceManager: Kubernetes環境向け

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ResourceManagerで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourceManagerId.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManagerId.java` | RM識別子 |
| 1-2 | SlotReport.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/SlotReport.java` | スロットレポート |
| 1-3 | ResourceRequirements.java | `flink-runtime/src/main/java/org/apache/flink/runtime/slots/ResourceRequirements.java` | リソース要求 |

#### Step 2: エントリーポイントを理解する

ResourceManagerの起動とライフサイクルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourceManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManager.java` | 抽象基底クラス |
| 2-2 | ResourceManagerGateway.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManagerGateway.java` | RPCインターフェース |

**主要処理フロー**:
1. **179-200行目**: コンストラクタでSlotManager、HeartbeatServices初期化
2. **onStart()**: サービス開始、ハートビートマネージャ作成
3. **registerJobMaster()**: JobMaster登録処理
4. **registerTaskExecutor()**: TaskExecutor登録処理

#### Step 3: スロット管理を理解する

スロット割り当ての仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SlotManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/slotmanager/SlotManager.java` | スロット管理 |

### プログラム呼び出し階層図

```
ResourceManager
    │
    ├─ onStart()
    │      └─ startHeartbeatServices()
    │
    ├─ registerJobMaster()
    │      ├─ jobManagerRegistrations.put()
    │      └─ jobManagerHeartbeatManager.monitorTarget()
    │
    ├─ registerTaskExecutor()
    │      ├─ taskExecutors.put()
    │      ├─ taskManagerHeartbeatManager.monitorTarget()
    │      └─ slotManager.registerTaskManager()
    │
    └─ declareRequiredResources()
           └─ slotManager.processResourceRequirements()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JobMaster ──────────────▶ ResourceManager ───────────▶ スロット割り当て
(スロット要求)                  │
                              ▼
                         SlotManager
                              │
TaskExecutor ──────────▶     │
(登録)                        ▼
                    スロット管理・マッチング
                              │
                              ▼
                    ResourceAllocator
                    (Active RM)
                              │
                              ▼
                    YARN/K8s/Standalone
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourceManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManager.java` | ソース | RM抽象基底クラス |
| ResourceManagerGateway.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManagerGateway.java` | ソース | RPCゲートウェイ |
| SlotManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/slotmanager/SlotManager.java` | ソース | スロット管理 |
| ResourceAllocator.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/slotmanager/ResourceAllocator.java` | ソース | リソース割り当て |
| JobManagerRegistration.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/registration/JobManagerRegistration.java` | ソース | JM登録情報 |
| WorkerRegistration.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/registration/WorkerRegistration.java` | ソース | Worker登録情報 |
