# 機能設計書 32-REST API

## 概要

本ドキュメントは、Apache FlinkのREST API機能について記載する。この機能は、Flink Web UIおよび外部システムからFlinkクラスタを監視・操作するためのHTTP RESTfulインターフェースを提供する。

### 本機能の処理概要

REST APIは、Flinkクラスタの状態監視、ジョブ管理、メトリクス取得、設定確認などの操作をHTTPベースのAPIとして公開する。Nettyベースの非同期HTTPサーバー上で動作し、JSON形式でデータをやり取りする。

**業務上の目的・背景**：Flinkクラスタの運用において、コマンドラインだけでなくHTTPベースのAPIを通じてプログラマティックに操作できることが必要である。CI/CDパイプラインとの統合、監視システムからのメトリクス収集、Web UIでの状態表示など、多様なユースケースに対応する。

**機能の利用シーン**：
- Flink Web UIからのクラスタ・ジョブ状態表示
- 外部監視システム（Prometheus、Grafana等）からのメトリクス収集
- デプロイスクリプトからのジョブ投入・キャンセル
- History Serverでの完了ジョブ履歴表示

**主要な処理内容**：
1. クラスタ概要取得（/overview）：TaskManager数、スロット数、ジョブ数の取得
2. ジョブ一覧・詳細取得（/jobs）：実行中・完了ジョブの情報取得
3. メトリクス取得（/metrics）：JobManager、TaskManager、ジョブのメトリクス
4. JARアップロード・実行（/jars）：ジョブJARのアップロードと実行
5. チェックポイント・セーブポイント管理
6. ログ・スレッドダンプ取得

**関連システム・外部連携**：
- Flink Web UI（フロントエンド）
- History Server
- 外部監視システム（Prometheus等）
- CI/CDツール

**権限による制御**：認証・認可は設定により有効化可能。SSL/TLS暗号化、認証トークン方式等をサポート。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | オーバービュー | 主機能 | クラスター概要情報の取得・表示 |
| 2 | ジョブサブミット | 主機能 | JARアップロード・ジョブ実行 |
| 3-4 | 実行中/完了済みジョブ一覧 | 主機能 | ジョブ一覧取得 |
| 5-11 | ジョブ詳細各画面 | 主機能 | ジョブ詳細情報取得 |
| 22-30 | JobManager関連画面 | 主機能 | JobManagerメトリクス・ログ取得 |
| 31-39 | TaskManager関連画面 | 主機能 | TaskManager情報取得 |

## 機能種別

データ取得 / API提供 / システム監視

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| jobId | JobID (hex) | エンドポイント依存 | ジョブ識別子 | 32桁16進数 |
| vertexId | String (hex) | エンドポイント依存 | 頂点識別子 | 32桁16進数 |
| taskManagerId | String | エンドポイント依存 | TaskManager識別子 | 有効なID形式 |
| parallelism | int | No | 並列度 | 正の整数 |
| savepointPath | String | No | セーブポイントパス | 有効なファイルパス |

### 入力データソース

- HTTPリクエスト（GET/POST/DELETE/PATCH）
- マルチパートフォームデータ（JARアップロード）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| レスポンスボディ | JSON | 各APIの応答データ |
| HTTPステータス | int | 200:成功、4xx:クライアントエラー、5xx:サーバーエラー |
| Content-Type | String | application/json |

### 出力先

HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ NettyサーバーがHTTPリクエストを受信

2. ルーティング
   └─ URLパスに基づいて適切なハンドラを特定

3. リクエストパース
   └─ パスパラメータ、クエリパラメータ、ボディのパース

4. ゲートウェイ取得
   └─ リーダー選出されたJobManagerのゲートウェイを取得

5. ビジネスロジック実行
   └─ 対応するハンドラでリクエスト処理

6. レスポンス生成
   └─ 結果をJSON形式でシリアライズ

7. HTTPレスポンス送信
   └─ クライアントへレスポンスを返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト] --> B[Nettyサーバー]
    B --> C[ルーティング]
    C --> D{ハンドラ特定}
    D -->|見つからない| E[404 Not Found]
    D -->|見つかる| F[AbstractHandler]
    F --> G[リーダーゲートウェイ取得]
    G --> H{リーダー可用?}
    H -->|No| I[503 Service Unavailable]
    H -->|Yes| J[handleRequest実行]
    J --> K{処理成功?}
    K -->|Yes| L[200 OK + JSON]
    K -->|No| M[エラーレスポンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | JSONレスポンス | すべてのAPI応答はJSON形式 | 全エンドポイント |
| BR-32-02 | 非同期操作 | 長時間操作は非同期APIとして提供 | セーブポイント作成等 |
| BR-32-03 | エラー形式 | エラー応答はErrorResponseBody形式 | エラー発生時 |
| BR-32-04 | バージョニング | APIはFlinkバージョンと互換性維持 | 全エンドポイント |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | RDBMSは使用しない |

### テーブル別操作詳細

該当なし（インメモリデータおよびファイルシステムを使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | Bad Request | リクエストパラメータ不正 | リクエスト内容を確認 |
| 404 | Not Found | リソースが存在しない | リソースIDを確認 |
| 500 | Internal Server Error | サーバー内部エラー | ログを確認 |
| 503 | Service Unavailable | リーダー未選出 | クラスタ状態を確認 |

### リトライ仕様

クライアント側で実装（APIはステートレス）

## トランザクション仕様

該当なし（HTTPはステートレスプロトコル）

## パフォーマンス要件

- 一般的なAPI呼び出し：100ms以内
- メトリクス取得：数百ms（集計処理含む）
- JARアップロード：ファイルサイズ依存

## セキュリティ考慮事項

- SSL/TLS暗号化サポート
- 認証機能（Kerberos、LDAP、カスタム認証）
- CSRFトークン
- CORS設定

## 備考

- Netty 4.xベースの非同期HTTPサーバー
- Jackson（JSON処理）使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基盤クラスを理解する

RESTハンドラの基底クラスと共通処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractHandler.java | `flink-runtime/src/main/java/org/apache/flink/runtime/rest/handler/` | REST APIの基底ハンドラ、リクエスト処理フロー |
| 1-2 | HandlerRequest.java | `flink-runtime/src/main/java/org/apache/flink/runtime/rest/handler/` | リクエストのラップクラス |
| 1-3 | RestHandlerException.java | `flink-runtime/src/main/java/org/apache/flink/runtime/rest/handler/` | REST例外定義 |

**読解のコツ**: AbstractHandlerのchannelRead0()メソッドがリクエスト処理のエントリーポイント。handleRequest()を実装することで具体的な処理を定義する。

#### Step 2: クラスタ情報APIを理解する

クラスタ概要やJobManager情報を取得するハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClusterOverviewHandler.java | `flink-runtime/.../rest/handler/cluster/` | クラスタ概要取得 |
| 2-2 | ClusterConfigHandler.java | `flink-runtime/.../rest/handler/cluster/` | クラスタ設定取得 |
| 2-3 | DashboardConfigHandler.java | `flink-runtime/.../rest/handler/cluster/` | ダッシュボード設定 |

#### Step 3: ジョブ関連APIを理解する

ジョブの一覧・詳細を取得するハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | JobDetailsHandler.java | `flink-runtime/.../rest/handler/job/` | ジョブ詳細取得 |
| 3-2 | JobExceptionsHandler.java | `flink-runtime/.../rest/handler/job/` | 例外情報取得 |
| 3-3 | JobConfigHandler.java | `flink-runtime/.../rest/handler/job/` | ジョブ設定取得 |

#### Step 4: JAR管理APIを理解する

JARアップロード・実行関連のハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | JarUploadHandler.java | `flink-runtime-web/.../handlers/` | JARアップロード処理 |
| 4-2 | JarRunHandler.java | `flink-runtime-web/.../handlers/` | JAR実行処理 |
| 4-3 | JarListHandler.java | `flink-runtime-web/.../handlers/` | JAR一覧取得 |

### プログラム呼び出し階層図

```
HTTPリクエスト
    │
    ├─ Netty Pipeline
    │      ├─ HttpServerCodec
    │      ├─ FlinkHttpObjectAggregator
    │      ├─ ChunkedWriteHandler
    │      ├─ FileUploadHandler
    │      └─ RouterHandler
    │
    ├─ AbstractHandler.channelRead0()
    │      ├─ リクエストパース
    │      ├─ GatewayRetriever.getGateway()
    │      └─ handleRequest()
    │             │
    │             ├─ ClusterOverviewHandler
    │             ├─ JobDetailsHandler
    │             ├─ JarUploadHandler
    │             └─ その他具体ハンドラ
    │
    └─ レスポンス送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTP Request ───────────▶ Netty Server ──────────────▶ HTTP Response
     │                         │                            │
     │                         ▼                            │
     │                   RouterHandler                      │
     │                         │                            │
     │                         ▼                            │
     │              AbstractHandler.handleRequest()         │
     │                         │                            │
     │           ┌─────────────┼─────────────┐              │
     │           ▼             ▼             ▼              │
     │    ClusterAPI      JobAPI       JarAPI              │
     │           │             │             │              │
     │           ▼             ▼             ▼              │
     │    RestfulGateway (RPC呼び出し)                     │
     │                         │                            │
     └─────────────────────────┴────────────────────────────┘
                        JSON Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractHandler.java | `flink-runtime/.../rest/handler/` | 基底クラス | REST APIハンドラの基盤 |
| ClusterOverviewHandler.java | `flink-runtime/.../rest/handler/cluster/` | ハンドラ | クラスタ概要取得 |
| JobDetailsHandler.java | `flink-runtime/.../rest/handler/job/` | ハンドラ | ジョブ詳細取得 |
| JarUploadHandler.java | `flink-runtime-web/.../handlers/` | ハンドラ | JARアップロード |
| JarRunHandler.java | `flink-runtime-web/.../handlers/` | ハンドラ | ジョブ実行 |
| TaskManagersHandler.java | `flink-runtime/.../rest/handler/taskmanager/` | ハンドラ | TM一覧取得 |
| CheckpointingStatisticsHandler.java | `flink-runtime/.../rest/handler/job/checkpoints/` | ハンドラ | チェックポイント統計 |
| MetricStore.java | `flink-runtime/.../rest/handler/legacy/metrics/` | ストア | メトリクス保持 |
| WebSubmissionExtension.java | `flink-runtime-web/` | 拡張 | JAR関連APIの登録 |
| HistoryServer.java | `flink-runtime-web/.../history/` | サーバー | 履歴サーバー |
