# 機能設計書 33-HashMapStateBackend

## 概要

本ドキュメントは、Apache FlinkのHashMapStateBackend機能について記載する。この機能は、ストリーム処理におけるステート（状態）をJVMヒープメモリ上に保持するステートバックエンドである。

### 本機能の処理概要

HashMapStateBackendは、Flinkストリーム処理のキー付きステートをTaskManagerのJVMヒープ上にJava HashMapとして保持する。シンプルで高速なステートアクセスを提供し、小〜中規模のステートを扱うジョブに適している。

**業務上の目的・背景**：ストリーム処理では、ウィンドウ集計やセッション管理などのために状態を保持する必要がある。HashMapStateBackendは、追加の外部システムを必要とせず、純粋なJavaオブジェクトとしてステートを保持するため、開発・テスト環境や小規模本番環境で広く利用される。

**機能の利用シーン**：
- 開発・テスト環境でのストリーム処理ジョブ実行
- ステートサイズが各TaskManagerのメモリに収まる本番ジョブ
- 低レイテンシが要求されるステートアクセス
- シンプルなデプロイメントが求められる環境

**主要な処理内容**：
1. キー付きステートの作成・取得・更新・削除
2. オペレーターステートの管理
3. チェックポイント時のステートスナップショット
4. 障害復旧時のステートリストア
5. 優先度キュー（タイマー）の管理

**関連システム・外部連携**：
- CheckpointStorage：チェックポイントの永続化先
- HDFS/S3/GCS等の分散ファイルシステム
- チェックポイントコーディネーター

**権限による制御**：特定のロールによる制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面とは直接関連しない（バックエンド処理） |

## 機能種別

状態管理 / データ永続化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| state.backend | String | No | ステートバックエンド種別（"hashmap"） | 有効なバックエンド名 |
| state.backend.latency-track.* | - | No | レイテンシトラッキング設定 | - |
| execution.checkpointing.* | - | No | チェックポイント関連設定 | - |

### 入力データソース

- Flink設定ファイル（flink-conf.yaml）
- プログラムによるAPI設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| StateSnapshot | byte[] | チェックポイント時のシリアライズ済みステート |
| KeyedState | Object | キー付きステート（Value/List/Map/Aggregating/Reducing） |

### 出力先

- JVMヒープメモリ（ランタイムステート）
- CheckpointStorage（チェックポイント時）

## 処理フロー

### 処理シーケンス

```
1. ステートバックエンド初期化
   └─ HashMapStateBackendインスタンス作成

2. キー付きステートバックエンド作成
   └─ HeapKeyedStateBackendBuilderでバックエンド構築

3. ステート操作
   └─ get/update/clear等のステート操作

4. チェックポイント実行
   └─ ステートのスナップショットを取得し、CheckpointStorageに書き込み

5. リストア
   └─ CheckpointStorageからステートを読み込み、復元
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[HashMapStateBackend設定]
    B --> C[HeapKeyedStateBackendBuilder]
    C --> D[HeapKeyedStateBackend作成]
    D --> E[ステート操作]
    E --> F{チェックポイント?}
    F -->|Yes| G[スナップショット作成]
    G --> H[CheckpointStorage書き込み]
    H --> E
    F -->|No| E
    E --> I{障害発生?}
    I -->|Yes| J[最新チェックポイントからリストア]
    J --> D
    I -->|No| E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | メモリ制限 | ステートサイズはTaskManagerヒープサイズ以下 | 常時 |
| BR-33-02 | フルスナップショット | 毎回フルスナップショットを取得 | チェックポイント時 |
| BR-33-03 | 非共有ファイル | ファイル共有なし（増分チェックポイント非対応） | チェックポイント時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | RDBMSは使用しない |

### テーブル別操作詳細

該当なし（インメモリおよびCheckpointStorageを使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OOM | OutOfMemoryError | ステートがヒープを超過 | ヒープサイズ増加またはRocksDBへ変更 |
| SERIAL | SerializationException | ステートシリアライズ失敗 | シリアライザ設定確認 |
| RESTORE | BackendBuildingException | リストア失敗 | チェックポイントファイル確認 |

### リトライ仕様

チェックポイント失敗時はFlink設定に基づきリトライ

## トランザクション仕様

チェックポイントバリア通過時点でアトミックにスナップショット取得

## パフォーマンス要件

- ステートアクセス：ミリ秒以下（HashMap直接アクセス）
- チェックポイント：ステートサイズに比例

## セキュリティ考慮事項

ヒープ上のデータは暗号化されない。機密データの場合は上位レイヤーでの暗号化を検討。

## 備考

- 大規模ステートにはEmbeddedRocksDBStateBackendを推奨
- No-Claimモードをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインクラスを理解する

HashMapStateBackendの設定と初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HashMapStateBackend.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/hashmap/` | ステートバックエンドの設定、キー付きステートバックエンド生成 |
| 1-2 | HashMapStateBackendFactory.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/hashmap/` | ファクトリクラス、設定からのインスタンス生成 |

**読解のコツ**: HashMapStateBackendはAbstractStateBackendを継承。createKeyedStateBackend()がHeapKeyedStateBackendを生成する。

#### Step 2: キー付きステートバックエンドを理解する

ヒープベースのステート実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HeapKeyedStateBackendBuilder.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/heap/` | ビルダーパターンでのバックエンド構築 |
| 2-2 | HeapKeyedStateBackend.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/heap/` | 実際のステート管理実装 |

**主要処理フロー**:
- **96-125行目 (HashMapStateBackend.java)**: createKeyedStateBackend()でHeapKeyedStateBackendBuilderを使用
- **100-102行目**: HeapPriorityQueueSetFactoryでタイマー用優先度キュー生成

#### Step 3: オペレーターステートを理解する

オペレーターステートのデフォルト実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefaultOperatorStateBackendBuilder.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/` | オペレーターステートバックエンドのビルダー |

**主要処理フロー**:
- **128-138行目 (HashMapStateBackend.java)**: createOperatorStateBackend()でDefaultOperatorStateBackendBuilderを使用

### プログラム呼び出し階層図

```
HashMapStateBackend
    │
    ├─ configure(ReadableConfig, ClassLoader)
    │      └─ 設定値の適用
    │
    ├─ createKeyedStateBackend(KeyedStateBackendParameters)
    │      ├─ HeapPriorityQueueSetFactory生成
    │      ├─ HeapKeyedStateBackendBuilder
    │      │      ├─ LatencyTrackingStateConfig
    │      │      ├─ SizeTrackingStateConfig
    │      │      └─ build()
    │      └─ HeapKeyedStateBackend
    │
    └─ createOperatorStateBackend(OperatorStateBackendParameters)
           └─ DefaultOperatorStateBackendBuilder.build()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

設定 ──────────────────▶ HashMapStateBackend ──────────▶ ステートバックエンド
                               │
                               ▼
                    HeapKeyedStateBackendBuilder
                               │
                               ▼
                    HeapKeyedStateBackend
                               │
        ┌──────────────────────┼──────────────────────┐
        ▼                      ▼                      ▼
  ValueState            ListState              MapState
   (HashMap)            (ArrayList)            (HashMap)
        │                      │                      │
        └──────────────────────┼──────────────────────┘
                               ▼
                     CheckpointStorage
                        (スナップショット)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HashMapStateBackend.java | `flink-runtime/.../state/hashmap/` | メインクラス | ステートバックエンド設定・生成 |
| HashMapStateBackendFactory.java | `flink-runtime/.../state/hashmap/` | ファクトリ | 設定からインスタンス生成 |
| HeapKeyedStateBackend.java | `flink-runtime/.../state/heap/` | 実装クラス | ヒープベースステート管理 |
| HeapKeyedStateBackendBuilder.java | `flink-runtime/.../state/heap/` | ビルダー | バックエンド構築 |
| DefaultOperatorStateBackendBuilder.java | `flink-runtime/.../state/` | ビルダー | オペレーターステート構築 |
| HeapPriorityQueueSetFactory.java | `flink-runtime/.../state/heap/` | ファクトリ | 優先度キュー生成 |
| AbstractStateBackend.java | `flink-runtime/.../state/` | 基底クラス | 共通処理 |
