# 機能設計書 34-RocksDBStateBackend

## 概要

本ドキュメントは、Apache FlinkのRocksDBStateBackend（EmbeddedRocksDBStateBackend）機能について記載する。この機能は、ステートをRocksDBに永続化し、大規模ステートを効率的に管理するステートバックエンドである。

### 本機能の処理概要

EmbeddedRocksDBStateBackendは、Flinkストリーム処理のキー付きステートをRocksDB（組み込みKey-Valueストア）に保存する。RocksDBはローカルディスクにデータを保持するため、JVMヒープサイズを超える大規模なステートを扱うことができる。

**業務上の目的・背景**：大規模なストリーム処理ジョブでは、ステートサイズがTaskManagerのメモリを超えることがある。RocksDBStateBackendは、ディスクにステートをスピルすることで、メモリ制約を超えた処理を可能にする。また、増分チェックポイント機能により、大規模ステートでも効率的なチェックポイントを実現する。

**機能の利用シーン**：
- 大規模ステートを扱う本番ストリーム処理ジョブ
- 増分チェックポイントによる効率的な耐障害性が必要な場合
- ステートサイズが数十GB〜数TBに及ぶ場合
- メモリ効率を重視する環境

**主要な処理内容**：
1. RocksDBインスタンスの初期化・管理
2. キー付きステートのRocksDBへの読み書き
3. 増分/フルチェックポイントの実行
4. SSTファイルの管理とアップロード
5. リストア時のSSTファイルダウンロードとDB再構築

**関連システム・外部連携**：
- RocksDB JNIライブラリ
- CheckpointStorage（HDFS/S3/GCS等）
- ローカルファイルシステム（RocksDB作業ディレクトリ）

**権限による制御**：特定のロールによる制御なし。ファイルシステム権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面とは直接関連しない（バックエンド処理） |

## 機能種別

状態管理 / データ永続化 / 外部ストレージ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| state.backend | String | No | "rocksdb"指定 | 有効なバックエンド名 |
| state.backend.rocksdb.localdir | String | No | RocksDBローカルディレクトリ | 有効なパス |
| state.backend.incremental | boolean | No | 増分チェックポイント有効化 | true/false |
| state.backend.rocksdb.memory.* | - | No | メモリ設定 | 正の数値 |
| state.backend.rocksdb.predefined-options | String | No | 事前定義オプション | DEFAULT/SPINNING_DISK等 |

### 入力データソース

- Flink設定ファイル（flink-conf.yaml）
- プログラムによるAPI設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SSTファイル | File | RocksDBのソート済み文字列テーブル |
| メタデータ | byte[] | チェックポイントメタデータ |
| IncrementalSnapshot | StateHandle | 増分スナップショット参照 |

### 出力先

- ローカルファイルシステム（RocksDBデータ）
- CheckpointStorage（チェックポイント永続化）

## 処理フロー

### 処理シーケンス

```
1. RocksDB初期化
   └─ ネイティブライブラリロード、DBオープン

2. ステート操作
   └─ WriteBatchによるバッチ書き込み

3. 増分チェックポイント
   └─ 新規SSTファイルのみをアップロード

4. フルチェックポイント
   └─ 全SSTファイルをアップロード

5. リストア
   └─ SSTファイルダウンロード、DBリストア
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[RocksDB初期化]
    B --> C[ネイティブライブラリロード]
    C --> D[RocksDB Open]
    D --> E[ステート操作]
    E --> F{チェックポイント?}
    F -->|Yes| G{増分有効?}
    G -->|Yes| H[差分SSTファイル特定]
    H --> I[差分アップロード]
    G -->|No| J[フルスナップショット]
    J --> K[全SSTアップロード]
    I --> E
    K --> E
    F -->|No| E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | JNI必須 | RocksDB JNIライブラリが必要 | 常時 |
| BR-34-02 | 増分推奨 | 大規模ステートでは増分チェックポイント推奨 | ステート > 1GB |
| BR-34-03 | ローカルディスク | RocksDBは高速ローカルディスク（SSD推奨） | 常時 |

### 計算ロジック

増分チェックポイントでは、前回チェックポイント以降に作成された新規SSTファイルのみをアップロード。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | RDBMSは使用しない |

### テーブル別操作詳細

該当なし（RocksDBおよびCheckpointStorageを使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| JNI | UnsatisfiedLinkError | ネイティブライブラリロード失敗 | プラットフォーム対応確認 |
| DISK | IOException | ディスク容量不足 | ディスク空き容量確保 |
| CORRUPT | RocksDBException | DBファイル破損 | チェックポイントからリストア |

### リトライ仕様

JNIライブラリロードは最大3回リトライ

## トランザクション仕様

WriteBatchによるアトミック書き込み。チェックポイント時はRocksDBスナップショット機能を使用。

## パフォーマンス要件

- ステート読み取り：数ミリ秒（キャッシュヒット時）〜数十ミリ秒（ディスクアクセス時）
- 増分チェックポイント：新規SSTファイルサイズに比例

## セキュリティ考慮事項

ローカルディスク上のRocksDBファイルは暗号化されない。機密データの場合はディスク暗号化を検討。

## 備考

- RocksDB 7.x系を使用
- Block Cache、Write Buffer Managerの共有設定が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインクラスを理解する

EmbeddedRocksDBStateBackendの設定と初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EmbeddedRocksDBStateBackend.java | `flink-statebackend-rocksdb/src/main/java/org/apache/flink/state/rocksdb/` | メインクラス、設定オプション、バックエンド生成 |

**読解のコツ**:
- **86-96行目**: クラスコメントで設計意図を把握
- **206-237行目**: コンストラクタで初期化パラメータを確認
- **446-542行目**: createKeyedStateBackend()でRocksDBKeyedStateBackend生成

#### Step 2: RocksDB設定オプションを理解する

RocksDBの細かい設定オプションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RocksDBOptions.java | `flink-statebackend-rocksdb/.../rocksdb/` | 設定オプション定義 |
| 2-2 | RocksDBConfigurableOptions.java | `flink-statebackend-rocksdb/.../rocksdb/` | 設定可能オプション |
| 2-3 | PredefinedOptions.java | `flink-statebackend-rocksdb/.../rocksdb/` | 事前定義オプション |

#### Step 3: スナップショット戦略を理解する

増分チェックポイントの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RocksIncrementalSnapshotStrategy.java | `flink-statebackend-rocksdb/.../snapshot/` | 増分スナップショット |
| 3-2 | RocksNativeFullSnapshotStrategy.java | `flink-statebackend-rocksdb/.../snapshot/` | フルスナップショット |

### プログラム呼び出し階層図

```
EmbeddedRocksDBStateBackend
    │
    ├─ ensureRocksDBIsLoaded(tempDir)
    │      └─ NativeLibraryLoader.loadLibrary()
    │
    ├─ createKeyedStateBackend()
    │      ├─ RocksDBOperationUtils.allocateSharedCachesIfConfigured()
    │      ├─ RocksDBResourceContainer
    │      ├─ RocksDBKeyedStateBackendBuilder
    │      │      ├─ enableIncrementalCheckpointing設定
    │      │      ├─ setNativeMetricOptions()
    │      │      └─ build()
    │      └─ RocksDBKeyedStateBackend
    │
    └─ createOperatorStateBackend()
           └─ DefaultOperatorStateBackendBuilder.build()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

設定 ──────────────────▶ EmbeddedRocksDBStateBackend ──▶ ステートバックエンド
                               │
                               ▼
                    RocksDBKeyedStateBackendBuilder
                               │
                               ▼
                    RocksDBKeyedStateBackend
                               │
        ┌──────────────────────┼──────────────────────┐
        ▼                      ▼                      ▼
  RocksDBValueState    RocksDBListState      RocksDBMapState
        │                      │                      │
        └──────────────────────┼──────────────────────┘
                               ▼
                          RocksDB
                        (SSTファイル)
                               │
                               ▼
                     CheckpointStorage
                   (増分/フルスナップショット)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EmbeddedRocksDBStateBackend.java | `flink-statebackend-rocksdb/.../rocksdb/` | メインクラス | ステートバックエンド |
| RocksDBKeyedStateBackend.java | `flink-statebackend-rocksdb/.../rocksdb/` | 実装クラス | キー付きステート管理 |
| RocksDBKeyedStateBackendBuilder.java | `flink-statebackend-rocksdb/.../rocksdb/` | ビルダー | バックエンド構築 |
| RocksIncrementalSnapshotStrategy.java | `flink-statebackend-rocksdb/.../snapshot/` | スナップショット | 増分チェックポイント |
| RocksDBResourceContainer.java | `flink-statebackend-rocksdb/.../rocksdb/` | リソース管理 | RocksDBリソース |
| RocksDBOptions.java | `flink-statebackend-rocksdb/.../rocksdb/` | 設定 | 設定オプション定義 |
| RocksDBValueState.java | `flink-statebackend-rocksdb/.../rocksdb/` | ステート実装 | ValueState |
| RocksDBWriteBatchWrapper.java | `flink-statebackend-rocksdb/.../rocksdb/` | ラッパー | バッチ書き込み |
