# 機能設計書 35-ForStStateBackend

## 概要

本ドキュメントは、Apache FlinkのForStStateBackend機能について記載する。この機能は、ForSt（Fork of RocksDB）をベースにした次世代ステートバックエンドであり、リモートストレージへの直接書き込みと非同期ステートアクセスをサポートする。

### 本機能の処理概要

ForStStateBackendは、RocksDBのフォークであるForStをベースにしたステートバックエンドである。従来のRocksDBStateBackendと比較して、リモートファイルシステムへの直接書き込み、非同期ステートアクセスAPI、改良されたリソース管理機能を提供する。

**業務上の目的・背景**：クラウドネイティブ環境では、ローカルディスクよりもリモートストレージ（S3、GCS等）を直接利用したいケースがある。ForStStateBackendは、リモートストレージをプライマリストレージとして使用可能にし、ローカルディスクへの依存を削減する。また、非同期ステートAPIにより、高スループットな処理を実現する。

**機能の利用シーン**：
- クラウドネイティブ環境でのストリーム処理
- ローカルディスク容量が限られた環境
- 非同期ステートアクセスによる高スループット処理
- チェックポイントストレージとステートストレージの統合

**主要な処理内容**：
1. ForSt（RocksDBフォーク）インスタンスの初期化
2. リモートファイルシステムへの直接書き込み
3. 非同期ステートアクセスAPI（AsyncKeyedStateBackend）
4. 増分チェックポイントの実行
5. ファイルキャッシュ管理

**関連システム・外部連携**：
- ForSt JNIライブラリ
- リモートファイルシステム（S3、GCS、HDFS等）
- ローカルファイルシステム（キャッシュ用）

**権限による制御**：特定のロールによる制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面とは直接関連しない（バックエンド処理） |

## 機能種別

状態管理 / データ永続化 / クラウドネイティブストレージ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| state.backend | String | No | "forst"指定 | 有効なバックエンド名 |
| state.backend.forst.primary-directory | String | No | プライマリディレクトリ | 有効なパス |
| state.backend.forst.local-directories | String | No | ローカルディレクトリ | 有効なパス |
| state.backend.forst.memory.* | - | No | メモリ設定 | 正の数値 |

### 入力データソース

- Flink設定ファイル（flink-conf.yaml）
- プログラムによるAPI設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SSTファイル | File | ForStのソート済み文字列テーブル |
| メタデータ | byte[] | チェックポイントメタデータ |

### 出力先

- ローカルファイルシステム（キャッシュ）
- リモートファイルシステム（プライマリストレージ）
- CheckpointStorage

## 処理フロー

### 処理シーケンス

```
1. ForSt初期化
   └─ ネイティブライブラリロード、リソースコンテナ作成

2. 非同期ステートバックエンド作成
   └─ ForStKeyedStateBackend（非同期）またはForStSyncKeyedStateBackend（同期）

3. ステート操作
   └─ 非同期または同期でのステートアクセス

4. チェックポイント
   └─ リモートストレージへの直接書き込み

5. リストア
   └─ リモートストレージからのデータ取得
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[ForSt初期化]
    B --> C{非同期モード?}
    C -->|Yes| D[ForStKeyedStateBackend]
    C -->|No| E[ForStSyncKeyedStateBackend]
    D --> F[非同期ステート操作]
    E --> G[同期ステート操作]
    F --> H[チェックポイント]
    G --> H
    H --> I[リモートストレージ書き込み]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | 実験的機能 | ForStは@Experimental | 常時 |
| BR-35-02 | ネイティブ形式のみ | SavepointはNATIVE形式のみサポート | セーブポイント時 |
| BR-35-03 | 増分のみ | 現在は増分チェックポイントのみサポート | チェックポイント時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | RDBMSは使用しない |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| JNI | UnsatisfiedLinkError | ネイティブライブラリロード失敗 | プラットフォーム対応確認 |
| REMOTE | IOException | リモートストレージアクセス失敗 | ネットワーク・権限確認 |

### リトライ仕様

JNIライブラリロードは最大3回リトライ

## トランザクション仕様

ForStのスナップショット機能によるアトミックなチェックポイント

## パフォーマンス要件

- 非同期ステートアクセス：高スループット処理に対応
- リモートストレージ直接書き込み：チェックポイント時間短縮

## セキュリティ考慮事項

リモートストレージへのアクセスには適切な認証設定が必要

## 備考

- @Experimental（実験的機能）
- supportsAsyncKeyedStateBackend()がtrueを返す

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインクラスを理解する

ForStStateBackendの設定と初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ForStStateBackend.java | `flink-statebackend-forst/src/main/java/org/apache/flink/state/forst/` | メインクラス、非同期/同期バックエンド生成 |

**読解のコツ**:
- **89-99行目**: クラスコメントで設計意図を把握
- **400-403行目**: supportsAsyncKeyedStateBackend()がtrueを返す
- **405-474行目**: createAsyncKeyedStateBackend()で非同期バックエンド生成
- **476-560行目**: createKeyedStateBackend()で同期バックエンド生成

#### Step 2: 非同期ステートバックエンドを理解する

非同期ステートアクセスの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ForStKeyedStateBackend.java | `flink-statebackend-forst/.../forst/` | 非同期キー付きステートバックエンド |
| 2-2 | ForStKeyedStateBackendBuilder.java | `flink-statebackend-forst/.../forst/` | ビルダー |

### プログラム呼び出し階層図

```
ForStStateBackend
    │
    ├─ supportsAsyncKeyedStateBackend() → true
    │
    ├─ createAsyncKeyedStateBackend()
    │      ├─ ensureForStIsLoaded()
    │      ├─ ForStKeyedStateBackendBuilder
    │      └─ ForStKeyedStateBackend
    │
    └─ createKeyedStateBackend()
           ├─ ensureForStIsLoaded()
           ├─ ForStSyncKeyedStateBackendBuilder
           └─ ForStSyncKeyedStateBackend
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ForStStateBackend.java | `flink-statebackend-forst/.../forst/` | メインクラス | ステートバックエンド |
| ForStKeyedStateBackend.java | `flink-statebackend-forst/.../forst/` | 実装 | 非同期キー付きステート |
| ForStSyncKeyedStateBackend.java | `flink-statebackend-forst/.../forst/sync/` | 実装 | 同期キー付きステート |
| ForStOptions.java | `flink-statebackend-forst/.../forst/` | 設定 | 設定オプション |
| ForStResourceContainer.java | `flink-statebackend-forst/.../forst/` | リソース | リソース管理 |
