# 機能設計書 39-データ生成コネクタ

## 概要

本ドキュメントは、Apache Flinkのデータ生成コネクタ（DataGeneratorSource）機能について記載する。この機能は、N個のデータポイントを並列に生成するソースコネクタであり、テストやイベントストリームの生成に使用される。

### 本機能の処理概要

DataGeneratorSourceは、指定された数のデータポイントを並列に生成するソースである。内部的にはNumberSequenceSourceを使用してLong値のシーケンスを生成し、ユーザー定義のGeneratorFunctionによって任意の型に変換する。レート制限機能も組み込まれている。

**業務上の目的・背景**：ストリーム処理アプリケーションのテストや、合成データの生成が必要な場合がある。DataGeneratorSourceは、決定論的なデータ生成を可能にし、テストの再現性を確保する。また、レート制限機能により、現実的な負荷シミュレーションが可能である。

**機能の利用シーン**：
- 単体テスト・統合テスト用のデータ生成
- パフォーマンステスト用の負荷生成
- デモ・プロトタイプ用のサンプルデータ生成
- ウォーターマーク戦略のテスト

**主要な処理内容**：
1. NumberSequenceSourceによるLongシーケンス生成
2. GeneratorFunctionによるデータ変換
3. RateLimiterStrategyによるレート制限
4. 並列分割による高速生成

**関連システム・外部連携**：
- NumberSequenceSource（内部利用）
- RateLimiterStrategy

**権限による制御**：特定のロールによる制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面とは直接関連しない（データ生成処理） |

## 機能種別

データ生成 / ソースコネクタ / テスト支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| generatorFunction | GeneratorFunction<Long, OUT> | Yes | データ生成関数 | 非null |
| count | long | Yes | 生成するデータ数 | 0以上 |
| typeInfo | TypeInformation<OUT> | Yes | 出力型情報 | 非null |
| rateLimiterStrategy | RateLimiterStrategy | No | レート制限戦略 | デフォルトnoOp() |

### 入力データソース

なし（自己生成）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OUT | ジェネリック型 | GeneratorFunctionで生成されたデータ |

### 出力先

- DataStream<OUT>

## 処理フロー

### 処理シーケンス

```
1. DataGeneratorSource初期化
   └─ NumberSequenceSource(0, count-1)作成

2. SplitEnumerator作成
   └─ 並列度に応じてシーケンスを分割

3. SourceReader作成
   └─ GeneratorSourceReaderFactory経由

4. データ生成
   └─ NumberSequenceSplitからLong値取得
   └─ GeneratorFunction.map()でデータ変換
   └─ RateLimiterで速度制限

5. 完了
   └─ count個のデータ生成後に終了
```

### フローチャート

```mermaid
flowchart TD
    A[DataGeneratorSource作成] --> B[count設定]
    B --> C[GeneratorFunction設定]
    C --> D[SplitEnumerator作成]
    D --> E[シーケンス分割]
    E --> F[SourceReader作成]
    F --> G[Longインデックス取得]
    G --> H[GeneratorFunction.map]
    H --> I{RateLimiter?}
    I -->|Yes| J[レート制限待機]
    J --> K[データ出力]
    I -->|No| K
    K --> L{完了?}
    L -->|No| G
    L -->|Yes| M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | Bounded | 常にBoundedソース | 常時 |
| BR-39-02 | 並列分割 | シーケンスは並列リーダー数に分割 | 並列度>1時 |
| BR-39-03 | 順序保証 | 各サブシーケンスは順序通り生成 | 常時 |
| BR-39-04 | 決定論的 | 同じインデックスは同じ結果を生成 | GeneratorFunction実装依存 |

### 計算ロジック

- シーケンス範囲: 0 から count-1
- count=0の場合: 空のソース（Tableテスト用）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | RDBMSは使用しない |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| GEN | Exception | GeneratorFunction.map()失敗 | 関数実装確認 |
| SPLIT | Exception | スプリット割り当て失敗 | 並列度確認 |

### リトライ仕様

チェックポイントからのリストアによる再開

## トランザクション仕様

- NumberSequenceSplitによる状態管理
- チェックポイントでスプリット状態を保存

## パフォーマンス要件

- RateLimiterStrategy.perSecond(n): 全体でn件/秒
- noOp(): 無制限（可能な限り高速）

## セキュリティ考慮事項

GeneratorFunctionはクロージャクリーニングされる

## 備考

- @Experimental
- Long.MAX_VALUEを指定すると実質無限ストリーム
- ウォーターマーク生成と組み合わせ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: DataGeneratorSourceを理解する

メインクラスの構造とSource API実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DataGeneratorSource.java | `flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/` | Source実装 |

**読解のコツ**:
- **44-93行目**: クラスコメントで設計意図を把握
- **95-98行目**: 実装インターフェース（Source、ResultTypeQueryable、OutputTypeConfigurable）
- **116-121行目**: 基本コンストラクタ（GeneratorFunction、count、typeInfo）
- **131-143行目**: RateLimiterStrategy付きコンストラクタ
- **186-188行目**: getBoundedness()でBOUNDED返却
- **191-194行目**: createReader()でSourceReader作成

#### Step 2: GeneratorFunctionインターフェースを理解する

データ変換関数のインターフェースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GeneratorFunction.java | 同パス | 関数インターフェース |

**読解のコツ**:
- **25-41行目**: インターフェースコメントで使用例を確認
- **43行目**: Function継承
- **49行目**: open()メソッド（初期化）
- **52行目**: close()メソッド（クリーンアップ）
- **54行目**: map()メソッド（データ変換）

#### Step 3: SourceReaderファクトリを理解する

リーダー生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GeneratorSourceReaderFactory.java | 同パス | リーダーファクトリ |
| 3-2 | GeneratingIteratorSourceReader.java | 同パス | リーダー実装 |

### プログラム呼び出し階層図

```
DataGeneratorSource
    │
    ├─ implements Source<OUT, NumberSequenceSplit, Collection<NumberSequenceSplit>>
    │
    ├─ コンストラクタ
    │      ├─ generatorFunction
    │      ├─ count
    │      ├─ rateLimiterStrategy
    │      └─ NumberSequenceSource(0, count-1)
    │
    ├─ createReader(readerContext)
    │      └─ sourceReaderFactory.createReader()
    │             └─ GeneratorSourceReaderFactory
    │                    └─ GeneratingIteratorSourceReader
    │
    ├─ createEnumerator(enumContext)
    │      └─ numberSource.createEnumerator()
    │
    └─ restoreEnumerator(enumContext, checkpoint)
           └─ numberSource.restoreEnumerator()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし ──────────────────▶ DataGeneratorSource ──────────▶ DataStream<OUT>
                               │
                               ├─ NumberSequenceSource
                               │      └─ Long シーケンス (0 to count-1)
                               │
                               ├─ SplitEnumerator
                               │      └─ シーケンス分割
                               │
                               ├─ SourceReader
                               │      ├─ NumberSequenceSplit
                               │      ├─ GeneratorFunction.map()
                               │      └─ RateLimiter
                               │
                               └─ DataStream<OUT>

シーケンス生成:
0 ──▶ 1 ──▶ 2 ──▶ ... ──▶ count-1
│      │      │              │
▼      ▼      ▼              ▼
map()  map()  map()        map()
│      │      │              │
▼      ▼      ▼              ▼
OUT0   OUT1   OUT2         OUTn-1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DataGeneratorSource.java | `flink-connector-datagen/.../source/` | メインクラス | ソース定義 |
| GeneratorFunction.java | 同パス | インターフェース | データ変換関数 |
| GeneratorSourceReaderFactory.java | 同パス | ファクトリ | リーダー生成 |
| GeneratingIteratorSourceReader.java | 同パス | リーダー | データ読み取り |
| FromElementsGeneratorFunction.java | `flink-connector-datagen/.../functions/` | 関数実装 | 要素配列からの生成 |
| IndexLookupGeneratorFunction.java | 同パス | 関数実装 | インデックスルックアップ |
| NumberSequenceSource.java | `flink-core/.../source/lib/` | 内部利用 | Longシーケンス生成 |
| RateLimiterStrategy.java | `flink-core/.../source/util/ratelimit/` | 戦略 | レート制限 |
