# 機能設計書 4-設定管理

## 概要

本ドキュメントは、Apache Flinkの設定管理機能（Configuration）について詳細に記載する。設定管理はFlinkの設定パラメータを管理し、ジョブの実行動作を制御するための基盤機能である。

### 本機能の処理概要

設定管理機能は、Flinkクラスタおよびジョブの動作を制御するためのキー/バリューベースの設定パラメータ管理を提供する。Configurationクラスは軽量な設定オブジェクトであり、文字列、整数、長整数、ブーリアン、浮動小数点、バイト配列など多様なデータ型をサポートする。

**業務上の目的・背景**：分散データ処理システムでは、並列度、メモリ設定、チェックポイント間隔、ネットワーク設定など多数の設定パラメータが存在する。これらを統一的に管理し、YAML設定ファイル、環境変数、プログラムからの動的設定など複数のソースからパラメータを取得・統合する仕組みが必要である。Configurationクラスはこれらの要件を満たす型安全で柔軟な設定管理機構を提供する。ConfigOptionを使用することで、設定のデフォルト値、説明、型情報を明示的に定義できる。

**機能の利用シーン**：
- Flinkクラスタの起動設定
- ジョブ実行時のパラメータ指定
- チェックポイント設定の管理
- メモリ/ネットワーク設定の管理

**主要な処理内容**：
1. Configuration：キー/バリューペアの管理
2. ConfigOption：型安全な設定オプション定義
3. GlobalConfiguration：YAML設定ファイルの読み込み
4. ConfigOptions：ConfigOptionのビルダー提供

**関連システム・外部連携**：設定管理はJobManager、TaskManager、各種コンポーネントの初期化で使用される。flink-conf.yaml設定ファイル、環境変数、コマンドライン引数からの設定読み込みをサポートする。

**権限による制御**：設定管理自体には権限制御は存在しないが、セキュリティ関連の設定（SSL証明書パス、Kerberos設定等）を含む。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ジョブ設定 | 参照画面 | ジョブ設定情報の取得・表示 |
| 12 | クラスター設定 | 参照画面 | クラスター設定・環境情報の表示 |
| 24 | JobManager設定 | 参照画面 | JobManager設定パラメータの一覧表示 |

## 機能種別

設定管理 / パラメータ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| key | String | Yes | 設定キー | Not null |
| value | Object | No | 設定値 | 型に応じたバリデーション |
| configOption | ConfigOption<T> | No | 型安全な設定オプション | Not null |

### 入力データソース

- flink-conf.yaml設定ファイル
- 環境変数
- コマンドライン引数
- プログラムからの動的設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| value | T | 設定値（指定した型で返却） |

### 出力先

- 各コンポーネント（JobManager、TaskManager等）
- ジョブ実行設定

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ GlobalConfiguration.loadConfiguration()でYAMLを解析
2. 環境変数/コマンドライン引数のマージ
   └─ 優先順位に従って設定を上書き
3. ConfigOptionによる値取得
   └─ get(ConfigOption)で型安全に取得
4. デフォルト値のフォールバック
   └─ 設定がない場合はConfigOptionのデフォルト値を使用
```

### フローチャート

```mermaid
flowchart TD
    A[flink-conf.yaml] --> B[GlobalConfiguration.loadConfiguration]
    B --> C[Configuration生成]
    D[環境変数] --> C
    E[コマンドライン引数] --> C
    C --> F{設定取得要求}
    F --> G[ConfigOption使用]
    G --> H{値が存在?}
    H -->|Yes| I[設定値返却]
    H -->|No| J[デフォルト値返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 設定優先順位 | コマンドライン > 環境変数 > 設定ファイル | 常時 |
| BR-002 | 型安全性 | ConfigOptionで定義された型で値を取得 | ConfigOption使用時 |
| BR-003 | Serializable | Configurationはシリアライズ可能 | クラスタ間転送時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能は直接データベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalConfigurationException | 不正な設定値 | 設定値の修正 |
| - | IllegalArgumentException | 型変換失敗 | 正しい型の値を設定 |

### リトライ仕様

設定管理は起動時に1回実行されるため、リトライ仕様は存在しない。

## トランザクション仕様

設定管理にはトランザクション機能はない。

## パフォーマンス要件

- 設定値の取得はHashMapベースで高速
- 設定ファイル読み込みは起動時のみ

## セキュリティ考慮事項

- パスワードや秘密鍵などの機密情報は設定ファイルに平文で保存しない
- SSL/Kerberos設定は専用のSecurityOptionsで管理

## 備考

Configurationクラスは@Publicアノテーションが付与された安定したAPIである。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基本クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Configuration.java | `flink-core/src/main/java/org/apache/flink/configuration/Configuration.java` | 設定管理のメインクラス |

**読解のコツ**:
- **51-58行目**: クラス定義とインターフェース実装（ReadableConfig, WritableConfig）
- **79行目**: confData（HashMap）が設定値の実体
- **84-86行目**: 空のコンストラクタ
- **93-95行目**: コピーコンストラクタ
- **100-104行目**: fromMap()静的ファクトリメソッド
- **120-124行目**: getString()メソッド
- **136-138行目**: setString()メソッド

#### Step 2: 型安全な設定アクセスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConfigOption.java | `flink-core/src/main/java/org/apache/flink/configuration/ConfigOption.java` | 型安全な設定オプション定義 |
| 2-2 | ConfigOptions.java | `flink-core/src/main/java/org/apache/flink/configuration/ConfigOptions.java` | ConfigOptionビルダー |

#### Step 3: 設定ファイル読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalConfiguration.java | `flink-core/src/main/java/org/apache/flink/configuration/GlobalConfiguration.java` | YAML設定ファイル読み込み |

### プログラム呼び出し階層図

```
GlobalConfiguration.loadConfiguration()
    │
    └─ YAMLパース
           │
           └─ Configuration生成
                  │
                  ├─ get(ConfigOption) → 型安全な値取得
                  ├─ getString(key) → 文字列取得
                  ├─ getInteger(key) → 整数取得
                  └─ setString(key, value) → 値設定
```

### データフロー図

```
[入力]                  [処理]                    [出力]

flink-conf.yaml ───▶ GlobalConfiguration ───▶ Configuration
     │                      │
環境変数 ──────────────────▶│
     │                      │
コマンドライン ──────────────▶│
                           │
                           ▼
                   各コンポーネント設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Configuration.java | `flink-core/src/main/java/org/apache/flink/configuration/Configuration.java` | ソース | 設定管理メインクラス |
| ConfigOption.java | `flink-core/src/main/java/org/apache/flink/configuration/ConfigOption.java` | ソース | 型安全な設定オプション |
| ConfigOptions.java | `flink-core/src/main/java/org/apache/flink/configuration/ConfigOptions.java` | ソース | ConfigOptionビルダー |
| GlobalConfiguration.java | `flink-core/src/main/java/org/apache/flink/configuration/GlobalConfiguration.java` | ソース | YAML読み込み |
| ReadableConfig.java | `flink-core/src/main/java/org/apache/flink/configuration/ReadableConfig.java` | ソース | 読み取り専用インターフェース |
| WritableConfig.java | `flink-core/src/main/java/org/apache/flink/configuration/WritableConfig.java` | ソース | 書き込みインターフェース |
| CheckpointingOptions.java | `flink-core/src/main/java/org/apache/flink/configuration/CheckpointingOptions.java` | ソース | チェックポイント設定 |
| TaskManagerOptions.java | `flink-core/src/main/java/org/apache/flink/configuration/TaskManagerOptions.java` | ソース | TaskManager設定 |
| JobManagerOptions.java | `flink-core/src/main/java/org/apache/flink/configuration/JobManagerOptions.java` | ソース | JobManager設定 |
