# 機能設計書 44-Parquet

## 概要

本ドキュメントは、Apache Flink の flink-parquet モジュールが提供する Apache Parquet ファイル読み書き機能の設計を記述する。

### 本機能の処理概要

Parquet フォーマット機能は、Apache Parquet 形式のカラムナファイルを読み書きするためのバルクフォーマットを提供する。Parquet はカラムナ（列指向）ストレージフォーマットであり、分析ワークロードに最適化されている。

**業務上の目的・背景**：Apache Parquet は Hadoop エコシステムで広く採用されているカラムナストレージフォーマットである。列指向の設計により、特定の列のみを読み取る分析クエリで高いパフォーマンスを発揮する。また、効率的な圧縮とエンコーディングにより、ストレージコストを削減できる。

**機能の利用シーン**：
- データレイク/データウェアハウスへの ETL 出力
- 分析用データの永続化
- Hive/Spark との相互運用
- 大規模バッチ処理のデータストレージ
- 機械学習用データセットの保存

**主要な処理内容**：
1. ParquetColumnarRowInputFormat: Parquet ファイルのカラムナ読み取り
2. ParquetRowDataBuilder: Parquet ファイルへの書き込み
3. ParquetVectorizedInputFormat: ベクトル化読み取り
4. ParquetSchemaConverter: Flink 型と Parquet スキーマの相互変換
5. 統計情報レポート: ファイル統計の収集

**関連システム・外部連携**：
- ファイルシステムコネクタ
- Hive メタストア
- AWS S3 / HDFS / Azure Blob Storage 等のストレージ

**権限による制御**：本機能はファイルフォーマット処理のため、権限制御はファイルシステムに委譲される。

## 関連画面

本機能はバックエンドのデータフォーマット処理機能であり、直接関連する画面はない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

- ファイル読み書き
- バルクフォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| utc-timezone | boolean | No | UTC タイムゾーン使用 | デフォルト: false |
| timestamp.time.unit | String | No | タイムスタンプ時間単位 | nanos/micros/millis、デフォルト: micros |
| write.int64.timestamp | boolean | No | int64 タイムスタンプ書き込み | デフォルト: false |
| batch-size | int | No | 読み取りバッチサイズ | デフォルト: 2048 |

### 入力データソース

- 読み取り: Parquet 形式のファイル
- 書き込み: Flink の RowData 内部データ構造

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rowData | RowData | 読み取った Parquet データ |

### 出力先

- 読み取り: Flink の下流オペレーター
- 書き込み: Parquet ファイル

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    subgraph Read
        A[Parquet File] --> B[ParquetColumnarRowInputFormat]
        B --> C[Column Readers]
        C --> D[VectorizedColumnBatch]
        D --> E[RowData]
    end

    subgraph Write
        F[RowData] --> G[ParquetRowDataWriter]
        G --> H[Column Writers]
        H --> I[Parquet File]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | タイムゾーン変換 | utc-timezone で UTC/ローカル切り替え | タイムスタンプ処理時 |
| BR-44-02 | ベクトル化読み取り | batch-size 単位でバッチ読み取り | 読み取り時 |
| BR-44-03 | 統計情報収集 | ファイル統計をレポート可能 | テーブル統計取得時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | ファイルエラー | ファイル読み書き失敗 | ファイルパス・権限確認 |

## 備考

- Hive 0.x/1.x/2.x はローカルタイムゾーン、Hive 3.x は UTC を使用
- int96 タイムスタンプは従来形式、int64 は新形式

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: ファクトリクラス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParquetFileFormatFactory.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java` | エントリーポイント |

**主要処理フロー**:
- **59行目**: IDENTIFIER = "parquet"
- **92-95行目**: createDecodingFormat() でリーダー生成
- **98-115行目**: createEncodingFormat() でライター生成

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ParquetFileFormatFactory.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java` | ソース | ファクトリ |
| ParquetColumnarRowInputFormat.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetColumnarRowInputFormat.java` | ソース | 読み取りフォーマット |
| ParquetRowDataBuilder.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/row/ParquetRowDataBuilder.java` | ソース | 書き込みビルダー |
| ParquetSchemaConverter.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/utils/ParquetSchemaConverter.java` | ソース | スキーマ変換 |
