# 機能設計書 45-ORC

## 概要

本ドキュメントは、Apache Flink の flink-orc モジュールが提供する Apache ORC ファイル読み書き機能の設計を記述する。

### 本機能の処理概要

ORC フォーマット機能は、Apache ORC（Optimized Row Columnar）形式のカラムナファイルを読み書きするためのバルクフォーマットを提供する。ORC は Hive で開発されたカラムナストレージフォーマットであり、高い圧縮率と読み取り性能を特徴とする。

**業務上の目的・背景**：Apache ORC は Hive エコシステムで標準的に使用されるカラムナストレージフォーマットである。軽量なインデックスとストライプ構造により、必要なデータのみを効率的に読み取ることができる。述語プッシュダウンをサポートし、クエリ性能を向上させる。

**機能の利用シーン**：
- Hive との相互運用
- 大規模データウェアハウスのストレージ
- 高圧縮率が必要なバッチ処理
- 述語プッシュダウンを活用した分析クエリ

**主要な処理内容**：
1. OrcColumnarRowInputFormat: ORC ファイルのカラムナ読み取り
2. OrcBulkWriterFactory: ORC ファイルへの書き込み
3. OrcFilters: 述語プッシュダウンのフィルタ変換
4. OrcShim: ORC バージョン互換レイヤー
5. 統計情報レポート: ファイル統計の収集

**関連システム・外部連携**：
- ファイルシステムコネクタ
- Hive メタストア
- HDFS / クラウドストレージ

**権限による制御**：本機能はファイルフォーマット処理のため、権限制御はファイルシステムに委譲される。

## 関連画面

本機能はバックエンドのデータフォーマット処理機能であり、直接関連する画面はない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

- ファイル読み書き
- バルクフォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| orc.* | 各種 | No | ORC 設定プロパティ | Hadoop Configuration 形式 |

### 入力データソース

- 読み取り: ORC 形式のファイル
- 書き込み: Flink の RowData 内部データ構造

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rowData | RowData | 読み取った ORC データ |

### 出力先

- 読み取り: Flink の下流オペレーター
- 書き込み: ORC ファイル

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    subgraph Read
        A[ORC File] --> B[OrcColumnarRowInputFormat]
        B --> C[OrcShim]
        C --> D[Column Vectors]
        D --> E[RowData]
    end

    subgraph Write
        F[RowData] --> G[RowDataVectorizer]
        G --> H[OrcBulkWriter]
        H --> I[ORC File]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 述語プッシュダウン | OrcFilters でフィルタをプッシュ | フィルタ適用時 |
| BR-45-02 | ベクトル化読み取り | VectorizedColumnBatch 単位で読み取り | 読み取り時 |
| BR-45-03 | ORC バージョン互換 | OrcShim でバージョン差異を吸収 | 全処理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | ファイルエラー | ファイル読み書き失敗 | ファイルパス・権限確認 |
| RuntimeException | コーデックエラー | コーデック未発見 | コーデック名確認 |

## 備考

- OrcShim でバージョン 2.0.0/2.1.0/2.3.0 の互換性を確保
- Hive との相互運用で広く使用

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: ファクトリクラス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrcFileFormatFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java` | エントリーポイント |

**主要処理フロー**:
- **65行目**: IDENTIFIER = "orc"
- **99-102行目**: createDecodingFormat() でリーダー生成
- **105-128行目**: createEncodingFormat() でライター生成
- **149-170行目**: createRuntimeDecoder() でフィルタプッシュダウン

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrcFileFormatFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java` | ソース | ファクトリ |
| OrcColumnarRowInputFormat.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcColumnarRowInputFormat.java` | ソース | 読み取りフォーマット |
| OrcBulkWriterFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/writer/OrcBulkWriterFactory.java` | ソース | 書き込みファクトリ |
| OrcFilters.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFilters.java` | ソース | フィルタ変換 |
| OrcShim.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/shim/OrcShim.java` | ソース | バージョン互換 |
