# 機能設計書 46-CSV

## 概要

本ドキュメントは、Apache Flink の flink-csv モジュールが提供する CSV シリアライゼーション/デシリアライゼーション機能の設計を記述する。

### 本機能の処理概要

CSV フォーマット機能は、CSV（Comma-Separated Values）形式のデータを読み書きするためのシリアライザとデシリアライザを提供する。Jackson CSV ライブラリを基盤とし、柔軟な設定オプションを提供する。

**業務上の目的・背景**：CSV は最も広く普及したテキストベースのデータフォーマットである。Excel、データベースエクスポート、レガシーシステムとの連携など、多くの場面で使用される。シンプルな構造でありながら、区切り文字やクォート文字のカスタマイズが可能。

**機能の利用シーン**：
- レガシーシステムとのデータ連携
- Excel/スプレッドシートとの相互運用
- ログファイルの解析
- ETL 処理での中間フォーマット
- 人間が読めるデータ出力

**主要な処理内容**：
1. CsvRowDataDeserializationSchema: CSV バイト列から RowData への変換
2. CsvRowDataSerializationSchema: RowData から CSV バイト列への変換
3. CsvReaderFormat: ファイルシステムからの CSV 読み取り
4. CsvBulkWriter: ファイルシステムへの CSV 書き込み

**関連システム・外部連携**：
- ファイルシステムコネクタ
- Kafka コネクタ
- レガシーシステム

**権限による制御**：本機能はデータフォーマット処理のため、権限制御は利用するコネクタに委譲される。

## 関連画面

本機能はバックエンドのデータフォーマット処理機能であり、直接関連する画面はない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

- データ変換処理
- シリアライゼーション/デシリアライゼーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| field-delimiter | String | No | フィールド区切り文字 | デフォルト: , |
| quote-character | char | No | クォート文字 | デフォルト: " |
| disable-quote-character | boolean | No | クォート無効化 | デフォルト: false |
| allow-comments | boolean | No | コメント許可 | デフォルト: false |
| ignore-parse-errors | boolean | No | パースエラー無視 | デフォルト: false |
| array-element-delimiter | String | No | 配列要素区切り | デフォルト: ; |
| escape-character | char | No | エスケープ文字 | - |
| null-literal | String | No | null リテラル | - |
| write-bigdecimal-in-scientific-notation | boolean | No | BigDecimal を科学表記 | デフォルト: true |

### 入力データソース

- デシリアライゼーション: CSV 形式の byte[] データ
- シリアライゼーション: Flink の RowData 内部データ構造

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rowData | RowData | Flink 内部データ形式に変換されたデータ |
| csvBytes | byte[] | CSV 形式にシリアライズされたバイト列 |

### 出力先

- デシリアライゼーション: Flink の下流オペレーター
- シリアライゼーション: 外部システム

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    subgraph Deserialization
        A[CSV byte[]] --> B[CsvRowDataDeserializationSchema]
        B --> C[CsvToRowDataConverters]
        C --> D[RowData]
    end

    subgraph Serialization
        E[RowData] --> F[CsvRowDataSerializationSchema]
        F --> G[RowDataToCsvConverters]
        G --> H[CSV byte[]]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | パースエラー処理 | ignore-parse-errors=true でエラー行をスキップ | デシリアライゼーション時 |
| BR-46-02 | クォート処理 | disable-quote-character=true でクォートなし | 両方向 |
| BR-46-03 | null 表現 | null-literal で null の文字列表現を指定 | 両方向 |
| BR-46-04 | エスケープ処理 | escape-character で特殊文字をエスケープ | 両方向 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | パースエラー | CSV 形式不正 | ignore-parse-errors 設定確認 |
| RuntimeException | シリアライゼーションエラー | RowData 変換失敗 | スキーマ定義確認 |

## 備考

- Jackson CSV を使用
- プロジェクション対応

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: ファクトリクラス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CsvFormatFactory.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvFormatFactory.java` | エントリーポイント |

**主要処理フロー**:
- **66-100行目**: createDecodingFormat() でデシリアライザ生成
- **103-124行目**: createEncodingFormat() でシリアライザ生成
- **150-182行目**: configureDeserializationSchema() で設定適用
- **184-214行目**: configureSerializationSchema() で設定適用

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CsvFormatFactory.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvFormatFactory.java` | ソース | ファクトリ |
| CsvRowDataDeserializationSchema.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvRowDataDeserializationSchema.java` | ソース | デシリアライザ |
| CsvRowDataSerializationSchema.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvRowDataSerializationSchema.java` | ソース | シリアライザ |
| CsvFormatOptions.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvFormatOptions.java` | ソース | 設定オプション |
| CsvReaderFormat.java | `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvReaderFormat.java` | ソース | ファイル読み取り |
