# 機能設計書 53-Azure Blob Storage

## 概要

本ドキュメントは、Apache Flink の Azure Blob Storage ファイルシステムの機能設計書である。flink-azure-fs-hadoop モジュールが提供する Azure Blob Storage / Azure Data Lake Storage Gen2 との連携機能について、処理内容、設定方法、およびコードの構造を詳細に記載する。

### 本機能の処理概要

**業務上の目的・背景**：Microsoft Azure を利用する企業にとって、Azure Blob Storage は主要なオブジェクトストレージサービスである。Flink ジョブの入出力データ、チェックポイント、セーブポイントの保存先として Azure Storage を使用する需要に応えるため、本機能が提供される。また、Azure Data Lake Storage Gen2（ADLS Gen2）もサポートし、ビッグデータ分析ワークロードに対応する。

**機能の利用シーン**：
- ストリーム処理ジョブのチェックポイントを Azure Blob Storage に保存する場合
- バッチ処理ジョブの入力データを Azure から読み込む場合
- 処理結果を Azure Storage に出力する場合
- Azure Data Lake Storage Gen2 を使用する場合

**主要な処理内容**：
1. AbstractAzureFSFactory による FileSystem インスタンスの生成
2. Hadoop Azure ファイルシステム設定の読み込み
3. wasb:// / wasbs:// / abfs:// / abfss:// スキームのサポート
4. AzureBlobFileSystem による HadoopFileSystem のラッピング
5. AzureBlobRecoverableWriter によるチェックポイント対応書き込み

**関連システム・外部連携**：
- Azure Blob Storage
- Azure Data Lake Storage Gen2
- Hadoop Azure ファイルシステム（hadoop-azure）

**権限による制御**：Azure Storage アカウントキー、Shared Access Signature（SAS）、または Azure Active Directory による認証をサポート。

## 関連画面

本機能は画面を持たないバックエンド機能である。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

データ連携 / ファイルシステム抽象化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fs.azure.account.key.<account>.blob.core.windows.net | String | Yes（キー認証時） | ストレージアカウントキー | 非空文字列 |
| fs.azure.sas.<container>.<account>.blob.core.windows.net | String | Yes（SAS認証時） | SASトークン | 非空文字列 |
| fs.azure | String | No | Azure関連設定プレフィックス | - |
| azure | String | No | Azure関連設定プレフィックス | - |

### 入力データソース

- Flink Configuration（flink-conf.yaml）
- 環境変数
- Hadoop Configuration（core-site.xml）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FileSystem | org.apache.flink.core.fs.FileSystem | Flinkファイルシステムインターフェース実装 |

### 出力先

Flink ランタイムへの FileSystem インスタンス提供

## 処理フロー

### 処理シーケンス

```
1. FileSystemFactory.create(URI) が呼び出される
   └─ URIスキーム（wasb/wasbs/abfs/abfss）を検証
2. HadoopConfigLoader で設定を読み込み
   └─ fs.azure., azure. プレフィックスの設定をマッピング
3. Azure ファイルシステムインスタンスを生成
   └─ NativeAzureFileSystem または AzureBlobFileSystem
4. FileSystem.initialize(URI, Configuration) で初期化
   └─ Azure認証情報の設定
5. AzureBlobFileSystem でラップして返却
   └─ RecoverableWriter サポート
```

### フローチャート

```mermaid
flowchart TD
    A[開始: create URI] --> B{URIスキーム確認}
    B -->|wasb://| C1[AzureBlobStorageFSFactory]
    B -->|wasbs://| C2[SecureAzureBlobStorageFSFactory]
    B -->|abfs://| C3[AzureDataLakeStoreGen2FSFactory]
    B -->|abfss://| C4[SecureAzureDataLakeStoreGen2FSFactory]
    B -->|その他| Z[エラー: 非対応スキーム]
    C1 --> D[HadoopConfigLoader実行]
    C2 --> D
    C3 --> D
    C4 --> D
    D --> E[Azure FileSystem生成]
    E --> F[initialize実行]
    F --> G{初期化成功?}
    G -->|Yes| H[AzureBlobFileSystem生成]
    G -->|No| Z2[エラー: 初期化失敗]
    H --> I[終了: FileSystem返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | スキームマッピング（Blob） | wasb:// と wasbs:// を NativeAzureFileSystem にマッピング | Blob Storage使用時 |
| BR-53-02 | スキームマッピング（ADLS） | abfs:// と abfss:// を AzureBlobFileSystem にマッピング | ADLS Gen2使用時 |
| BR-53-03 | 設定プレフィックス | fs.azure., azure. プレフィックスの設定を読み込み | 設定読み込み時 |
| BR-53-04 | セキュアスキーム | wasbs:// と abfss:// は HTTPS 接続を使用 | セキュア接続時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | 接続エラー | Azureエンドポイントに接続できない | ネットワーク設定を確認 |
| AuthenticationException | 認証エラー | 認証情報が無効 | ストレージアカウントキーまたはSASを確認 |
| IllegalArgumentException | 設定エラー | 必須設定が欠落 | flink-conf.yamlを確認 |

### リトライ仕様

Hadoop Azure ファイルシステムの標準リトライポリシーに従う

## トランザクション仕様

オブジェクトストレージのため、トランザクションは非対応。AzureBlobRecoverableWriter によるアトミック書き込みをサポート。

## パフォーマンス要件

- ブロックBlobの並列アップロード
- 適切なブロックサイズの設定により性能最適化

## セキュリティ考慮事項

- ストレージアカウントキーは環境変数での提供を推奨
- SAS トークンによる最小権限アクセスを推奨
- HTTPS接続（wasbs:// / abfss://）の使用を推奨

## 備考

- Azure Data Lake Storage Gen2 はより高性能で、階層型名前空間をサポート
- RecoverableWriter は AzureBlobRecoverableWriter として実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 抽象ファクトリを理解する

Azureファイルシステムファクトリの基底実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractAzureFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AbstractAzureFSFactory.java` | 基底ファクトリの実装 |

**主要処理フロー**:
1. **44-45行目**: 設定プレフィックス FLINK_CONFIG_PREFIXES = {"fs.azure.", "azure."}
2. **52-63行目**: コンストラクタでHadoopConfigLoaderを初期化
3. **66-68行目**: configure()でFlink設定を読み込み
4. **70行目**: createAzureFS() 抽象メソッド（サブクラスで実装）
5. **73-80行目**: create()でファイルシステムを生成・初期化

**読解のコツ**: AbstractAzureFSFactory は FileSystemFactory インターフェースを実装し、サブクラスで createAzureFS() をオーバーライドすることで具体的な Azure ファイルシステムを提供する。

#### Step 2: 具体的なファクトリ実装を理解する

各スキーム用のファクトリ実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AzureBlobStorageFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobStorageFSFactory.java` | wasb://用ファクトリ |
| 2-2 | SecureAzureBlobStorageFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureBlobStorageFSFactory.java` | wasbs://用ファクトリ |
| 2-3 | AzureDataLakeStoreGen2FSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureDataLakeStoreGen2FSFactory.java` | abfs://用ファクトリ |
| 2-4 | SecureAzureDataLakeStoreGen2FSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureDataLakeStoreGen2FSFactory.java` | abfss://用ファクトリ |

#### Step 3: ファイルシステムラッパーを理解する

Flink FileSystem インターフェースへの適合を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AzureBlobFileSystem.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobFileSystem.java` | FileSystemラッパー |

**主要処理フロー**:
- **31行目**: HadoopFileSystem を継承
- **38-40行目**: コンストラクタでHadoop FileSystemをラップ
- **43-45行目**: createRecoverableWriter() で AzureBlobRecoverableWriter を生成

### プログラム呼び出し階層図

```
AbstractAzureFSFactory.create(URI)
    │
    ├─ HadoopConfigLoader.getOrLoadHadoopConfig()
    │
    ├─ createAzureFS() [abstract]
    │      ├─ AzureBlobStorageFSFactory: new NativeAzureFileSystem()
    │      ├─ SecureAzureBlobStorageFSFactory: new NativeAzureFileSystem()
    │      ├─ AzureDataLakeStoreGen2FSFactory: new AzureBlobFileSystem()
    │      └─ SecureAzureDataLakeStoreGen2FSFactory: new AzureBlobFileSystem()
    │
    ├─ fs.initialize(URI, hadoopConfig)
    │
    └─ new AzureBlobFileSystem(fs)
           │
           └─ createRecoverableWriter()
                  └─ new AzureBlobRecoverableWriter(hadoopFileSystem)
```

### データフロー図

```
[入力]                      [処理]                        [出力]

URI (wasb://...)  ─────────▶ AbstractAzureFSFactory ────▶ AzureBlobFileSystem
URI (abfs://...)  ─────────▶
                                 │
Flink Configuration ──────────▶ HadoopConfigLoader ────▶ Hadoop Configuration
                                 │
Azure Credentials ────────────▶ Azure FileSystem ──────▶ Azure Storage API
                                 │
RecoverableWriter Request ────▶ AzureBlobRecoverableWriter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractAzureFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AbstractAzureFSFactory.java` | ソース | 基底ファクトリ |
| AzureBlobStorageFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobStorageFSFactory.java` | ソース | wasb://ファクトリ |
| SecureAzureBlobStorageFSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureBlobStorageFSFactory.java` | ソース | wasbs://ファクトリ |
| AzureDataLakeStoreGen2FSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureDataLakeStoreGen2FSFactory.java` | ソース | abfs://ファクトリ |
| SecureAzureDataLakeStoreGen2FSFactory.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureDataLakeStoreGen2FSFactory.java` | ソース | abfss://ファクトリ |
| AzureBlobFileSystem.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobFileSystem.java` | ソース | ファイルシステムラッパー |
| AzureBlobRecoverableWriter.java | `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobRecoverableWriter.java` | ソース | RecoverableWriter実装 |
| org.apache.flink.core.fs.FileSystemFactory | `flink-filesystems/flink-azure-fs-hadoop/src/main/resources/META-INF/services/` | 設定 | SPIサービス登録 |
