# 機能設計書 61-InfluxDBメトリクスレポーター

## 概要

本ドキュメントは、Apache FlinkのInfluxDBメトリクスレポーター機能（flink-metrics-influxdb モジュール）の設計仕様を記載する。

### 本機能の処理概要

InfluxDBメトリクスレポーターは、Flinkランタイムで収集されたメトリクス（Counter、Gauge、Histogram、Meter）をInfluxDBデータベースにエクスポートする機能である。

**業務上の目的・背景**：Flinkクラスターの運用監視において、メトリクスを時系列データベースであるInfluxDBに蓄積することで、長期的なパフォーマンス分析、リアルタイムダッシュボード構築、アラート設定を可能にする。特にGrafanaなどの可視化ツールと組み合わせることで、運用チームがクラスターの健全性を効率的に監視できる。

**機能の利用シーン**：
- 本番環境でのFlinkクラスター監視
- パフォーマンスのトレンド分析
- 障害発生時の原因調査のためのメトリクス履歴参照
- リソース使用状況の可視化とキャパシティプランニング

**主要な処理内容**：
1. メトリクスの登録・削除通知の受信と内部レジストリへの保存
2. 定期的なレポート間隔でのメトリクス収集
3. InfluxDB Line Protocol形式へのメトリクス変換
4. HTTPまたはHTTPS経由でのInfluxDBへのバッチ送信

**関連システム・外部連携**：
- InfluxDB（時系列データベース）
- OkHttpClient（HTTP通信）
- influxdb-java ライブラリ

**権限による制御**：InfluxDBへの接続にはユーザー名/パスワード認証を使用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理機能 |

## 機能種別

データ連携（メトリクスのInfluxDBへのエクスポート）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| host | String | Yes | InfluxDBサーバーホスト名 | 空でないこと |
| port | Integer | Yes | InfluxDBサーバーポート | 有効なポート番号（1-65535） |
| scheme | Enum(HTTP/HTTPS) | No | 接続スキーム | デフォルト: HTTP |
| db | String | Yes | データベース名 | null不可 |
| username | String | No | 認証ユーザー名 | - |
| password | String | No | 認証パスワード | - |
| retentionPolicy | String | No | データ保持ポリシー | デフォルト: 空文字 |
| consistency | Enum | No | 書き込み一貫性レベル | デフォルト: ONE |
| connectTimeout | Duration | No | 接続タイムアウト | デフォルト: 10000ms |
| writeTimeout | Duration | No | 書き込みタイムアウト | デフォルト: 10000ms |

### 入力データソース

- Flinkランタイムから通知されるメトリクス（Counter、Gauge、Histogram、Meter）
- 設定ファイル（flink-conf.yaml）からのレポーター設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| measurement | String | メトリクス名（スコープ付き） |
| tags | Map<String, String> | メトリクスグループの変数（job_id、task_name等） |
| fields | Map<String, Object> | メトリクス値（value、count、rate等） |
| timestamp | Long | 測定時刻（エポックミリ秒） |

### 出力先

InfluxDB HTTP API（/write エンドポイント）

## 処理フロー

### 処理シーケンス

```
1. レポーター初期化（open）
   └─ 設定パラメータの読み込みとバリデーション
   └─ InfluxDB接続の確立

2. メトリクス登録（notifyOfAddedMetric）
   └─ メトリクス種別に応じた内部マップへの登録
   └─ MeasurementInfoの生成（名前とタグの抽出）

3. 定期レポート（report）
   └─ 全登録メトリクスの収集
   └─ BatchPointsへの変換
   └─ InfluxDBへの書き込み

4. メトリクス削除（notifyOfRemovedMetric）
   └─ 内部マップからの削除

5. シャットダウン（close）
   └─ InfluxDB接続のクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[開始: report] --> B{メトリクス存在?}
    B -->|Yes| C[現在時刻取得]
    B -->|No| Z[終了]
    C --> D[BatchPoints.Builder作成]
    D --> E[Gauge処理]
    E --> F[Counter処理]
    F --> G[Histogram処理]
    G --> H[Meter処理]
    H --> I{変換成功?}
    I -->|Yes| J[influxDB.write]
    I -->|No| K[null返却]
    J --> Z
    K --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 認証任意 | ユーザー名とパスワードが両方指定された場合のみ認証接続 | username/password両方設定時 |
| BR-02 | 数値変換 | Gaugeの値が数値以外の場合は文字列として送信 | Gauge値がNumber型でない場合 |
| BR-03 | 並行更新対応 | メトリクス収集中の並行変更は次回レポートで対応 | ConcurrentModificationException発生時 |

### 計算ロジック

Histogramメトリクスでは以下の統計値を計算して送信:
- count: サンプル数
- min/max: 最小値/最大値
- mean: 平均値
- stddev: 標準偏差
- p50/p75/p95/p98/p99/p999: パーセンタイル値

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| report | InfluxDB measurement | INSERT | メトリクスポイントの書き込み |

### テーブル別操作詳細

#### InfluxDB Measurement

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | time | 現在時刻（エポックミリ秒） | タイムスタンプ |
| INSERT | tags.* | MetricGroup変数 | インデックス可能 |
| INSERT | fields.* | メトリクス値 | 集計可能 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | 設定エラー | host/portが無効、dbが未設定 | 設定を修正 |
| IOException | 通信エラー | InfluxDB接続失敗 | 接続設定の確認 |
| ConcurrentModificationException | 並行エラー | メトリクス登録/削除の並行実行 | 自動リカバリ（次回レポート時に再試行） |

### リトライ仕様

- 通信エラー時のリトライは実装されていない
- 並行更新エラーは次回のレポートサイクルで自動的に再収集される

## トランザクション仕様

- InfluxDBへの書き込みはBatchPointsとしてまとめて送信される
- 個別のポイント単位でのトランザクション保証はInfluxDBの一貫性レベルに依存

## パフォーマンス要件

- レポート間隔: 設定可能（デフォルトはScheduledインターフェースに準拠）
- バッチ送信により、ネットワークオーバーヘッドを最小化
- 接続タイムアウト/書き込みタイムアウトを設定可能

## セキュリティ考慮事項

- HTTPS接続をサポート（scheme設定）
- 認証情報（ユーザー名/パスワード）を設定ファイルに保存
- 認証情報の暗号化機能は本モジュールでは提供していない

## 備考

- InfluxDB 1.x系のHTTP APIに対応
- influxdb-javaライブラリを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MeasurementInfo.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/MeasurementInfo.java` | メトリクス送信時の情報を保持するデータ構造（名前とタグのマップ） |
| 1-2 | InfluxdbReporterOptions.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/InfluxdbReporterOptions.java` | 設定オプションの定義（ConfigOptionクラス群） |

**読解のコツ**: MeasurementInfoはイミュータブルなデータクラスで、InfluxDBのLine Protocolにおけるmeasurement名とタグに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InfluxdbReporterFactory.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/InfluxdbReporterFactory.java` | SPI経由でレポーターを生成するファクトリクラス |

**主要処理フロー**:
1. **29-32行目**: createMetricReporter()でInfluxdbReporterインスタンスを生成

#### Step 3: メインレポーター実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractReporter.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/AbstractReporter.java` | メトリクス登録・削除の共通処理 |
| 3-2 | InfluxdbReporter.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/InfluxdbReporter.java` | InfluxDB固有のレポート処理 |

**主要処理フロー（InfluxdbReporter.java）**:
- **72-113行目**: open()メソッドで設定読み込みとInfluxDB接続初期化
- **124-129行目**: report()メソッドでバッチポイントを構築して送信
- **132-158行目**: buildReport()でメトリクスをInfluxDB形式に変換

#### Step 4: メトリクス変換処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MetricMapper.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/MetricMapper.java` | 各メトリクス型からInfluxDB Pointへの変換 |
| 4-2 | MeasurementInfoProvider.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/MeasurementInfoProvider.java` | メトリクス名とタグの生成ロジック |

**主要処理フロー（MetricMapper.java）**:
- **34-43行目**: Gaugeの変換（数値/文字列の判定含む）
- **45-47行目**: Counterの変換
- **49-64行目**: Histogramの変換（統計値の算出）
- **66-71行目**: Meterの変換

### プログラム呼び出し階層図

```
InfluxdbReporterFactory.createMetricReporter()
    │
    └─ new InfluxdbReporter()
           │
           ├─ new MeasurementInfoProvider()
           │
           └─ AbstractReporter<MeasurementInfo>
                  │
                  ├─ notifyOfAddedMetric()
                  │      └─ MeasurementInfoProvider.getMetricInfo()
                  │
                  ├─ notifyOfRemovedMetric()
                  │
                  └─ report() [Scheduled]
                         │
                         └─ buildReport()
                                │
                                ├─ MetricMapper.map(Gauge)
                                ├─ MetricMapper.map(Counter)
                                ├─ MetricMapper.map(Histogram)
                                └─ MetricMapper.map(Meter)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Flink Metrics          ┌─────────────────────────┐
  (Counter/Gauge/      │   InfluxdbReporter      │           InfluxDB
   Histogram/Meter) ──▶│                         │──▶  HTTP/HTTPS API
                       │   ┌─────────────────┐   │        (BatchPoints)
                       │   │ MetricMapper    │   │
MetricConfig ────────▶ │   │   変換処理      │   │
  (host, port, db...)  │   └─────────────────┘   │
                       └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InfluxdbReporter.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | メインレポーター実装 |
| InfluxdbReporterFactory.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | ファクトリクラス |
| InfluxdbReporterOptions.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | 設定オプション定義 |
| AbstractReporter.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | 抽象基底クラス |
| MeasurementInfo.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | データ構造 |
| MeasurementInfoProvider.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | メタ情報生成 |
| MetricMapper.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | メトリクス変換 |
| MetricInfoProvider.java | `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/` | ソース | インターフェース |
| org.apache.flink.metrics.reporter.MetricReporterFactory | `flink-metrics/flink-metrics-influxdb/src/main/resources/META-INF/services/` | 設定 | SPIサービス定義 |
