# 機能設計書 62-Datadogメトリクスレポーター

## 概要

本ドキュメントは、Apache FlinkのDatadogメトリクスレポーター機能（flink-metrics-datadog モジュール）の設計仕様を記載する。

### 本機能の処理概要

DatadogメトリクスレポーターはFlinkランタイムで収集されたメトリクス（Counter、Gauge、Histogram、Meter）をDatadog監視サービスにHTTP経由でエクスポートする機能である。

**業務上の目的・背景**：Datadogは広く利用されているSaaS型の監視プラットフォームであり、本機能によりFlinkクラスターのメトリクスをDatadogのダッシュボード、アラート、APM機能と統合できる。これによりインフラストラクチャ全体の統一的な監視と、既存の運用ワークフローへのシームレスな統合が可能になる。

**機能の利用シーン**：
- Datadogを監視基盤として採用している組織でのFlink監視
- 複数システムのメトリクスを統合したダッシュボード構築
- メトリクスベースのアラート設定とインシデント管理
- クラウドネイティブ環境での統合監視

**主要な処理内容**：
1. メトリクスの登録・削除通知の受信とDatadog固有の型へのラッピング
2. 定期的なレポート間隔でのメトリクス収集とJSON形式への変換
3. Datadog Series API経由での非同期送信
4. 大量メトリクスのチャンク分割送信（maxMetricsPerRequest対応）

**関連システム・外部連携**：
- Datadog Series API（https://app.datadoghq.{dataCenter}/api/v1/series）
- OkHttpClient（HTTP通信）
- Jackson（JSONシリアライゼーション）

**権限による制御**：Datadog APIキーによる認証

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理機能 |

## 機能種別

データ連携（メトリクスのDatadogへのエクスポート）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| apikey | String | Yes | Datadog APIキー | 空不可 |
| proxyHost | String | No | プロキシサーバーホスト | - |
| proxyPort | Integer | No | プロキシサーバーポート | デフォルト: 8080 |
| dataCenter | Enum(US/EU) | No | Datadogデータセンター | デフォルト: US |
| tags | String | No | カンマ区切りのタグ（非推奨） | scope.variables.additional推奨 |
| maxMetricsPerRequest | Integer | No | リクエストあたり最大メトリクス数 | デフォルト: 2000 |
| useLogicalIdentifier | Boolean | No | 論理スコープ識別子使用フラグ | デフォルト: false |

### 入力データソース

- Flinkランタイムから通知されるメトリクス（Counter、Gauge、Histogram、Meter）
- 設定ファイル（flink-conf.yaml）からのレポーター設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| type | String | メトリクス種別（gauge/count） |
| metric | String | メトリクス名 |
| host | String | ホスト名 |
| tags | List<String> | タグリスト（key:value形式） |
| points | List<List<Number>> | [timestamp, value]のリスト |

### 出力先

Datadog Series API（`https://app.datadoghq.{domain}/api/v1/series`）

## 処理フロー

### 処理シーケンス

```
1. レポーター初期化（コンストラクタ）
   └─ DatadogHttpClient生成
   └─ APIキー検証
   └─ 設定タグの解析

2. メトリクス登録（notifyOfAddedMetric）
   └─ 論理/物理識別子の生成
   └─ タグの収集（設定タグ + MetricGroup変数）
   └─ DMetricサブクラスでのラッピング

3. 定期レポート（report）
   └─ DSeriesへのメトリクス収集
   └─ Gauge例外ハンドリング（型不正対応）
   └─ チャンク分割送信（maxMetricsPerRequest単位）
   └─ 送信確認応答

4. メトリクス削除（notifyOfRemovedMetric）
   └─ 内部マップからの削除

5. シャットダウン（close）
   └─ HTTPクライアントのシャットダウン
```

### フローチャート

```mermaid
flowchart TD
    A[開始: report] --> B[DSeries作成]
    B --> C[Gauge収集・例外処理]
    C --> D[Counter/Meter/Histogram追加]
    D --> E{totalMetrics > 0?}
    E -->|No| Z[終了]
    E -->|Yes| F[チャンク分割ループ]
    F --> G[fromIndex〜toIndex取得]
    G --> H[client.send]
    H --> I{送信成功?}
    I -->|Yes| J[ackReport呼び出し]
    I -->|No| K[警告ログ出力]
    J --> L{残りあり?}
    K --> L
    L -->|Yes| F
    L -->|No| Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | APIキー必須 | APIキーが空または未設定の場合は例外 | 初期化時 |
| BR-02 | Gauge型制限 | 数値型以外のGaugeは自動除外 | ClassCastException発生時 |
| BR-03 | チャンク分割 | maxMetricsPerRequest超過時は分割送信 | メトリクス数超過時 |
| BR-04 | 非同期送信 | HTTP送信は非同期で実行 | report()呼び出し時 |
| BR-05 | ホスト変数除外 | <host>変数はタグではなくhostフィールドに設定 | タグ生成時 |

### 計算ロジック

Counterメトリクスでは差分計算（delta）を行う:
- 現在値から前回値を減算して増分を送信
- DCounter.ackReport()で前回値を更新

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | 設定エラー | APIキーが無効 | 正しいAPIキーを設定 |
| IllegalStateException | 接続エラー | Datadog API接続失敗 | ネットワーク設定確認 |
| SocketTimeoutException | タイムアウト | 送信タイムアウト | リトライ無し（次回レポート時に再送） |
| ClassCastException | 型エラー | Gauge値が数値以外 | 該当メトリクスを自動除外 |

### リトライ仕様

- HTTPレベルのリトライは実装されていない
- 失敗時は警告ログを出力し、次回のレポートサイクルで再送信

## トランザクション仕様

- 非同期送信のため、レスポンス待機なしで処理継続
- 送信成功の確認はコールバックで行われる

## パフォーマンス要件

- 大量メトリクス対応: maxMetricsPerRequestでバッチサイズを制御
- 接続タイムアウト/書き込み/読み込みタイムアウト: 各3秒
- 非同期送信により、report()の実行時間を最小化

## セキュリティ考慮事項

- HTTPS通信によるデータ暗号化
- APIキーによる認証
- プロキシサーバー経由の通信をサポート
- APIキーは設定ファイルに平文保存（暗号化機能なし）

## 備考

- `tags`オプションは非推奨、`scope.variables.additional`の使用を推奨
- Datadog API v1（Series API）に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DMetric.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DMetric.java` | Datadog用メトリクス基底クラス |
| 1-2 | MetricMetaData.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/MetricMetaData.java` | メトリクスメタデータ |
| 1-3 | MetricType.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/MetricType.java` | メトリクス種別定義 |
| 1-4 | DataCenter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DataCenter.java` | データセンター定義 |

**読解のコツ**: DMetricはJSON出力用のJacksonアノテーション（@JsonGetter等）を持つ。各サブクラス（DGauge、DCounter、DMeter、DHistogram）が具象実装を提供する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DatadogHttpReporterFactory.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpReporterFactory.java` | ファクトリクラス、設定パラメータの解析 |

**主要処理フロー**:
1. **43-67行目**: createMetricReporter()で設定解析とDatadogHttpReporter生成

#### Step 3: メインレポーター実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DatadogHttpReporter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpReporter.java` | メインレポーター実装 |

**主要処理フロー（DatadogHttpReporter.java）**:
- **65-85行目**: コンストラクタでの初期化
- **88-126行目**: notifyOfAddedMetric()でメトリクス登録とラッピング
- **161-187行目**: report()でチャンク分割送信

#### Step 4: HTTP通信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DatadogHttpClient.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpClient.java` | HTTP通信クライアント |
| 4-2 | DSeries.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DSeries.java` | シリーズデータコンテナ |

**主要処理フロー（DatadogHttpClient.java）**:
- **59-88行目**: コンストラクタでプロキシ設定と接続確立
- **98-108行目**: validateApiKey()でAPIキー検証
- **110-120行目**: send()でJSON送信

### プログラム呼び出し階層図

```
DatadogHttpReporterFactory.createMetricReporter()
    │
    └─ new DatadogHttpReporter()
           │
           ├─ new DatadogHttpClient()
           │      └─ validateApiKey()
           │
           ├─ notifyOfAddedMetric()
           │      ├─ new DGauge()
           │      ├─ new DCounter()
           │      ├─ new DMeter()
           │      └─ new DHistogram()
           │
           └─ report() [Scheduled]
                  │
                  ├─ addGaugesAndUnregisterOnException()
                  │
                  └─ client.send(DSeries)
                         └─ EmptyCallback [async]
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Flink Metrics          ┌─────────────────────────┐
  (Counter/Gauge/      │  DatadogHttpReporter    │           Datadog API
   Histogram/Meter) ──▶│                         │──▶  POST /api/v1/series
                       │   ┌─────────────────┐   │        (JSON)
                       │   │  DMetric派生    │   │
Config                 │   │  クラス群       │   │
  (apikey, tags...) ──▶│   └─────────────────┘   │
                       │   ┌─────────────────┐   │
                       │   │ DatadogHttpClient│  │
                       │   └─────────────────┘   │
                       └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DatadogHttpReporter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | メインレポーター実装 |
| DatadogHttpReporterFactory.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | ファクトリクラス |
| DatadogHttpClient.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | HTTP通信クライアント |
| DMetric.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | メトリクス基底クラス |
| DGauge.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | Gaugeラッパー |
| DCounter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | Counterラッパー（差分計算） |
| DMeter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | Meterラッパー |
| DHistogram.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | Histogramラッパー |
| DSeries.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | シリーズコンテナ |
| MetricMetaData.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | メタデータ |
| MetricType.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | 種別Enum |
| DataCenter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | データセンターEnum |
| Clock.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/` | ソース | 時刻取得インターフェース |
