# 機能設計書 66-Dropwizardメトリクス連携

## 概要

本ドキュメントは、Apache FlinkのDropwizardメトリクス連携機能（flink-metrics-dropwizard モジュール）の設計仕様を記載する。

### 本機能の処理概要

Dropwizardメトリクス連携は、FlinkのメトリクスをDropwizard Metrics（旧Codahale Metrics）ライブラリと統合する機能である。これにより既存のDropwizardベースのレポーター（Graphite、Ganglia、Console等）をFlinkで使用可能にする。

**業務上の目的・背景**：Dropwizard Metricsは広く採用されているJavaメトリクスライブラリであり、多くの組織がすでにDropwizardベースの監視インフラを構築している。本機能によりFlinkメトリクスを既存のDropwizard互換レポーターに接続でき、監視インフラの統一を実現できる。

**機能の利用シーン**：
- 既存のDropwizardベースの監視インフラへのFlink統合
- Graphite、Ganglia等のバックエンドへの連携
- カスタムDropwizardレポーターの利用
- 他のDropwizard対応アプリケーションとのメトリクス統合

**主要な処理内容**：
1. FlinkメトリクスとDropwizardメトリクス間の双方向ラッパー提供
2. MetricRegistryを介したメトリクス管理
3. ScheduledReporterとの連携
4. メトリクス名のフィルタリング（ドットをハイフンに変換等）

**関連システム・外部連携**：
- Dropwizard Metrics（com.codahale.metrics）
- 各種Dropwizardレポーター（GraphiteReporter等）

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理機能 |

## 機能種別

ライブラリ連携（Dropwizard Metricsとの統合）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| host | String | レポーター依存 | 送信先ホスト（Graphite等） | - |
| port | Integer | レポーター依存 | 送信先ポート | - |
| prefix | String | No | メトリクスプレフィックス | - |
| rateConversion | String | No | レート変換単位 | TimeUnit値 |
| durationConversion | String | No | 期間変換単位 | TimeUnit値 |

### 入力データソース

- Flinkランタイムから通知されるメトリクス（Counter、Gauge、Histogram、Meter）
- 設定ファイル（flink-conf.yaml）からのレポーター設定

## 出力仕様

### 出力データ

Dropwizard MetricRegistry経由で各種レポーターに出力（レポーターによって異なる）

### 出力先

Dropwizard ScheduledReporterが出力先を決定

## 処理フロー

### 処理シーケンス

```
1. レポーター初期化（open）
   └─ 具象サブクラスでgetReporter()呼び出し
   └─ ScheduledReporter取得

2. メトリクス登録（notifyOfAddedMetric）
   └─ メトリクス識別子の生成（filterCharacters適用）
   └─ Flinkメトリクス → Dropwizardラッパー変換
   └─ MetricRegistry.register()

3. 定期レポート（report）
   └─ MetricRegistryから全メトリクス取得
   └─ ScheduledReporter.report()呼び出し

4. メトリクス削除（notifyOfRemovedMetric）
   └─ 内部マップからの削除
   └─ MetricRegistry.remove()

5. シャットダウン（close）
   └─ reporter.stop()
```

### フローチャート

```mermaid
flowchart TD
    A[開始: notifyOfAddedMetric] --> B{メトリクス種別?}
    B -->|Counter| C[FlinkCounterWrapper]
    B -->|Gauge| D[FlinkGaugeWrapper]
    B -->|Histogram| E{Dropwizard互換?}
    B -->|Meter| F{Dropwizard互換?}
    E -->|Yes| G[getDropwizardHistogram]
    E -->|No| H[FlinkHistogramWrapper]
    F -->|Yes| I[getDropwizardMeter]
    F -->|No| J[FlinkMeterWrapper]
    C --> K[registry.register]
    D --> K
    G --> K
    H --> K
    I --> K
    J --> K
    K --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ドット変換 | メトリクス名中のドット(.)はハイフン(-)に変換 | filterCharacters適用時 |
| BR-02 | ダブルクォート除去 | ダブルクォート(")は削除 | filterCharacters適用時 |
| BR-03 | Dropwizard互換優先 | Dropwizard互換のHistogram/Meterは直接登録 | 該当型の場合 |
| BR-04 | 抽象クラス | ScheduledDropwizardReporterは抽象クラス | サブクラスで実装 |

### 計算ロジック

ラッパークラスはFlink/Dropwizard間の変換のみで、計算は行わない。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | 登録エラー | 同名メトリクスの重複登録 | - |
| - | 警告ログ | 未対応メトリクス型 | ログ出力のみ |

### リトライ仕様

- 各ScheduledReporterの実装に依存

## トランザクション仕様

- MetricRegistryは内部的にConcurrentMapを使用
- スレッドセーフな操作を提供

## パフォーマンス要件

- MetricRegistryのConcurrentMap使用により並行アクセスに対応
- 同期ブロック（synchronized）でのメトリクス登録/削除

## セキュリティ考慮事項

- 各ScheduledReporterの実装に依存
- 本モジュール自体はセキュリティ機能を持たない

## 備考

- ScheduledDropwizardReporterは抽象クラスであり、具象実装が必要
- Flink標準ではGraphiteレポーター（flink-metrics-graphite）が本クラスを継承

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する（ラッパークラス群）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FlinkCounterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/FlinkCounterWrapper.java` | Flink Counter → Dropwizard Counter |
| 1-2 | FlinkGaugeWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/FlinkGaugeWrapper.java` | Flink Gauge → Dropwizard Gauge |
| 1-3 | FlinkHistogramWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/FlinkHistogramWrapper.java` | Flink Histogram → Dropwizard Histogram |
| 1-4 | FlinkMeterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/FlinkMeterWrapper.java` | Flink Meter → Dropwizard Meter |
| 1-5 | DropwizardHistogramWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/DropwizardHistogramWrapper.java` | Dropwizard Histogram → Flink Histogram |
| 1-6 | DropwizardMeterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/DropwizardMeterWrapper.java` | Dropwizard Meter → Flink Meter |

**読解のコツ**: FlinkXxxWrapperはFlink→Dropwizard変換、DropwizardXxxWrapperはDropwizard→Flink変換。双方向の変換を提供。

#### Step 2: メインレポーター実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ScheduledDropwizardReporter.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/ScheduledDropwizardReporter.java` | 抽象基底クラス |

**主要処理フロー（ScheduledDropwizardReporter.java）**:
- **68-81行目**: フィールド定義（MetricRegistry、各種マップ）
- **112-119行目**: open()でgetReporter()呼び出し
- **126-168行目**: notifyOfAddedMetric()でラッパー生成とレジストリ登録
- **172-196行目**: notifyOfRemovedMetric()でレジストリから削除
- **200-229行目**: filterCharacters()でドット→ハイフン変換
- **236-248行目**: report()でScheduledReporter.report()呼び出し
- **250行目**: getReporter()抽象メソッド（サブクラスで実装）

### プログラム呼び出し階層図

```
ScheduledDropwizardReporter（抽象）
    │
    ├─ MetricRegistry
    │      └─ ConcurrentMap（内部）
    │
    ├─ notifyOfAddedMetric()
    │      ├─ FlinkCounterWrapper → registry.register()
    │      ├─ FlinkGaugeWrapper → registry.register()
    │      ├─ FlinkHistogramWrapper → registry.register()
    │      │      or DropwizardHistogramWrapper.getDropwizardHistogram()
    │      └─ FlinkMeterWrapper → registry.register()
    │             or DropwizardMeterWrapper.getDropwizardMeter()
    │
    └─ report() [Scheduled]
           │
           └─ ScheduledReporter.report(gauges, counters, histograms, meters, timers)
```

### データフロー図

```
[Flink側]                    [変換]                         [Dropwizard側]

Flink Counter ────▶ FlinkCounterWrapper ────▶ Dropwizard Counter
Flink Gauge   ────▶ FlinkGaugeWrapper   ────▶ Dropwizard Gauge
Flink Histogram ──▶ FlinkHistogramWrapper ──▶ Dropwizard Histogram
Flink Meter   ────▶ FlinkMeterWrapper   ────▶ Dropwizard Meter

Dropwizard Histogram ◀── DropwizardHistogramWrapper ◀── Flink互換
Dropwizard Meter     ◀── DropwizardMeterWrapper     ◀── Flink互換

                    ┌─────────────────┐
                    │ MetricRegistry  │
                    └────────┬────────┘
                             │
                    ┌────────▼────────┐
                    │ ScheduledReporter│──▶ 外部システム
                    │   (Graphite等)  │    (設定依存)
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ScheduledDropwizardReporter.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/` | ソース | 抽象基底クラス |
| FlinkCounterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Counter変換 |
| FlinkGaugeWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Gauge変換 |
| FlinkHistogramWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Histogram変換（Flink→Dropwizard） |
| FlinkMeterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Meter変換（Flink→Dropwizard） |
| DropwizardHistogramWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Histogram変換（Dropwizard→Flink） |
| DropwizardMeterWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | Meter変換（Dropwizard→Flink） |
| DropwizardHistogramStatistics.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | 統計値ラッパー |
| HistogramStatisticsWrapper.java | `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/metrics/` | ソース | 統計値ラッパー |
