# 機能設計書 69-スタンドアロン

## 概要

本ドキュメントは、Apache Flinkのスタンドアロンデプロイメント機能（flink-dist モジュール）の設計仕様を記載する。

### 本機能の処理概要

スタンドアロンデプロイメント機能は、Flinkクラスターを独立したプロセスとして起動・管理するための機能である。シェルスクリプトを使用してJobManagerとTaskManagerを起動し、特定のリソースマネージャー（YARN、Kubernetes等）に依存しない環境でFlinkを実行できる。

**業務上の目的・背景**：開発・テスト環境での簡易的なFlink実行や、既存のインフラにリソースマネージャーがない環境、オンプレミスの固定クラスター構成での運用に適している。シンプルな構成でFlinkを試用・運用できる。

**機能の利用シーン**：
- ローカル開発・テスト環境でのFlink実行
- オンプレミス固定クラスター構成
- HAモード（ZooKeeper連携）でのクラスター運用
- Docker/コンテナ環境でのスタンドアロン実行

**主要な処理内容**：
1. 設定ファイル（config.yaml）の読み込み
2. JobManager（StandaloneSessionClusterEntrypoint）の起動
3. TaskManager（TaskManagerRunner）の起動
4. HA構成でのマルチマスター起動
5. ログファイル・PIDファイルの管理

**関連システム・外部連携**：
- ZooKeeper（HAモード時）
- SSH（分散クラスター構成時）

**権限による制御**：OSレベルのファイル・プロセス権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないインフラ機能 |

## 機能種別

クラスターデプロイメント（スタンドアロンモード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| env.pid.dir | String | No | PIDファイル格納ディレクトリ（デフォルト: /tmp） | - |
| env.log.dir | String | No | ログファイル格納ディレクトリ | - |
| env.log.max | Integer | No | 保持するログファイル数（デフォルト: 10） | 正整数 |
| env.log.level | String | No | ログレベル（デフォルト: INFO） | - |
| env.java.home | String | No | Javaホームディレクトリ | - |
| env.java.opts.all | String | No | 全プロセス用JVMオプション | - |
| env.java.opts.jobmanager | String | No | JobManager用JVMオプション | - |
| env.java.opts.taskmanager | String | No | TaskManager用JVMオプション | - |
| env.ssh.opts | String | No | SSH接続オプション | - |
| high-availability.type | String | No | HAタイプ（zookeeper等） | - |
| taskmanager.compute.numa | Boolean | No | NUMAノード毎にTM起動 | - |

### 入力データソース

- 設定ファイル（conf/config.yaml）
- マスターファイル（conf/masters）
- ワーカーファイル（conf/workers）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PIDファイル | File | デーモンプロセスID記録 |
| ログファイル | File | プロセスログ出力 |
| 標準出力 | Stream | 起動・停止メッセージ |

### 出力先

- PIDディレクトリ（env.pid.dir）
- ログディレクトリ（env.log.dir）

## 処理フロー

### 処理シーケンス

```
1. クラスター起動（start-cluster.sh）
   └─ config.sh読み込み
   └─ HAモード判定

2. HAモード時（ZooKeeper）
   └─ mastersファイル読み込み
   └─ 各マスターホストでjobmanager.sh start実行
   └─ SSH経由でリモートホスト起動

3. 非HAモード時
   └─ ローカルでjobmanager.sh start実行

4. TaskManager起動
   └─ TMWorkers start呼び出し
   └─ workersファイル読み込み
   └─ 各ワーカーホストでtaskmanager.sh start実行

5. デーモン起動（flink-daemon.sh）
   └─ PIDファイル管理
   └─ ログファイル設定
   └─ Javaプロセス起動
```

### フローチャート

```mermaid
flowchart TD
    A[開始: start-cluster.sh] --> B[config.sh読み込み]
    B --> C{HAモード?}
    C -->|Yes| D[mastersファイル読み込み]
    D --> E[各マスターでjobmanager.sh start]
    E --> F{ローカルホスト?}
    F -->|Yes| G[直接実行]
    F -->|No| H[SSH経由で実行]
    C -->|No| I[ローカルでjobmanager.sh start]
    G --> J[TMWorkers start]
    H --> J
    I --> J
    J --> K[workersファイル読み込み]
    K --> L[各ワーカーでtaskmanager.sh start]
    L --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | flink-dist.jar必須 | libディレクトリに単一のflink-dist*.jarが必要 | 起動時 |
| BR-02 | デフォルトG1GC | TM用JVMオプション未設定時はG1GCを使用 | TM起動時 |
| BR-03 | HAマルチマスター | ZooKeeper HA時はmastersファイルから複数マスター起動 | HAモード時 |
| BR-04 | PIDファイル管理 | プロセス毎にPIDファイルを作成・管理 | デーモン起動時 |
| BR-05 | ログローテーション | env.log.maxで指定した数までログを保持 | 常時 |
| BR-06 | NUMAバインド | taskmanager.compute.numa=true時はNUMAノード毎にTM起動 | TM起動時 |

### 計算ロジック

ログファイル名生成:
```
log_prefix = ${FLINK_LOG_DIR}/flink-${FLINK_IDENT_STRING}-${DAEMON}-${id}-${HOSTNAME}
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 起動エラー | flink-dist.jarが見つからない | libディレクトリ確認 |
| - | 起動エラー | 複数のflink-dist.jar存在 | 重複jarを削除 |
| - | SSH接続エラー | リモートホスト接続失敗 | SSH設定確認 |
| - | PIDエラー | PIDファイル書き込み失敗 | ディレクトリ権限確認 |

### リトライ仕様

- SSH接続はOS/SSHのリトライ設定に依存
- プロセス停止時は猶予時間後にSIGKILL送信

## トランザクション仕様

- PIDファイル操作時はflock（利用可能な場合）でロック
- 複数デーモン起動時の競合を防止

## パフォーマンス要件

- シェルスクリプトベースの軽量な起動処理
- バックグラウンドデーモンとしての実行

## セキュリティ考慮事項

- SSH認証（パスワードレスSSH推奨）
- ファイルシステム権限によるアクセス制御
- JVMセキュリティオプションの設定可能

## 備考

- 開発・テスト用途でのローカルクラスター構成が主な用途
- 本番環境ではYARN/Kubernetes等のリソースマネージャー利用を推奨
- HistoryServer、SQL Gatewayもスタンドアロン起動可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.sh | `flink-dist/src/main/flink-bin/bin/config.sh` | 共通設定読み込みスクリプト |

**読解のコツ**:
- **20-48行目**: constructFlinkClassPath()でクラスパス構築
- **100-112行目**: readFromConfig()で設定値読み込み
- **122-134行目**: デフォルト値定義
- **140-162行目**: 設定キー定義
- **168-200行目**: FLINK_HOME等のパス設定

#### Step 2: クラスター起動スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | start-cluster.sh | `flink-dist/src/main/flink-bin/bin/start-cluster.sh` | クラスター一括起動 |
| 2-2 | stop-cluster.sh | `flink-dist/src/main/flink-bin/bin/stop-cluster.sh` | クラスター一括停止 |

**主要処理フロー（start-cluster.sh）**:
- **23行目**: config.sh読み込み
- **27-42行目**: HAモード時のマルチマスター起動
- **44-49行目**: 非HAモード時の単一マスター起動
- **53行目**: TMWorkers start呼び出し

#### Step 3: JobManager起動スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | jobmanager.sh | `flink-dist/src/main/flink-bin/bin/jobmanager.sh` | JobManager起動 |

**主要処理フロー（jobmanager.sh）**:
- **21行目**: 使用方法定義（start/start-foreground/stop/stop-all）
- **49行目**: ENTRYPOINT=standalonesession
- **51-70行目**: JVMオプションと引数設定
- **72-76行目**: フォアグラウンド/デーモンモード分岐

#### Step 4: TaskManager起動スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | taskmanager.sh | `flink-dist/src/main/flink-bin/bin/taskmanager.sh` | TaskManager起動 |

**主要処理フロー（taskmanager.sh）**:
- **37行目**: ENTRYPOINT=taskexecutor
- **42-44行目**: デフォルトG1GC設定
- **60-80行目**: NUMAモード分岐

#### Step 5: デーモン管理スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | flink-daemon.sh | `flink-dist/src/main/flink-bin/bin/flink-daemon.sh` | デーモン起動/停止 |

**主要処理フロー（flink-daemon.sh）**:
- **32-62行目**: DAEMON種別に応じたクラス選択
- **46行目**: standalonesession → StandaloneSessionClusterEntrypoint
- **50行目**: standalonejob → StandaloneApplicationClusterEntryPoint
- **34行目**: taskexecutor → TaskManagerRunner
- **70行目**: PIDファイルパス生成
- **80-84行目**: flockによるPIDファイルロック
- **94行目**: log4j/logback設定

### プログラム呼び出し階層図

```
start-cluster.sh
    │
    ├─ config.sh（設定読み込み）
    │      └─ constructFlinkClassPath()
    │
    ├─ jobmanager.sh start
    │      │
    │      └─ flink-daemon.sh start standalonesession
    │             │
    │             └─ StandaloneSessionClusterEntrypoint.main()
    │
    └─ TMWorkers start
           │
           └─ taskmanager.sh start
                  │
                  └─ flink-daemon.sh start taskexecutor
                         │
                         └─ TaskManagerRunner.main()

stop-cluster.sh
    │
    ├─ config.sh
    ├─ taskmanager.sh stop-all
    │      └─ flink-daemon.sh stop-all taskexecutor
    │
    └─ jobmanager.sh stop-all
           └─ flink-daemon.sh stop-all standalonesession
```

### データフロー図

```
[設定ファイル]                                     [プロセス]

conf/config.yaml ──────┐
                       │
conf/masters ─────────┼──▶ config.sh ──▶ 設定変数
                       │        │
conf/workers ─────────┘        │
                               ▼
                    ┌────────────────────────┐
                    │   start-cluster.sh     │
                    │                        │
                    │  ┌──────────────────┐  │
                    │  │ jobmanager.sh    │  │
                    │  └────────┬─────────┘  │
                    │           │            │
                    │  ┌────────▼─────────┐  │
                    │  │ flink-daemon.sh  │  │
                    │  └────────┬─────────┘  │
                    │           │            │
                    └───────────┼────────────┘
                                │
                                ▼
          ┌─────────────────────┼─────────────────────┐
          │                     │                     │
          ▼                     ▼                     ▼
    ┌───────────┐        ┌───────────┐        ┌───────────┐
    │ JobManager│        │TaskManager│        │TaskManager│
    │  Process  │        │  Process  │        │  Process  │
    └───────────┘        └───────────┘        └───────────┘
          │                     │                     │
          ▼                     ▼                     ▼
    ┌───────────┐        ┌───────────┐        ┌───────────┐
    │  PID File │        │  PID File │        │  PID File │
    │  Log File │        │  Log File │        │  Log File │
    └───────────┘        └───────────┘        └───────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | 共通設定読み込み |
| start-cluster.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | クラスター一括起動 |
| stop-cluster.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | クラスター一括停止 |
| jobmanager.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | JobManager起動/停止 |
| taskmanager.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | TaskManager起動/停止 |
| flink-daemon.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | デーモン管理 |
| flink-console.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | フォアグラウンド起動 |
| standalone-job.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | スタンドアロンジョブ起動 |
| historyserver.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | HistoryServer起動 |
| zookeeper.sh | `flink-dist/src/main/flink-bin/bin/` | シェル | ZooKeeper起動 |
| StandaloneSessionClusterEntrypoint.java | `flink-runtime/src/main/java/org/apache/flink/runtime/entrypoint/` | ソース | セッションクラスターエントリーポイント |
| TaskManagerRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | ソース | TaskManagerエントリーポイント |
