# 機能設計書 84-チュートリアル

## 概要

本ドキュメントは、Apache Flinkの入門チュートリアル（flink-walkthroughs）の機能設計書である。Mavenアーキタイプ形式で提供され、新規プロジェクト作成時のスケルトンコードとして利用される。

### 本機能の処理概要

flink-walkthroughsモジュールは、Flinkを初めて使用する開発者向けの入門チュートリアルプロジェクトである。Mavenアーキタイプとして提供され、`mvn archetype:generate`コマンドで新規プロジェクトを生成できる。詐欺検知（Fraud Detection）を題材にした実践的なサンプルを含む。

**業務上の目的・背景**：Flinkの学習曲線を緩やかにするため、実際に動作するプロジェクトテンプレートを提供する。開発者は環境構築から始める必要がなく、すぐにFlinkの概念を学習できる。詐欺検知という現実的なユースケースを通じて、ステートフルストリーム処理の基本を理解できる。

**機能の利用シーン**：(1)Flink入門時の学習教材、(2)ハンズオンワークショップの素材、(3)新規プロジェクトのスターターテンプレート

**主要な処理内容**：
1. **FraudDetectionJob**: メインジョブクラス。TransactionSourceからデータを読み込み、FraudDetectorで処理し、AlertSinkに出力
2. **FraudDetector**: KeyedProcessFunctionを継承した詐欺検知ロジック（実装はユーザーが完成させる）
3. **Transaction**: 取引データエンティティ（accountId, timestamp, amount）
4. **Alert**: アラートエンティティ（accountId）

**関連システム・外部連携**：なし（自己完結型チュートリアル）

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | チュートリアルプロジェクトのため関連画面なし |

## 機能種別

Mavenアーキタイプ / 学習リソース / プロジェクトテンプレート

## 入力仕様

### 入力パラメータ（アーキタイプ生成時）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| groupId | String | Yes | Mavenグループ ID | 有効なグループID形式 |
| artifactId | String | Yes | Maven アーティファクトID | 有効なアーティファクトID形式 |
| version | String | No | プロジェクトバージョン | - |
| package | String | No | Javaパッケージ名 | 有効なパッケージ名形式 |

### 入力データソース

- TransactionSource: テスト用取引データを生成するカスタムソース

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Alert.id | long | アラート対象のアカウントID |

### 出力先

- AlertSink: ログ出力によるシンク（開発/学習用）

## 処理フロー

### 処理シーケンス

```
1. StreamExecutionEnvironment取得
   └─ getExecutionEnvironment()
2. TransactionSource追加
   └─ env.addSource(new TransactionSource())
3. KeyBy設定
   └─ keyBy(Transaction::getAccountId)
4. FraudDetector処理
   └─ process(new FraudDetector())
5. AlertSink追加
   └─ addSink(new AlertSink())
6. ジョブ実行
   └─ env.execute("Fraud Detection")
```

### フローチャート

```mermaid
flowchart TD
    A[main開始] --> B[StreamExecutionEnvironment取得]
    B --> C[TransactionSource追加]
    C --> D[keyBy - accountIdでグループ化]
    D --> E[process - FraudDetector]
    E --> F[addSink - AlertSink]
    F --> G[execute - ジョブ実行]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 詐欺検知ロジック | 小額取引の直後に大額取引がある場合にアラート | FraudDetector実装時 |
| BR-002 | ステート管理 | 前回取引情報をValueStateで保持 | KeyedProcessFunction使用時 |

### 計算ロジック

詐欺検知ロジックはチュートリアルの学習課題として、ユーザーが実装する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

チュートリアルプロジェクトのため特別なエラー処理は含まれていない。

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

チュートリアルプロジェクトのため特定のパフォーマンス要件はない。

## セキュリティ考慮事項

チュートリアルプロジェクトのため特別なセキュリティ対策は含まれていない。

## 備考

- flink-walkthrough-datastream-java: DataStream API版
- flink-walkthrough-common: 共通エンティティ・ソース・シンク
- Mavenアーキタイプとして配布され、`mvn archetype:generate`で利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データモデルを理解する

まず、処理対象のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Transaction.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/org/apache/flink/walkthrough/common/entity/Transaction.java` | 取引データエンティティ |
| 1-2 | Alert.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/org/apache/flink/walkthrough/common/entity/Alert.java` | アラートエンティティ |

**読解のコツ**: TransactionはaccountId、timestamp、amountの3フィールドを持つシンプルなPOJO。Alertはアラート対象のアカウントIDを保持する。

#### Step 2: ジョブ全体構成を理解する

メインジョブクラスで、データフローの全体像を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FraudDetectionJob.java | `flink-walkthroughs/flink-walkthrough-datastream-java/src/main/resources/archetype-resources/src/main/java/FraudDetectionJob.java` | ジョブ構成 |

**主要処理フロー**:
- **33行目**: StreamExecutionEnvironment.getExecutionEnvironment()
- **35-37行目**: TransactionSourceの追加
- **39-42行目**: keyBy + process(FraudDetector)
- **44-46行目**: AlertSinkの追加
- **48行目**: env.execute()

**読解のコツ**: 典型的なFlinkジョブの構成パターン：Source→変換→Sink→execute

#### Step 3: ソース・シンクを理解する

データ入出力のカスタム実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransactionSource.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/org/apache/flink/walkthrough/common/source/TransactionSource.java` | カスタムソース |
| 3-2 | AlertSink.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/org/apache/flink/walkthrough/common/sink/AlertSink.java` | カスタムシンク |

### プログラム呼び出し階層図

```
FraudDetectionJob.main()
    │
    ├─ StreamExecutionEnvironment.getExecutionEnvironment()
    │
    ├─ env.addSource(new TransactionSource())
    │      └─ TransactionIterator
    │
    ├─ transactions.keyBy(Transaction::getAccountId)
    │
    ├─ .process(new FraudDetector())
    │      └─ KeyedProcessFunction
    │             ├─ processElement()
    │             └─ onTimer()
    │
    ├─ alerts.addSink(new AlertSink())
    │      └─ SinkFunction
    │
    └─ env.execute("Fraud Detection")
```

### データフロー図

```
[入力]                    [処理]                        [出力]

TransactionSource    keyBy(accountId)
┌───────────────┐    ┌──────────────────┐
│ Transaction   │───▶│ アカウント別グループ│
│ - accountId   │    │                  │
│ - timestamp   │    └──────────────────┘
│ - amount      │           │
└───────────────┘     FraudDetector
                     ┌──────────────────┐
                     │ 詐欺パターン検知   │
                     │ (学習課題として   │
                     │  ユーザーが実装)  │
                     └──────────────────┘
                           │
                       Alert
                     ┌───────────────┐
                     │ - id          │───▶ AlertSink (ログ出力)
                     └───────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FraudDetectionJob.java | `flink-walkthroughs/.../archetype-resources/src/main/java/FraudDetectionJob.java` | テンプレート | メインジョブ |
| FraudDetector.java | `flink-walkthroughs/.../archetype-resources/src/main/java/FraudDetector.java` | テンプレート | 詐欺検知ロジック（スケルトン） |
| Transaction.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/.../entity/Transaction.java` | ソース | 取引データエンティティ |
| Alert.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/.../entity/Alert.java` | ソース | アラートエンティティ |
| TransactionSource.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/.../source/TransactionSource.java` | ソース | カスタムソース |
| TransactionIterator.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/.../source/TransactionIterator.java` | ソース | 取引データイテレーター |
| AlertSink.java | `flink-walkthroughs/flink-walkthrough-common/src/main/java/.../sink/AlertSink.java` | ソース | カスタムシンク |
| pom.xml | `flink-walkthroughs/flink-walkthrough-datastream-java/pom.xml` | 設定 | Mavenアーキタイプ設定 |
