# 機能設計書 86-APIアノテーション

## 概要

本ドキュメントは、Apache FlinkのAPIアノテーション（flink-annotations）の機能設計書である。Public、Internal、PublicEvolving、Experimental等のアノテーションにより、APIの安定性と可視性を明示する。

### 本機能の処理概要

flink-annotationsモジュールは、FlinkのAPIに対して安定性レベルと可視性を示すアノテーションを提供する。これらのアノテーションにより、開発者はAPIが将来のバージョンで変更される可能性を把握し、適切なAPIを選択できる。

**業務上の目的・背景**：Flinkは大規模なフレームワークであり、多くのAPIを公開している。すべてのAPIが同じ安定性レベルを持つわけではなく、内部実装用のAPIと公開APIを明確に区別する必要がある。アノテーションにより、APIの契約を明示し、開発者が安全にAPIを利用できるようになる。

**機能の利用シーン**：(1)API設計時の安定性レベル指定、(2)IDEでのAPI情報表示、(3)ドキュメント生成時のAPI分類、(4)アーキテクチャテストでのAPI検証

**主要な処理内容**：
1. **@Public**: 安定した公開API。マイナーリリース間で互換性が保証される
2. **@PublicEvolving**: 公開APIだがインターフェースが変更される可能性あり
3. **@Internal**: 内部開発者向けAPI。リリース間で変更される可能性あり
4. **@Experimental**: 実験的API。十分にテストされておらず変更・削除される可能性あり
5. **@VisibleForTesting**: テスト目的でのみ公開されているAPI
6. **@Documentation関連**: ドキュメント生成用のアノテーション

**関連システム・外部連携**：ArchUnitによるアーキテクチャテスト、ドキュメント生成ツール

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | アノテーション定義のため関連画面なし |

## 機能種別

メタデータ定義 / コンパイル時アノテーション

## 入力仕様

### 入力パラメータ

アノテーションのためパラメータなし（@Documentation関連は属性を持つ）

### 入力データソース

なし

## 出力仕様

### 出力データ

アノテーション情報はランタイムで保持され、リフレクションでアクセス可能。

### 出力先

クラスファイルのメタデータ

## 処理フロー

### 処理シーケンス

アノテーションは宣言的であり、処理フローは存在しない。

### フローチャート

なし

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | @Public互換性 | マイナーリリース（1.x）間で互換性維持。メジャーリリース（2.0等）で変更可能 | @Public付きAPI |
| BR-002 | @PublicEvolving互換性 | 動作は安定だがインターフェースは変更可能 | @PublicEvolving付きAPI |
| BR-003 | @Internal使用制限 | 外部アプリケーションからの使用は非推奨 | @Internal付きAPI |
| BR-004 | @Experimental警告 | 本番使用は推奨されない | @Experimental付きAPI |
| BR-005 | @VisibleForTesting使用制限 | テストコードからのみ使用可能 | @VisibleForTesting付きAPI |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

アノテーション自体はエラーを発生させない。アーキテクチャテストで違反を検出した場合、テスト失敗となる。

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

なし

## セキュリティ考慮事項

なし

## 備考

- すべてのアノテーションは@Retention(RetentionPolicy.RUNTIME)でランタイムまで保持
- アノテーション自体に@Publicが付与されており、安定したAPI
- FlinkVersionクラスでバージョン情報を管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 主要アノテーションを理解する

各アノテーションの意味と適用範囲を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Public.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Public.java` | 安定公開API |
| 1-2 | PublicEvolving.java | `flink-annotations/src/main/java/org/apache/flink/annotation/PublicEvolving.java` | 進化中公開API |
| 1-3 | Internal.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Internal.java` | 内部API |
| 1-4 | Experimental.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Experimental.java` | 実験的API |

**主要処理フロー（Public.java）**:
- **29-35行目**: Javadocで安定性契約を説明
- **37-41行目**: @Documented, @Target, @Retention定義
- **40行目**: RetentionPolicy.RUNTIMEでランタイム保持

**読解のコツ**: 各アノテーションのJavadocが安定性契約を定義している。@Target定義で適用可能な要素タイプを確認。

#### Step 2: ドキュメント関連アノテーションを理解する

ドキュメント生成用のアノテーションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Documentation.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/Documentation.java` | ドキュメント生成用 |
| 2-2 | ConfigGroups.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/ConfigGroups.java` | 設定グループ定義 |

### プログラム呼び出し階層図

```
アノテーション定義（flink-annotations）
    │
    ├─ @Public
    │      └─ 安定API、メジャーリリースまで互換性保証
    │
    ├─ @PublicEvolving
    │      └─ 公開APIだがインターフェース変更あり
    │
    ├─ @Internal
    │      └─ 内部API、外部使用非推奨
    │
    ├─ @Experimental
    │      └─ 実験的API、変更・削除あり
    │
    ├─ @VisibleForTesting
    │      └─ テストのみ使用可
    │
    └─ @Documentation系
           └─ ドキュメント生成用メタデータ
```

### データフロー図

```
[定義]                    [使用]                        [検証]

@Public              クラス/メソッド定義           ArchUnitテスト
@PublicEvolving  ───▶ ┌──────────────────┐    ┌─────────────────┐
@Internal            │ APIコード         │───▶│ ApiAnnotation   │
@Experimental        │ @Public           │    │ Rules検証       │
                     │ class Foo { ... } │    └─────────────────┘
                     └──────────────────┘
                              │
                              ▼
                     ドキュメント生成
                     ┌──────────────────┐
                     │ ConfigOptions    │
                     │ DocGenerator     │
                     └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Public.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Public.java` | ソース | 安定公開APIアノテーション |
| PublicEvolving.java | `flink-annotations/src/main/java/org/apache/flink/annotation/PublicEvolving.java` | ソース | 進化中公開APIアノテーション |
| Internal.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Internal.java` | ソース | 内部APIアノテーション |
| Experimental.java | `flink-annotations/src/main/java/org/apache/flink/annotation/Experimental.java` | ソース | 実験的APIアノテーション |
| VisibleForTesting.java | `flink-annotations/src/main/java/org/apache/flink/annotation/VisibleForTesting.java` | ソース | テスト公開アノテーション |
| Documentation.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/Documentation.java` | ソース | ドキュメントアノテーション |
| ConfigGroup.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/ConfigGroup.java` | ソース | 設定グループアノテーション |
| ConfigGroups.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/ConfigGroups.java` | ソース | 設定グループ複数指定 |
| FlinkJsonSchema.java | `flink-annotations/src/main/java/org/apache/flink/annotation/docs/FlinkJsonSchema.java` | ソース | JSONスキーマアノテーション |
| FlinkVersion.java | `flink-annotations/src/main/java/org/apache/flink/FlinkVersion.java` | ソース | Flinkバージョン情報 |
