# 機能設計書 87-依存性チェック

## 概要

本ドキュメントは、Apache FlinkのArchUnitによるアーキテクチャテスト（flink-architecture-tests）の機能設計書である。コードベースのアーキテクチャルールを自動検証し、設計原則の遵守を保証する。

### 本機能の処理概要

flink-architecture-testsモジュールは、ArchUnitを使用してFlinkのコードベースに対するアーキテクチャルールを定義・検証する。APIアノテーションの正しい使用、依存関係の制約、コーディング規約の遵守を自動的にチェックする。

**業務上の目的・背景**：大規模プロジェクトでは、アーキテクチャ原則を手動でレビューすることは困難である。ArchUnitによる自動検証により、コードレビューの負荷を軽減し、一貫したアーキテクチャを維持できる。新規コントリビューターも既存のルールに従いやすくなる。

**機能の利用シーン**：(1)CIパイプラインでのアーキテクチャ検証、(2)PRレビュー時の自動チェック、(3)アーキテクチャルール違反の早期検出、(4)コーディング規約の強制

**主要な処理内容**：
1. **ApiAnnotationRules**: APIアノテーション（@Public, @Internal等）の正しい使用を検証
2. **ConnectorRules**: コネクタ実装のルール検証
3. **TableApiRules**: Table API固有のルール検証
4. **ITCaseRules**: 統合テストの命名規約検証
5. **BanJunit4Rules**: JUnit 4使用禁止ルール検証
6. **CheckpointingConfigurationAccessRules**: チェックポイント設定アクセスルール

**関連システム・外部連携**：ArchUnit、JUnit 5

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | テストフレームワークのため関連画面なし |

## 機能種別

アーキテクチャテスト / 静的解析

## 入力仕様

### 入力パラメータ

テストとして実行されるため、入力パラメータなし。検査対象はコンパイル済みクラスファイル。

### 入力データソース

クラスパス上のクラスファイル（ArchUnitが読み込み）

## 出力仕様

### 出力データ

テスト結果（成功/失敗）。失敗時は違反内容を詳細出力。

### 出力先

JUnitテストレポート、コンソール出力

## 処理フロー

### 処理シーケンス

```
1. クラスローディング
   └─ ArchUnitがクラスファイルを読み込み
2. ルール評価
   └─ 各@ArchTestルールを適用
3. 違反検出
   └─ ルール違反があればテスト失敗
4. フリーズ機能
   └─ 既知の違反はfreeze()でスキップ
5. 結果出力
   └─ JUnitレポート
```

### フローチャート

```mermaid
flowchart TD
    A[テスト開始] --> B[ArchUnitクラスロード]
    B --> C[ルール適用]
    C --> D{違反あり?}
    D -->|Yes| E{フリーズ済み?}
    D -->|No| F[テスト成功]
    E -->|Yes| F
    E -->|No| G[テスト失敗]
    G --> H[違反内容出力]
    F --> I[終了]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | APIアノテーション必須 | org.apache.flink..api..パッケージの公開クラスはAPIアノテーション必須 | APIパッケージのクラス |
| BR-002 | @Public戻り値型制約 | @Public メソッドの戻り値・引数は@Public型のみ使用可 | @Publicメソッド |
| BR-003 | @VisibleForTesting使用禁止 | 本番コードから@VisibleForTestingメソッドを呼び出し禁止 | 本番コード |
| BR-004 | フリーズルール | 既存違反は freeze() でスキップ可能（新規違反は検出） | 移行期間中 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArchitectureViolation | ルール違反検出 | コードを修正するか、freeze()で既知違反として登録 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

なし（テスト時のみ実行）

## セキュリティ考慮事項

なし

## 備考

- flink-architecture-tests-base: 共通ルール基盤
- flink-architecture-tests-production: 本番コード用ルール
- flink-architecture-tests-test: テストコード用ルール
- freeze()機能により段階的なルール適用が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: APIアノテーションルールを理解する

APIアノテーションの使用ルールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApiAnnotationRules.java | `flink-architecture-tests/flink-architecture-tests-production/src/main/java/org/apache/flink/architecture/rules/ApiAnnotationRules.java` | APIアノテーションルール |

**主要処理フロー**:
- **48-66行目**: ANNOTATED_APISルール - APIパッケージの公開クラスはアノテーション必須
- **69-96行目**: PUBLIC_API_METHODS_USE_ONLY_PUBLIC_API_TYPESルール - @Public戻り値型制約
- **99-128行目**: PUBLIC_EVOLVING_API_METHODS_USE_ONLY_PUBLIC_EVOLVING_API_TYPESルール
- **131-173行目**: NO_CALLS_TO_VISIBLE_FOR_TESTING_METHODSルール

**読解のコツ**: 各ルールは@ArchTestアノテーションが付与されたstatic finalフィールドとして定義。freeze()でラップすることで既存違反をスキップ。

#### Step 2: 共通ユーティリティを理解する

ルール定義に使用するユーティリティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Predicates.java | `flink-architecture-tests/flink-architecture-tests-base/src/main/java/org/apache/flink/architecture/common/Predicates.java` | カスタム述語 |
| 2-2 | Conditions.java | `flink-architecture-tests/flink-architecture-tests-base/src/main/java/org/apache/flink/architecture/common/Conditions.java` | カスタム条件 |

#### Step 3: テストコードルールを理解する

テストコード固有のルールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ITCaseRules.java | `flink-architecture-tests/flink-architecture-tests-test/src/main/java/org/apache/flink/architecture/rules/ITCaseRules.java` | ITCase命名規約 |
| 3-2 | BanJunit4Rules.java | `flink-architecture-tests/flink-architecture-tests-test/src/main/java/org/apache/flink/architecture/rules/BanJunit4Rules.java` | JUnit 4禁止ルール |

### プログラム呼び出し階層図

```
ArchitectureTest
    │
    ├─ @AnalyzeClasses(packages = "org.apache.flink")
    │      └─ ArchUnit がクラスをロード
    │
    └─ @ArchTest ルール
           │
           ├─ ApiAnnotationRules.ANNOTATED_APIS
           │      └─ javaClassesThat().resideInAPackage("..api..")
           │             └─ should(fulfill(areDirectlyAnnotatedWithAtLeastOneOf(...)))
           │
           ├─ ApiAnnotationRules.PUBLIC_API_METHODS_USE_ONLY_PUBLIC_API_TYPES
           │      └─ methods().that().areAnnotatedWith(Public.class)
           │             └─ should(haveLeafTypes(...))
           │
           └─ ApiAnnotationRules.NO_CALLS_TO_VISIBLE_FOR_TESTING_METHODS
                  └─ noJavaClassesThat().should().callMethodWhere(...)
```

### データフロー図

```
[入力]                      [処理]                        [出力]

コンパイル済みクラス      ArchUnit解析
┌───────────────────┐    ┌──────────────────┐
│ .class ファイル    │───▶│ ClassFileImporter│
│ (クラスパス)       │    └──────────────────┘
└───────────────────┘           │
                                ▼
                         ルール適用
                        ┌──────────────────┐
                        │ @ArchTest        │
                        │ ルール評価        │
                        └──────────────────┘
                                │
                          ┌─────┴─────┐
                          ▼           ▼
                        成功        違反検出
                                      │
                          ┌───────────┴───────────┐
                          ▼                       ▼
                     フリーズ済み              新規違反
                     (スキップ)               (テスト失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ApiAnnotationRules.java | `flink-architecture-tests/.../rules/ApiAnnotationRules.java` | ソース | APIアノテーションルール |
| ConnectorRules.java | `flink-architecture-tests/.../rules/ConnectorRules.java` | ソース | コネクタルール |
| TableApiRules.java | `flink-architecture-tests/.../rules/TableApiRules.java` | ソース | Table APIルール |
| CheckpointingConfigurationAccessRules.java | `flink-architecture-tests/.../rules/CheckpointingConfigurationAccessRules.java` | ソース | チェックポイント設定ルール |
| ITCaseRules.java | `flink-architecture-tests/.../rules/ITCaseRules.java` | ソース | ITCase命名規約ルール |
| BanJunit4Rules.java | `flink-architecture-tests/.../rules/BanJunit4Rules.java` | ソース | JUnit 4禁止ルール |
| Predicates.java | `flink-architecture-tests/.../common/Predicates.java` | ソース | カスタム述語 |
| Conditions.java | `flink-architecture-tests/.../common/Conditions.java` | ソース | カスタム条件 |
| GivenJavaClasses.java | `flink-architecture-tests/.../common/GivenJavaClasses.java` | ソース | クラス選択ヘルパー |
| ProductionCodeArchitectureBase.java | `flink-architecture-tests/.../ProductionCodeArchitectureBase.java` | ソース | 本番コードテスト基盤 |
| TestCodeArchitectureTestBase.java | `flink-architecture-tests/.../TestCodeArchitectureTestBase.java` | ソース | テストコードテスト基盤 |
| ArchitectureTest.java | `flink-architecture-tests/.../ArchitectureTest.java` | テスト | メインテストクラス |
