# 機能設計書 88-ドキュメント生成

## 概要

本ドキュメントは、Apache Flinkの設定オプションドキュメント自動生成（flink-docs）の機能設計書である。ConfigOptionの定義からHTMLドキュメントを自動生成し、ドキュメントの一貫性と最新性を保証する。

### 本機能の処理概要

flink-docsモジュールは、Flinkの設定オプション（ConfigOption）の定義からHTMLテーブル形式のドキュメントを自動生成する。また、REST APIの仕様書（OpenAPI形式）も自動生成する。これにより、コードとドキュメントの乖離を防ぎ、常に最新の情報を提供できる。

**業務上の目的・背景**：Flinkには多数の設定オプションが存在し、手動でドキュメントを管理すると更新漏れや不整合が発生しやすい。ConfigOptionの定義から自動生成することで、コードがドキュメントの唯一の情報源（Single Source of Truth）となり、常に正確なドキュメントを維持できる。

**機能の利用シーン**：(1)リリースビルド時のドキュメント生成、(2)公式ドキュメントサイトの更新、(3)REST API仕様書の生成

**主要な処理内容**：
1. **ConfigOptionsDocGenerator**: ConfigOptionからHTMLテーブルを生成
2. **RuntimeRestAPIDocGenerator**: Runtime REST APIドキュメント生成
3. **RuntimeOpenApiSpecGenerator**: Runtime OpenAPI仕様生成
4. **SqlGatewayRestAPIDocGenerator**: SQL Gateway REST APIドキュメント生成
5. **SqlGatewayOpenApiSpecGenerator**: SQL Gateway OpenAPI仕様生成

**関連システム・外部連携**：Mavenビルドプロセス、Webサイト生成パイプライン

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ドキュメント生成ツールのため関連画面なし |

## 機能種別

ドキュメント生成 / ビルドツール

## 入力仕様

### 入力パラメータ（ConfigOptionsDocGenerator.main）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args[0] | String | Yes | 出力ディレクトリパス | 書き込み可能なディレクトリ |
| args[1] | String | Yes | プロジェクトルートディレクトリ | 存在するディレクトリ |

### 入力データソース

- ConfigOptionを定義するJavaクラス（クラスパス上）
- @Documentation.Sectionアノテーション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTMLテーブル | String | 設定オプションのHTMLテーブル（key, default, type, description） |
| OpenAPI仕様 | String | REST APIのOpenAPI形式仕様 |

### 出力先

指定された出力ディレクトリ内のHTMLファイル

## 処理フロー

### 処理シーケンス

```
1. ConfigurationOptionLocatorでオプションクラスを発見
   └─ クラスパスをスキャン
2. 各クラスからConfigOptionフィールドを抽出
   └─ リフレクションでstatic finalフィールドを取得
3. アノテーション情報を解析
   └─ @Documentation.Section, @Documentation.TableOption等
4. HTMLテーブル生成
   └─ キー、デフォルト値、型、説明を含むHTML
5. セクション別ファイル出力
   └─ 設定グループごとにファイルを分割
```

### フローチャート

```mermaid
flowchart TD
    A[main開始] --> B[出力ディレクトリ・ルートディレクトリ取得]
    B --> C[ConfigurationOptionLocatorでクラス発見]
    C --> D[各クラスを処理]
    D --> E[ConfigOptionフィールド抽出]
    E --> F[アノテーション解析]
    F --> G{@Documentation.Sectionあり?}
    G -->|Yes| H[セクション別に分類]
    G -->|No| I[デフォルトグループに分類]
    H --> J[HTMLテーブル生成]
    I --> J
    J --> K[ファイル出力]
    K --> L{次のクラス?}
    L -->|Yes| D
    L -->|No| M[共通セクションファイル生成]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | アノテーション必須 | ConfigOptionクラスは@Public/@PublicEvolving/@Experimentalが必要 | ドキュメント生成対象クラス |
| BR-002 | Deprecated除外 | @Deprecatedフィールドはドキュメントから除外 | フィールド処理時 |
| BR-003 | ExcludeFromDocumentation除外 | @Documentation.ExcludeFromDocumentationはドキュメントから除外 | フィールド処理時 |
| BR-004 | セクション分類 | @Documentation.Sectionでドキュメントセクションを指定 | フィールドにアノテーションあり |

### 計算ロジック

- デフォルト値の文字列化：Duration→TimeUtils.formatWithHighestUnit()、List→セミコロン区切り、Map→key:value,key2:value2形式

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeException | アノテーション不足 | ConfigOptionクラスにAPIアノテーションがない | クラスにアノテーションを追加 |
| RuntimeException | セクション空 | @Documentation.Sectionのvalueが空 | セクション値を指定 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

ビルド時に一度実行されるため、特定のパフォーマンス要件はない。

## セキュリティ考慮事項

なし

## 備考

- 生成されたHTMLはFlinkの公式ドキュメントサイトで使用される
- ConfigGroupsアノテーションで設定グループを定義可能
- Enum型の場合、各値の説明も自動生成される（DescribedEnum実装時）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインジェネレーターを理解する

ConfigOptionsDocGeneratorの全体構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConfigOptionsDocGenerator.java | `flink-docs/src/main/java/org/apache/flink/docs/configuration/ConfigOptionsDocGenerator.java` | メイン生成ロジック |

**主要処理フロー**:
- **107-114行目**: mainメソッド - エントリーポイント
- **117-137行目**: verifyClassAnnotation() - クラスアノテーション検証
- **140-200行目**: generateCommonSection() - 共通セクション生成
- **226-259行目**: createTables() - テーブル生成
- **269-300行目**: generateTablesForClass() - クラスごとのテーブル生成
- **322-344行目**: toHtmlTable() - HTMLテーブル生成
- **352-393行目**: toHtmlString() - 行生成
- **543-576行目**: stringifyDefault() - デフォルト値文字列化

**読解のコツ**: ConfigurationOptionLocatorがConfigOptionクラスを発見し、各クラスに対してgenerateTablesForClassを呼び出す。生成されたHTMLはFiles.write()でファイル出力。

#### Step 2: HTML生成の詳細を理解する

HTMLテーブルの構造と各列の生成方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConfigOptionsDocGenerator.java | `flink-docs/src/main/java/org/apache/flink/docs/configuration/ConfigOptionsDocGenerator.java` | toHtmlTable, toHtmlString |

**主要処理フロー**:
- **324-331行目**: テーブルヘッダー（Key, Default, Type, Description）
- **376-393行目**: 各オプションの行生成

#### Step 3: REST API仕様生成を理解する

OpenAPI形式のREST API仕様生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OpenApiSpecGenerator.java | `flink-docs/src/main/java/org/apache/flink/docs/rest/OpenApiSpecGenerator.java` | OpenAPI仕様生成 |
| 3-2 | RestAPIDocGenerator.java | `flink-docs/src/main/java/org/apache/flink/docs/rest/RestAPIDocGenerator.java` | REST APIドキュメント生成 |

### プログラム呼び出し階層図

```
ConfigOptionsDocGenerator.main()
    │
    ├─ createTables()
    │      └─ ConfigurationOptionLocator.discoverOptionsAndApply()
    │             └─ 各ConfigOptionクラスを発見
    │                    │
    │                    └─ generateTablesForClass()
    │                           ├─ selectOptionsToDocument()
    │                           │      └─ shouldBeDocumented()
    │                           │             └─ @Deprecated/@ExcludeFromDocumentation除外
    │                           └─ toHtmlTable()
    │                                  └─ toHtmlString()
    │                                         ├─ getDocumentedKey()
    │                                         ├─ stringifyDefault()
    │                                         ├─ typeToHtml()
    │                                         └─ getDescription()
    │
    └─ generateCommonSection()
           └─ findSectionOptions()
                  └─ @Documentation.Section付きオプション収集
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ConfigOption定義クラス
┌───────────────────────┐
│ @Public               │
│ class FooOptions {    │
│   static final        │    ConfigurationOptionLocator
│   ConfigOption<String>│───▶┌─────────────────────┐
│   FOO = ...           │    │ クラス発見・解析      │
│ }                     │    └─────────────────────┘
└───────────────────────┘            │
                                     ▼
                              generateTablesForClass
                              ┌─────────────────────┐
                              │ オプション抽出        │
                              │ アノテーション解析    │
                              └─────────────────────┘
                                     │
                                     ▼
                              toHtmlTable
                              ┌─────────────────────┐
                              │ HTMLテーブル生成      │───▶ foo_configuration.html
                              │ <table>...</table>  │
                              └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ConfigOptionsDocGenerator.java | `flink-docs/src/main/java/.../configuration/ConfigOptionsDocGenerator.java` | ソース | 設定オプションドキュメント生成 |
| ConfigurationOptionLocator.java | `flink-docs/src/main/java/.../util/ConfigurationOptionLocator.java` | ソース | ConfigOptionクラス発見 |
| OptionWithMetaInfo.java | `flink-docs/src/main/java/.../util/OptionWithMetaInfo.java` | ソース | オプションとメタ情報の保持 |
| Utils.java | `flink-docs/src/main/java/.../util/Utils.java` | ソース | ユーティリティ |
| RestAPIDocGenerator.java | `flink-docs/src/main/java/.../rest/RestAPIDocGenerator.java` | ソース | REST APIドキュメント生成 |
| OpenApiSpecGenerator.java | `flink-docs/src/main/java/.../rest/OpenApiSpecGenerator.java` | ソース | OpenAPI仕様生成 |
| RuntimeRestAPIDocGenerator.java | `flink-docs/src/main/java/.../rest/RuntimeRestAPIDocGenerator.java` | ソース | Runtimeモジュール用 |
| RuntimeOpenApiSpecGenerator.java | `flink-docs/src/main/java/.../rest/RuntimeOpenApiSpecGenerator.java` | ソース | Runtimeモジュール用 |
| SqlGatewayRestAPIDocGenerator.java | `flink-docs/src/main/java/.../rest/SqlGatewayRestAPIDocGenerator.java` | ソース | SQL Gateway用 |
| SqlGatewayOpenApiSpecGenerator.java | `flink-docs/src/main/java/.../rest/SqlGatewayOpenApiSpecGenerator.java` | ソース | SQL Gateway用 |
