# 機能設計書 89-プロジェクトテンプレート

## 概要

本ドキュメントは、Apache FlinkのMaven Archetypeベースのプロジェクトテンプレート（flink-quickstart）の機能設計書である。新規Flinkアプリケーションのひな形を自動生成し、開発者の迅速なプロジェクト立ち上げを支援する。

### 本機能の処理概要

flink-quickstartモジュールは、Maven Archetypeを使用してFlinkアプリケーションの雛形プロジェクトを生成する。開発者はコマンド一つで、必要な依存関係・ビルド設定・サンプルコードを含む完全なプロジェクト構造を取得できる。

**業務上の目的・背景**：Flinkアプリケーション開発を始める際、依存関係の設定やビルド構成の作成は煩雑で時間がかかる。Maven Archetypeによるプロジェクトテンプレートを提供することで、開発者はすぐにビジネスロジックの実装に集中できる。

**機能の利用シーン**：(1)新規Flinkプロジェクトの開始、(2)学習・チュートリアル用プロジェクトの作成、(3)PoC（概念実証）プロジェクトの迅速な立ち上げ

**主要な処理内容**：
1. **flink-quickstart-java**: Java用DataStreamジョブテンプレート
2. **archetype-metadata.xml**: Archetypeメタデータ定義
3. **DataStreamJob.java**: サンプルジョブのテンプレート
4. **pom.xml（テンプレート）**: 依存関係とビルド設定

**関連システム・外部連携**：Maven Archetype Plugin、Maven Central Repository

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツールのため関連画面なし |

## 機能種別

プロジェクトテンプレート / コード生成

## 入力仕様

### 入力パラメータ（Maven Archetypeコマンド）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| archetypeGroupId | String | Yes | org.apache.flink | 固定値 |
| archetypeArtifactId | String | Yes | flink-quickstart-java | 固定値 |
| archetypeVersion | String | Yes | Flinkバージョン | 存在するバージョン |
| groupId | String | Yes | 生成プロジェクトのgroupId | Maven命名規則 |
| artifactId | String | Yes | 生成プロジェクトのartifactId | Maven命名規則 |
| version | String | No | 生成プロジェクトのバージョン | デフォルト: 1.0-SNAPSHOT |
| package | String | No | Javaパッケージ名 | デフォルト: groupIdと同じ |

### 入力データソース

Archetypeリソース（archetype-resources配下）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プロジェクトディレクトリ | Directory | Maven標準ディレクトリ構造 |
| pom.xml | File | ビルド設定ファイル |
| DataStreamJob.java | File | サンプルジョブクラス |

### 出力先

ユーザー指定のディレクトリ（カレントディレクトリ配下にartifactId名で作成）

## 処理フロー

### 処理シーケンス

```
1. Archetypeインストール
   └─ Maven Centralからflink-quickstart-java取得
2. プロジェクト生成
   └─ mvn archetype:generate実行
3. テンプレート変数置換
   └─ ${groupId}, ${artifactId}等を置換
4. ディレクトリ構造生成
   └─ src/main/java, src/main/resources作成
5. ファイル出力
   └─ pom.xml, DataStreamJob.java生成
```

### フローチャート

```mermaid
flowchart TD
    A[mvn archetype:generate] --> B[Archetype取得]
    B --> C[パラメータ入力/確認]
    C --> D[テンプレート処理]
    D --> E[変数置換]
    E --> F{packaged=true?}
    F -->|Yes| G[パッケージディレクトリ作成]
    F -->|No| H[ルートに配置]
    G --> I[ファイル出力]
    H --> I
    I --> J[プロジェクト完成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | パッケージ変換 | ${package}はディレクトリパスに変換 | packaged="true"のファイルセット |
| BR-002 | フィルタリング | filtered="true"でテンプレート変数置換 | Javaソースファイル |
| BR-003 | バージョン継承 | flink.versionはArchetypeビルド時のバージョン | @project.version@プレースホルダー |
| BR-004 | 依存関係スコープ | flink-streaming-java, flink-clientsはprovided | Flink依存関係 |

### 計算ロジック

- バージョン置換: @project.version@ → Archetypeビルド時のFlinkバージョン
- Javaバージョン置換: @target.java.version@ → ターゲットJavaバージョン
- Log4jバージョン置換: @log4j.version@ → Log4jバージョン

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArchetypeNotFoundException | 指定バージョンのArchetypeが存在しない | 正しいバージョンを指定 |
| - | InvalidParameterException | 必須パラメータ不足 | 必須パラメータを入力 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

なし（プロジェクト生成は一度きりの操作）

## セキュリティ考慮事項

- 生成されるpom.xmlはApache Snapshotリポジトリを含む（開発版利用時）
- 本番利用時はリポジトリ設定を確認

## 備考

- maven-shade-pluginでfat JAR（uber-jar）を生成
- flink-streaming-javaとflink-clientsはprovided scope（クラスタ上で提供）
- IDE（Eclipse）用のlifecycle-mapping設定を含む
- コネクタ追加のコメント例をpom.xmlに含む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Archetypeメタデータを理解する

Archetypeの構造定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | archetype-metadata.xml | `flink-quickstart/flink-quickstart-java/src/main/resources/META-INF/maven/archetype-metadata.xml` | Archetype構造定義 |

**主要処理フロー**:
- **20-24行目**: archetype-descriptor要素 - Archetype名とXMLスキーマ定義
- **25-35行目**: fileSets要素 - テンプレートファイルセットの定義
- **26-31行目**: filtered="true" packaged="true" - Javaファイルはフィルタリング・パッケージ化

**読解のコツ**: `filtered="true"`はテンプレート変数（${package}等）の置換を有効化、`packaged="true"`は${package}をディレクトリ構造に変換。

#### Step 2: テンプレートジョブを理解する

生成されるサンプルジョブの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DataStreamJob.java | `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/src/main/java/DataStreamJob.java` | サンプルジョブテンプレート |

**主要処理フロー**:
- **19行目**: package ${package} - 動的パッケージ名
- **35-64行目**: DataStreamJobクラス - スケルトン実装
- **37-40行目**: main()メソッド - StreamExecutionEnvironment取得
- **63行目**: env.execute() - ジョブ実行

**読解のコツ**: ${package}はMaven Archetypeにより実行時に置換される。コメントでDataStream APIの使用例を示している。

#### Step 3: POM設定を理解する

生成されるpom.xmlの依存関係とビルド設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pom.xml（archetype-resources） | `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/pom.xml` | テンプレートPOM |

**主要処理フロー**:
- **23-26行目**: プロジェクト座標（${groupId}等のテンプレート変数）
- **30-38行目**: properties - Flinkバージョン、Javaバージョン等
- **32行目**: flink.version - @project.version@で置換
- **54-68行目**: Flink依存関係（provided scope）
- **119-161行目**: maven-shade-plugin設定 - fat JAR生成

### プログラム呼び出し階層図

```
mvn archetype:generate
    │
    ├─ Archetype取得
    │      └─ Maven Central / ローカルリポジトリ
    │             └─ flink-quickstart-java-{version}.jar
    │
    └─ プロジェクト生成
           │
           ├─ META-INF/maven/archetype-metadata.xml読込
           │      └─ fileSets定義に基づきファイル処理
           │
           └─ archetype-resources/処理
                  │
                  ├─ pom.xml
                  │      └─ ${groupId}, ${artifactId}, @project.version@置換
                  │
                  └─ src/main/java/${package}/
                         └─ DataStreamJob.java
                                └─ ${package}置換
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー入力
┌───────────────────────┐
│ groupId               │    Maven Archetype Plugin
│ artifactId            │───▶┌─────────────────────┐
│ version               │    │ パラメータ収集        │
│ package               │    └─────────────────────┘
└───────────────────────┘            │
                                     ▼
                              テンプレート処理
Archetype JAR                 ┌─────────────────────┐
┌───────────────────────┐    │ 変数置換              │
│ archetype-metadata.xml│───▶│ ${package} → com.xxx │
│ archetype-resources/  │    │ @project.version@    │
│   ├─ pom.xml         │    │ → 2.0.0              │
│   └─ src/main/java/  │    └─────────────────────┘
│       └─ ...         │            │
└───────────────────────┘            ▼
                              ファイル出力
                              ┌─────────────────────┐
                              │ my-flink-project/    │───▶ 完成プロジェクト
                              │   ├─ pom.xml        │
                              │   └─ src/main/java/ │
                              │       └─ com/xxx/   │
                              │           └─ ...    │
                              └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pom.xml | `flink-quickstart/pom.xml` | 設定 | 親POM（Archetype Plugin設定） |
| pom.xml | `flink-quickstart/flink-quickstart-java/pom.xml` | 設定 | Java Archetype POM |
| archetype-metadata.xml | `flink-quickstart/flink-quickstart-java/src/main/resources/META-INF/maven/archetype-metadata.xml` | 設定 | Archetypeメタデータ |
| pom.xml | `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/pom.xml` | テンプレート | 生成プロジェクトのPOM |
| DataStreamJob.java | `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/src/main/java/DataStreamJob.java` | テンプレート | サンプルジョブ |
