---
generated_at: 2026-02-02 18:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：10-Watermark

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **autoWatermarkInterval設定**：具体的な設定箇所の確認
  2. **Watermark伝播メカニズム**：ランタイム実装の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-core/src/main/java/org/apache/flink/api/common/eventtime/WatermarkStrategy.java`
- E-02: 画面機能マッピング.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WatermarkStrategyはWatermark生成を定義 | E-01 (31-33行目 JavaDoc) | ○ |
| C-02 | WatermarkGeneratorとTimestampAssigner生成 | E-01 (32-34行目 JavaDoc) | ○ |
| C-03 | @Publicアノテーション | E-01 (55行目) | ○ |
| C-04 | Serializableインターフェース継承 | E-01 (52-53行目 JavaDoc) | ○ |
| C-05 | createWatermarkGenerator()メソッド | E-01 (65行目) | ○ |
| C-06 | createTimestampAssigner()デフォルト実装 | E-01 (71-77行目) | ○ |
| C-07 | RecordTimestampAssignerがデフォルト | E-01 (76行目) | ○ |
| C-08 | withTimestampAssigner()メソッド | E-01 (109-113行目) | ○ |
| C-09 | withIdleness()メソッド | E-01 (147-153行目) | ○ |
| C-10 | idleTimeout > 0 検証 | E-01 (149-151行目) | ○ |
| C-11 | withWatermarkAlignment()メソッド | E-01 (168-175行目) | ○ |
| C-12 | forMonotonousTimestamps()静的メソッド | E-01 (219-221行目) | ○ |
| C-13 | forBoundedOutOfOrderness()静的メソッド | E-01 (234-236行目) | ○ |
| C-14 | noWatermarks()静的メソッド | E-01 (247-249行目) | ○ |
| C-15 | forGenerator()静的メソッド | E-01 (239-241行目) | ○ |
| C-16 | AscendingTimestampsWatermarks使用 | E-01 (220行目) | ○ |
| C-17 | BoundedOutOfOrdernessWatermarks使用 | E-01 (235行目) | ○ |
| C-18 | NoWatermarksGenerator使用 | E-01 (248行目) | ○ |
| C-19 | ウォーターマーク画面との関連 | E-02 (画面No.17) | ○ |
| C-20 | getAlignmentParameters()メソッド | E-01 (88-90行目) | ○ |
| C-21 | autoWatermarkInterval設定 | **根拠なし** | △ |
| C-22 | Watermark伝播メカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- autoWatermarkIntervalはExecutionConfigで設定
  - 候補：ExecutionConfig.setAutoWatermarkInterval()
- Watermark伝播はランタイムのStatusWatermarkValveで実装
  - 候補：StatusWatermarkValve / OneInputStreamOperator

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WatermarkStrategyの基本仕様は明確

## 6) レビュアーチェックリスト（最小）
- [ ] WatermarkStrategy.javaの各メソッドを確認
- [ ] forMonotonousTimestamps/forBoundedOutOfOrdernessの使い分けを確認
- [ ] withIdleness()のパラメータ検証を確認
- [ ] 画面機能マッピングでの関連画面を確認
