---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：12-ブロードキャストストリーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項の機密データ配信リスク**：一般的なベストプラクティスに基づく記述であり、Flink固有のドキュメント根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/BroadcastStream.java`
- E-02: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/stream/BroadcastStreamImpl.java`
- E-03: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/TwoInputBroadcastStreamProcessFunction.java`
- E-04: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/TwoInputBroadcastProcessOperator.java`
- E-05: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/KeyedTwoInputBroadcastProcessOperator.java`
- E-06: `flink-runtime/src/main/java/org/apache/flink/streaming/api/datastream/BroadcastStream.java`
- E-07: `flink-runtime/src/main/java/org/apache/flink/streaming/api/datastream/BroadcastConnectedStream.java`
- E-08: `flink-runtime/src/main/java/org/apache/flink/streaming/api/functions/co/BroadcastProcessFunction.java`
- E-09: `flink-runtime/src/main/java/org/apache/flink/streaming/api/functions/co/BaseBroadcastProcessFunction.java`
- E-10: `flink-runtime/src/main/java/org/apache/flink/streaming/runtime/partitioner/BroadcastPartitioner.java`
- E-11: `flink-runtime/src/main/java/org/apache/flink/streaming/api/datastream/DataStream.java`
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BroadcastStreamは全並列タスクに同一データを配信する機能 | E-01 (27行目コメント), E-06 (32-43行目コメント) | ○ |
| C-02 | DataStream.broadcast()でBroadcastStreamを作成 | E-11 (339-344行目) | ○ |
| C-03 | broadcast()はMapStateDescriptorを引数に取る | E-11 (340行目), E-06 (64行目) | ○ |
| C-04 | DataStream.connect(BroadcastStream)でBroadcastConnectedStreamを作成 | E-11 (259-265行目) | ○ |
| C-05 | BroadcastProcessFunctionは非キー付きストリーム用 | E-08 (26-31行目コメント) | ○ |
| C-06 | KeyedBroadcastProcessFunctionはキー付きストリーム用 | E-07 (113-121行目コメント) | ○ |
| C-07 | ブロードキャスト側はBroadcastStateに読み書き可能 | E-08 (78-97行目), E-09 (74-84行目) | ○ |
| C-08 | 非ブロードキャスト側はReadOnlyBroadcastStateのみアクセス可能 | E-08 (59-76行目), E-09 (86-103行目) | ○ |
| C-09 | BroadcastPartitioner.isBroadcast()はtrueを返す | E-10 (54-57行目) | ○ |
| C-10 | BroadcastPartitioner.selectChannel()はUnsupportedOperationExceptionをスロー | E-10 (38-42行目) | ○ |
| C-11 | DataStream V2 APIではBroadcastStreamインターフェースを使用 | E-01 (27-78行目) | ○ |
| C-12 | BroadcastStreamImpl.connectAndProcess()で接続と処理を実行 | E-02 (59-163行目) | ○ |
| C-13 | connectAndProcess()は3つのオーバーロードがある | E-01 (44-77行目), E-02 (59-163行目) | ○ |
| C-14 | TwoInputBroadcastStreamProcessFunctionがV2 APIの処理関数 | E-03 (33-118行目) | ○ |
| C-15 | processRecordFromNonBroadcastInput()でPartitionedContextを受け取る | E-03 (53-54行目) | ○ |
| C-16 | processRecordFromBroadcastInput()でNonPartitionedContextを受け取る | E-03 (64-65行目) | ○ |
| C-17 | TwoInputBroadcastProcessOperatorが非キー付きオペレータ | E-04 (55-247行目) | ○ |
| C-18 | KeyedTwoInputBroadcastProcessOperatorがキー付きオペレータ | E-05 (45-137行目) | ○ |
| C-19 | 非キー付き接続時はRedistributionMode.NONEのみ許可 | E-02 (96-98行目) | ○ |
| C-20 | KeySelector指定でシャッフル回避可能 | E-01 (59-77行目コメント), E-02 (126-163行目) | ○ |
| C-21 | ブロードキャスト入力は常に第2入力として扱う | E-02 (82-83行目コメント), E-04 (136行目) | ○ |
| C-22 | SubtaskStateMapper.UNSUPPORTEDで並列度変更時のステート再配分は未サポート | E-10 (45-52行目) | ○ |
| C-23 | Watermarkハンドリング機能がTwoInputBroadcastStreamProcessFunctionに含まれる | E-03 (94-117行目) | ○ |
| C-24 | 機密データの全タスク配信はセキュリティリスクがある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項における機密データ配信リスクは、Flink公式ドキュメントからの明確な根拠が見つからなかった
  - 候補：Flink公式ドキュメント / セキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる機能仕様が大半
- 1: 中リスク - セキュリティ考慮事項は一般的なベストプラクティスに基づく推奨事項

## 6) レビュアーチェックリスト（最小）
- [ ] BroadcastPartitioner.javaのisBroadcast()動作が設計書と一致しているか確認
- [ ] DataStream.broadcast()のAPIシグネチャが正確に記述されているか確認
- [ ] BroadcastProcessFunction/KeyedBroadcastProcessFunctionの使い分けが正しいか確認
- [ ] DataStream V2 APIのconnectAndProcess()の3つのオーバーロードが網羅されているか確認
- [ ] ステートアクセス権限（読み書き/読み取りのみ）の記述が実装と一致しているか確認
- [ ] セキュリティ考慮事項について追加の公式ガイダンスがないか確認
