---
generated_at: 2026-02-02 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-Table API Scala

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table-api-scala/src/main/scala/org/apache/flink/table/api/package.scala`
- E-02: `flink-table-api-scala/src/main/scala/org/apache/flink/table/api/ImplicitExpressionConversions.scala`
- E-03: `flink-table-api-scala/src/main/scala/org/apache/flink/table/api/ImplicitExpressionOperations.scala`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | package object apiが全暗黙変換を提供 | E-01 (48行目) | ○ |
| C-02 | ImplicitExpressionConversionsとImplicitTypeConversionsを継承 | E-01 (48行目) | ○ |
| C-03 | FLIP-265により非推奨宣言されている | E-01 (41-47行目コメント), E-02 (43-48行目), E-03 (32-38行目) | ○ |
| C-04 | @deprecated(since = "1.18.0")アノテーション付き | E-03 (39行目) | ○ |
| C-05 | UnresolvedFieldExpressionでSymbolをExpressionに変換 | E-02 (92-94行目) | ○ |
| C-06 | WithOperationsでExpressionに演算子を追加 | E-02 (88-90行目) | ○ |
| C-07 | ===演算子はisEqualに対応 | E-03 (79行目) | ○ |
| C-08 | !==演算子はisNotEqualに対応 | E-03 (82行目) | ○ |
| C-09 | &&演算子はandに対応 | E-03 (61行目) | ○ |
| C-10 | \|\|演算子はorに対応 | E-03 (64行目) | ○ |
| C-11 | +演算子はplusに対応 | E-03 (94行目) | ○ |
| C-12 | -演算子はminusに対応 | E-03 (97行目) | ○ |
| C-13 | *演算子はtimesに対応 | E-03 (103行目) | ○ |
| C-14 | /演算子はdividedByに対応 | E-03 (100行目) | ○ |
| C-15 | %演算子はmodに対応 | E-03 (109行目) | ○ |
| C-16 | ?演算子で三項条件式を表現 | E-03 (130-131行目) | ○ |
| C-17 | to演算子で範囲指定 | E-03 (117行目) | ○ |
| C-18 | UNBOUNDED_ROW暗黙値が存在 | E-02 (62行目) | ○ |
| C-19 | UNBOUNDED_RANGE暗黙値が存在 | E-02 (69行目) | ○ |
| C-20 | CURRENT_ROW暗黙値が存在 | E-02 (75行目) | ○ |
| C-21 | CURRENT_RANGE暗黙値が存在 | E-02 (82行目) | ○ |
| C-22 | 各Scala型（Long, Int, String等）からの暗黙変換が提供 | E-02 (101-150行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる機能仕様が大半
- 非推奨APIであるため、新規開発での使用は非推奨

## 6) レビュアーチェックリスト（最小）
- [ ] package.scalaが正しくImplicitExpressionConversionsとImplicitTypeConversionsを継承しているか確認
- [ ] 演算子マッピング（===, !==, +, -等）が正確に記述されているか確認
- [ ] FLIP-265による非推奨状態が正しく伝えられているか確認
- [ ] Symbol変換（'column形式）の動作が正確か確認
- [ ] 暗黙値（UNBOUNDED_ROW等）の説明が正確か確認
