---
generated_at: 2026-02-02 11:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-組み込み関数

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `flink-table-common/src/main/java/org/apache/flink/table/functions/BuiltInFunctionDefinitions.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuiltInFunctionDefinitionsが組み込み関数の辞書 | E-01 (119-121行目コメント) | ○ |
| C-02 | FunctionKindにSCALAR, AGGREGATE, TABLE等がある | E-01 (73-77行目import) | ○ |
| C-03 | TYPE_OF関数が定義されている | E-01 (127-143行目) | ○ |
| C-04 | IF_NULL関数が定義されている | E-01 (145-155行目) | ○ |
| C-05 | MAP_KEYS関数が定義されている | E-01 (157-167行目) | ○ |
| C-06 | MAP_VALUES関数が定義されている | E-01 (169-180行目) | ○ |
| C-07 | MAP_ENTRIES関数が定義されている | E-01 (192-203行目) | ○ |
| C-08 | MAP_FROM_ARRAYS関数が定義されている | E-01 (205-219行目) | ○ |
| C-09 | MAP_UNION関数が定義されている | E-01 (182-190行目) | ○ |
| C-10 | COALESCE関数が定義されている | E-01 (231-239行目) | ○ |
| C-11 | ARRAY_APPEND関数が定義されている | E-01 (241-253行目) | ○ |
| C-12 | ARRAY_CONTAINS関数が定義されている | E-01 (255-269行目) | ○ |
| C-13 | ARRAY_SORT関数が定義されている | E-01 (271-288行目) | ○ |
| C-14 | ARRAY_DISTINCT関数が定義されている | E-01 (290-301行目) | ○ |
| C-15 | ARRAY_POSITION関数が定義されている | E-01 (303-315行目) | ○ |
| C-16 | ARRAY_PREPEND関数が定義されている | E-01 (317-329行目) | ○ |
| C-17 | ARRAY_REMOVE関数が定義されている | E-01 (331-343行目) | ○ |
| C-18 | SOURCE_WATERMARK関数が定義されている | E-01 (221-229行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる機能仕様が大半

## 6) レビュアーチェックリスト（最小）
- [ ] BuiltInFunctionDefinitions.javaの関数定義が正確に記述されているか確認
- [ ] 各関数のinputTypeStrategy/outputTypeStrategyが正確か確認
- [ ] runtimeClassのパス指定が正確か確認
- [ ] FunctionKindの種別が網羅されているか確認
