---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-UDF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `flink-table-common/src/main/java/org/apache/flink/table/functions/UserDefinedFunction.java`
- E-02: `flink-table-common/src/main/java/org/apache/flink/table/functions/ScalarFunction.java`
- E-03: `flink-table-common/src/main/java/org/apache/flink/table/functions/TableFunction.java`
- E-04: `flink-table-common/src/main/java/org/apache/flink/table/functions/AggregateFunction.java`
- E-05: `flink-table-common/src/main/java/org/apache/flink/table/functions/TableAggregateFunction.java`
- E-06: `flink-table-common/src/main/java/org/apache/flink/table/functions/AsyncScalarFunction.java`
- E-07: `flink-table-common/src/main/java/org/apache/flink/table/functions/FunctionContext.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserDefinedFunctionがUDFの基底クラス | E-01 (34行目コメント) | ○ |
| C-02 | ScalarFunction, TableFunction, AggregateFunction等が主要なUDF種別 | E-01 (52-57行目) | ○ |
| C-03 | open(FunctionContext)が初期化メソッド | E-01 (73-79行目) | ○ |
| C-04 | close()が終了処理メソッド | E-01 (81-87行目) | ○ |
| C-05 | getTypeInference()で型推論を取得 | E-01 (114-115行目) | ○ |
| C-06 | ScalarFunctionはeval()メソッドで評価 | E-02 (36-38行目コメント) | ○ |
| C-07 | ScalarFunctionのFunctionKindはSCALAR | E-02 (137-140行目) | ○ |
| C-08 | ScalarFunctionはTypeInferenceExtractor.forScalarFunctionを使用 | E-02 (142-145行目) | ○ |
| C-09 | TableFunctionはcollect()で行を出力 | E-03 (189-198行目) | ○ |
| C-10 | TableFunctionのFunctionKindはTABLE | E-03 (200-203行目) | ○ |
| C-11 | TableFunctionにfinish()メソッドがある | E-03 (211-225行目) | ○ |
| C-12 | TableFunctionはTypeInferenceExtractor.forTableFunctionを使用 | E-03 (205-209行目) | ○ |
| C-13 | AggregateFunctionはcreateAccumulator, accumulate, getValueが必須 | E-04 (56-62行目コメント) | ○ |
| C-14 | AggregateFunctionにretract, mergeがオプションメソッド | E-04 (64-69行目コメント) | ○ |
| C-15 | AggregateFunctionのFunctionKindはAGGREGATE | E-04 (205-208行目) | ○ |
| C-16 | mergeはセッションウィンドウで必要 | E-04 (101-106行目コメント) | ○ |
| C-17 | ListView/MapViewで大量データを扱える | E-04 (122-123行目コメント) | ○ |
| C-18 | TableAggregateFunctionはemitValueまたはemitUpdateWithRetractを使用 | E-05 (44-45行目コメント) | ○ |
| C-19 | TableAggregateFunctionのFunctionKindはTABLE_AGGREGATE | E-05 (174-177行目) | ○ |
| C-20 | RetractableCollectorでretract()が可能 | E-05 (159-172行目) | ○ |
| C-21 | AsyncScalarFunctionは最初の引数がCompletableFuture | E-06 (33-35行目コメント) | ○ |
| C-22 | AsyncScalarFunctionのFunctionKindはASYNC_SCALAR | E-06 (94-97行目) | ○ |
| C-23 | FunctionContextでgetTaskInfo()が使用可能 | E-07 (85-96行目) | ○ |
| C-24 | FunctionContextでgetMetricGroup()が使用可能 | E-07 (98-111行目) | ○ |
| C-25 | FunctionContextでgetJobParameter()が使用可能 | E-07 (128-146行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードのJavadocから明確に読み取れる機能仕様が大半

## 6) レビュアーチェックリスト（最小）
- [ ] UserDefinedFunction.javaのライフサイクルメソッド（open/close）が正確に記述されているか確認
- [ ] 各UDF種別（Scalar, Table, Aggregate等）のFunctionKindが正確か確認
- [ ] AggregateFunctionの必須/オプションメソッドが正しく記述されているか確認
- [ ] AsyncScalarFunctionのCompletableFuture使用法が正確か確認
- [ ] FunctionContextの各メソッドが正確に記述されているか確認
