---
generated_at: 2026-02-02 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-SQLパーサー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `flink-table-planner/src/main/java/org/apache/flink/table/planner/parse/CalciteParser.java`
- E-02: `flink-sql-parser/src/main/java/org/apache/flink/sql/parser/validate/FlinkSqlConformance.java`
- E-03: `flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/table/SqlCreateTable.java`
- E-04: `flink-sql-parser/src/main/java/org/apache/flink/sql/parser/dml/RichSqlInsert.java`
- E-05: `flink-sql-parser/src/main/java/org/apache/flink/sql/parser/dql/SqlShowTables.java`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CalciteParserがSqlParserのラッパー | E-01 (35-38行目コメント) | ○ |
| C-02 | parse()でSqlParserを作成しparseStmt()を呼び出す | E-01 (53-63行目) | ○ |
| C-03 | EOF到達時にSqlParserEOFExceptionをスロー | E-01 (58-59行目) | ○ |
| C-04 | parseSqlList()で複数SQL文を解析 | E-01 (73-83行目) | ○ |
| C-05 | parseExpression()でSQL式を解析 | E-01 (92-99行目) | ○ |
| C-06 | parseIdentifier()でFlinkSqlParserImpl.TableApiIdentifier()を呼び出す | E-01 (108-121行目) | ○ |
| C-07 | FlinkSqlConformanceがSqlConformanceを実装 | E-02 (26行目) | ○ |
| C-08 | isSortByOrdinalがtrueを返す | E-02 (55-58行目) | ○ |
| C-09 | isSortByAliasがtrueを返す | E-02 (60-63行目) | ○ |
| C-10 | isPercentRemainderAllowedがtrueを返す | E-02 (90-93行目) | ○ |
| C-11 | allowNiladicParenthesesがtrueを返す | E-02 (120-123行目) | ○ |
| C-12 | SqlCreateTableがSqlCreateObjectを継承 | E-03 (54行目) | ○ |
| C-13 | SqlCreateTableがcolumnList, tableConstraints, partitionKeyList, watermarkを持つ | E-03 (59-67行目) | ○ |
| C-14 | SqlCreateTableのvalidate()で制約検証を実行 | E-03 (159-162行目) | ○ |
| C-15 | RichSqlInsertがSqlInsertを継承 | E-04 (40行目) | ○ |
| C-16 | RichSqlInsertがstaticPartitions, extendedKeywords, targetTableID, tableHintsを持つ | E-04 (41-47行目) | ○ |
| C-17 | RichSqlInsertにconflictActionがありOptionalで取得可能 | E-04 (51-52, 142-147行目) | ○ |
| C-18 | isOverwrite()でOVERWRITEモードを判定 | E-04 (197-200行目) | ○ |
| C-19 | SqlShowTablesがSqlShowCallを継承 | E-05 (36行目) | ○ |
| C-20 | SqlTableKindにMATERIALIZED_TABLE, TABLE, VIEWがある | E-05 (76-79行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる機能仕様が大半

## 6) レビュアーチェックリスト（最小）
- [ ] CalciteParser.javaのparse()メソッドの例外処理が正確に記述されているか確認
- [ ] FlinkSqlConformance.javaの各設定値が正確か確認
- [ ] SqlCreateTable.javaのフィールド構成が正確か確認
- [ ] RichSqlInsert.javaの拡張機能が網羅されているか確認
- [ ] SqlShowTables.javaのSqlTableKind列挙が正確か確認
