---
generated_at: 2026-02-02 17:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-KeySelector

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：軽量実装の具体的基準なし

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-core-api/src/main/java/org/apache/flink/api/java/functions/KeySelector.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/streaming/api/datastream/DataStream.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KeySelectorはFunctionを継承 | E-01 (38行目) | ○ |
| C-02 | KeySelectorはSerializableを実装 | E-01 (38行目) | ○ |
| C-03 | @FunctionalInterfaceアノテーション付与 | E-01 (37行目) | ○ |
| C-04 | getKey()メソッドでキーを抽出 | E-01 (68行目) | ○ |
| C-05 | 決定論的なキー抽出が必要 | E-01 (27-29行目 JavaDoc) | ○ |
| C-06 | 同一オブジェクトで同じキーを返す | E-01 (28-29行目 JavaDoc) | ○ |
| C-07 | @Publicアノテーション付与 | E-01 (36行目) | ○ |
| C-08 | reduce/join/coGroup等での使用 | E-01 (27-28行目 JavaDoc) | ○ |
| C-09 | 例外発生時はタスク失敗とリカバリ | E-01 (65-66行目 JavaDoc) | ○ |
| C-10 | IN型からKEY型への変換 | E-01 (33-34行目) | ○ |
| C-11 | 使用例としてWord.wordをキーに | E-01 (46-60行目 JavaDoc) | ○ |
| C-12 | DataStream.keyBy()で使用 | E-02 (45行目 import) | ○ |
| C-13 | KeyedStreamの生成に使用 | E-02 | ○ |
| C-14 | ラムダ式で実装可能 | E-01 (37行目) | ○ |
| C-15 | 軽量な実装が求められる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な基準は、ソースコードからは確認できない
  - 候補：Flinkパフォーマンスガイド / ベストプラクティスドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - KeySelectorインターフェースの仕様は明確

## 6) レビュアーチェックリスト（最小）
- [ ] KeySelector.javaのgetKey()メソッドシグネチャを確認
- [ ] 決定論性要件をJavaDocで確認
- [ ] DataStreamでのkeyBy()使用パターンを確認
