---
generated_at: 2026-02-02 17:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：23-ジョブ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠要確認
  2. **リトライ仕様**：詳細設定の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMaster.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterGateway.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/SchedulerNG.java`
- E-04: `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/slotpool/SlotPoolService.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobMasterは単一ジョブの実行を担当 | E-01 (143-153行目コメント) | ○ |
| C-02 | FencedRpcEndpointを継承 | E-01 (154-155行目) | ○ |
| C-03 | ExecutionPlanを受け取りタスクに分解 | E-01 (258行目) | ○ |
| C-04 | HeartbeatServicesでハートビート管理 | E-01 (173-174行目, 404行目) | ○ |
| C-05 | SlotPoolServiceでスロット管理 | E-01 (186行目, 361-367行目) | ○ |
| C-06 | SchedulerNGでスケジューリング | E-01 (204行目, 397-403行目) | ○ |
| C-07 | ResourceManagerLeaderRetrieverでRM検出 | E-01 (194行目, 350-351行目) | ○ |
| C-08 | onStart()でstartJobExecution呼び出し | E-01 (472-482行目) | ○ |
| C-09 | onStop()でジョブ停止処理 | E-01 (486-499行目) | ○ |
| C-10 | updateTaskExecutionState()で状態更新 | E-01, E-03 | ○ |
| C-11 | registerTaskManager()でTM登録 | E-01 | ○ |
| C-12 | acknowledgeCheckpoint()でACK受信 | E-01, E-03 | ○ |
| C-13 | BlocklistHandlerでブロックリスト管理 | E-01 (233行目, 354-359行目) | ○ |
| C-14 | PartitionTrackerでパーティション追跡 | E-01 (214行目, 369-376行目) | ○ |
| C-15 | ShuffleMasterでシャッフル管理 | E-01 (200行目, 378行目) | ○ |
| C-16 | SchedulerNGにAdaptiveSchedulerあり | E-03 (53行目インポート) | ○ |
| C-17 | SchedulerNGはstartScheduling()で開始 | E-03 (76行目) | ○ |
| C-18 | JobMasterIdによるフェンシング | E-01 (154行目) | ○ |
| C-19 | パフォーマンス要件（ジョブ起動数秒以内） | **根拠なし** | △ |
| C-20 | ハートビート間隔デフォルト10秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件について：
  - 具体的な数値はソースコードに明記なし
  - 候補：設定オプションドキュメント / パフォーマンステスト

- ハートビート間隔について：
  - HeartbeatManagerOptionsで設定可能だが、デフォルト値の確認が必要
  - 候補：設定ファイル / HeartbeatManagerOptions.java

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - アーキテクチャ概要、コンポーネント連携（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件、デフォルト設定値（推定値を含む）
- 0: 低リスク - コードリーディングガイド（実際のソースコードに基づく）

## 6) レビュアーチェックリスト（最小）

- [ ] パフォーマンス要件が実際の運用要件と合致しているか確認
- [ ] ハートビート設定値が運用環境に適しているか確認
- [ ] 障害復旧のリトライ設定が要件を満たすか確認
- [ ] Adaptive Scheduler使用時の動作が期待通りか確認
