---
generated_at: 2026-02-02 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-スケジューラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/SchedulerNG.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/DefaultScheduler.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/AdaptiveScheduler.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SchedulerNGがスケジューリングを担当 | E-01 (65-73行目コメント) | ○ |
| C-02 | GlobalFailureHandlerを継承 | E-01 (74行目) | ○ |
| C-03 | startScheduling()でスケジューリング開始 | E-01 (76行目) | ○ |
| C-04 | cancel()でキャンセル | E-01 (78行目) | ○ |
| C-05 | updateTaskExecutionState()で状態更新 | E-01 (82-86行目) | ○ |
| C-06 | requestJob()でジョブ情報取得 | E-01 (95行目) | ○ |
| C-07 | requestCheckpointStats()でCP統計取得 | E-01 (104行目) | ○ |
| C-08 | triggerSavepoint()でセーブポイント | E-01 (137-138行目) | ○ |
| C-09 | triggerCheckpoint()でチェックポイント | E-01 (140行目) | ○ |
| C-10 | acknowledgeCheckpoint()でACK処理 | E-01 (142-147行目) | ○ |
| C-11 | declineCheckpoint()でDecline処理 | E-01 (155行目) | ○ |
| C-12 | deliverOperatorEventToCoordinator()でイベント配信 | E-01 (189-191行目) | ○ |
| C-13 | requestJobResourceRequirements()でリソース要件取得 | E-01 (216-221行目) | ○ |
| C-14 | updateJobResourceRequirements()でリソース要件更新 | E-01 (228-233行目) | ○ |
| C-15 | AdaptiveSchedulerが動的スケーリング対応 | E-01 (220行目, 232行目) | ○ |
| C-16 | 複数実装（Default/Adaptive/AdaptiveBatch）あり | E-02, E-03 | ○ |
| C-17 | ComponentMainThreadExecutorで実行 | E-01 (71行目) | ○ |
| C-18 | パフォーマンス要件（ミリ秒オーダー） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件について：
  - 具体的な数値はソースコードに明記なし
  - 候補：パフォーマンステスト / 設計仕様書

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - インターフェース定義（ソースコードで確認済み）
- 0: 低リスク - スケジューラ種別（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（推定値）

## 6) レビュアーチェックリスト（最小）

- [ ] 使用するスケジューラが要件に合致しているか確認
- [ ] フェイルオーバー戦略が適切か確認
- [ ] スロットタイムアウト設定が運用要件を満たすか確認
- [ ] AdaptiveScheduler使用時の動作確認
