---
generated_at: 2026-02-02 17:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：30-ハートビート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のデフォルト値**：具体的な数値の根拠要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatManager.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatTarget.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatListener.java`
- E-04: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatServices.java`
- E-05: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatServicesImpl.java`
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatManagerImpl.java`
- E-07: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatManagerSenderImpl.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HeartbeatManagerがHeartbeatTargetを継承 | E-01 (30行目) | ○ |
| C-02 | monitorTarget()で監視対象登録 | E-01 (33-40行目) | ○ |
| C-03 | unmonitorTarget()で監視停止 | E-01 (42-47行目) | ○ |
| C-04 | stop()で全監視停止 | E-01 (49-50行目) | ○ |
| C-05 | getLastHeartbeatFrom()で最終ハートビート取得 | E-01 (52-59行目) | ○ |
| C-06 | receiveHeartbeat()でハートビート受信 | E-02 (35-45行目) | ○ |
| C-07 | requestHeartbeat()でハートビートリクエスト | E-02 (47-56行目) | ○ |
| C-08 | notifyHeartbeatTimeout()でタイムアウト通知 | E-03 (38-44行目) | ○ |
| C-09 | notifyTargetUnreachable()で到達不能通知 | E-03 (46-52行目) | ○ |
| C-10 | reportPayload()でペイロード報告 | E-03 (54-61行目) | ○ |
| C-11 | retrievePayload()でペイロード取得 | E-03 (63-69行目) | ○ |
| C-12 | createHeartbeatManager()で受動型作成 | E-04 (34-50行目) | ○ |
| C-13 | createHeartbeatManagerSender()で能動型作成 | E-04 (52-69行目) | ○ |
| C-14 | fromConfiguration()で設定値から自動生成 | E-04 (71-89行目) | ○ |
| C-15 | HeartbeatManagerImplがスレッドセーフ | E-06 (48行目@ThreadSafe) | ○ |
| C-16 | ConcurrentHashMapで並行アクセス対応 | E-06 (68行目) | ○ |
| C-17 | HeartbeatManagerSenderImplがRunnable実装 | E-07 (35行目) | ○ |
| C-18 | 定期的にハートビートリクエスト送信 | E-07 (77行目, 80-90行目) | ○ |
| C-19 | heartbeatTimeoutIntervalMsでタイムアウト管理 | E-06 (52行目) | ○ |
| C-20 | パフォーマンス要件のデフォルト値（10秒/50秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件のデフォルト値について：
  - HeartbeatServices.javaはHeartbeatManagerOptionsから値を取得（77-85行目）
  - 具体的なデフォルト値はHeartbeatManagerOptionsの確認が必要
  - 候補：`flink-core/src/main/java/org/apache/flink/configuration/HeartbeatManagerOptions.java`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - インターフェース定義（ソースコードで確認済み）
- 0: 低リスク - 実装パターン（ソースコードで確認済み）
- 0: 低リスク - スレッドセーフ設計（アノテーションで確認済み）
- 1: 中リスク - デフォルト設定値（設定ファイル確認推奨）

## 6) レビュアーチェックリスト（最小）

- [ ] heartbeatInterval設定が運用要件を満たすか確認
- [ ] heartbeatTimeout設定が障害検出時間要件を満たすか確認
- [ ] failedRpcRequestsUntilUnreachable設定が適切か確認
- [ ] ネットワーク遅延を考慮したタイムアウト設定か確認
