---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-高可用性

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **フェイルオーバー時間**：具体的な数値の根拠不足
  2. **Kubernetes HA実装詳細**：flink-kubernetesモジュールは調査対象外

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/HighAvailabilityServices.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/AbstractHaServices.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/HighAvailabilityServicesUtils.java`
- E-04: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/zookeeper/ZooKeeperLeaderElectionHaServices.java`
- E-05: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/JobResultStore.java`
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/highavailability/FileSystemJobResultStore.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HAモードにはNONE/ZOOKEEPER/KUBERNETES/FACTORY_CLASSがある | E-03 (59-84行目) | ○ |
| C-02 | HighAvailabilityServicesはリーダー選出/検出サービスを提供 | E-01 (76-131行目) | ○ |
| C-03 | AbstractHaServicesが共通処理を提供 | E-02 (55-310行目) | ○ |
| C-04 | ZooKeeperLeaderElectionHaServicesがZK実装 | E-04 (62-202行目) | ○ |
| C-05 | JobResultStoreはdirty/cleanの2状態を管理 | E-05 (30-39行目) | ○ |
| C-06 | FileSystemJobResultStoreはJSON形式で永続化 | E-06 (63-64行目) | ○ |
| C-07 | ZKノード構造は/flink/cluster_id/leader/下に作成 | E-04 (44-60行目コメント) | ○ |
| C-08 | Curatorフレームワークを使用 | E-04 (64行目) | ○ |
| C-09 | リーダー選出にDefaultLeaderElectionServiceを使用 | E-02 (84行目) | ○ |
| C-10 | ジョブ結果ストアはdirty結果作成とcleanマークの2段階 | E-05 (55-67行目) | ○ |
| C-11 | close()で関連リソースを解放 | E-02 (154-181行目) | ○ |
| C-12 | cleanupAllData()で全データを削除 | E-02 (183-210行目) | ○ |
| C-13 | globalCleanupAsync()でジョブ単位のクリーンアップ | E-02 (212-226行目) | ○ |
| C-14 | CheckpointRecoveryFactoryを提供 | E-01 (149-153行目) | ○ |
| C-15 | ExecutionPlanStoreを提供 | E-01 (155-161行目) | ○ |
| C-16 | BlobStoreを作成 | E-01 (173-177行目) | ○ |
| C-17 | 設定からHAモードを判定 | E-03 (62行目) | ○ |
| C-18 | ZooKeeper接続にCuratorを使用 | E-03 (91-92行目) | ○ |
| C-19 | FileSystemJobResultStoreは設定から生成可能 | E-06 (95-113行目) | ○ |
| C-20 | HA_STORAGE_PATHとHA_CLUSTER_IDで保存先を決定 | E-06 (98-107行目) | ○ |
| C-21 | ダーティファイルは_DIRTY.json拡張子 | E-06 (64行目) | ○ |
| C-22 | クリーンファイルは.json拡張子 | E-06 (63行目) | ○ |
| C-23 | KubernetesHaServicesFactoryでK8s HA生成 | E-03 (72-75行目) | ○ |
| C-24 | フェイルオーバー時間は数秒〜数十秒 | **根拠なし** | △ |
| C-25 | ZooKeeperセッションタイムアウトはデフォルト60秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **フェイルオーバー時間の具体値**：ソースコードから直接確認できず、実測値または公式ドキュメント参照が必要
  - 候補：Flink公式ドキュメント / パフォーマンステスト結果 / HighAvailabilityOptions.java
- **ZooKeeperタイムアウト設定**：HighAvailabilityOptions.javaの確認が必要
  - 候補：flink-core/HighAvailabilityOptions.java / curator設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装詳細は十分な根拠あり
- 1: 中リスク - Kubernetes HA実装はflink-kubernetesモジュール参照が必要
- 0: 低リスク - ZooKeeper連携の実装は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フェイルオーバー時間の記載は公式ドキュメントと整合しているか確認
- [ ] ZooKeeperセッションタイムアウトのデフォルト値を確認
- [ ] Kubernetes HA実装の詳細が必要な場合はflink-kubernetesモジュールを参照
- [ ] セキュリティ設定（SASL/Kerberos）の詳細が必要な場合は追加調査
