---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：41-コネクタベース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：設定可能だが具体的なデフォルト値の根拠不足
  2. **トランザクション仕様の詳細**：Exactly-onceの実現方法は個別コネクタ依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `SourceReaderBase.java` 127-171行目 - コンストラクタ
- E-02: `SourceReaderBase.java` 177-191行目 - pollNext()メソッド
- E-03: `SourceReaderBase.java` 267-280行目 - getNextFetch()メソッド
- E-04: `SourceReaderBase.java` 348-352行目 - snapshotState()メソッド
- E-05: `SourceReaderBase.java` 365-374行目 - addSplits()メソッド
- E-06: `SplitReader.java` 36-101行目 - インターフェース定義
- E-07: `SplitFetcherManager.java` 113-160行目 - コンストラクタ
- E-08: `SplitFetcherManager.java` 201-230行目 - createSplitFetcher()
- E-09: `SplitFetcherManager.java` 266-301行目 - close()メソッド
- E-10: `AsyncSinkWriter.java` 241-297行目 - コンストラクタと検証ロジック
- E-11: `AsyncSinkWriter.java` 311-320行目 - write()メソッド
- E-12: `AsyncSinkWriter.java` 353-376行目 - flush()メソッド
- E-13: `AsyncSinkWriter.java` 406-423行目 - addEntryToBuffer()でのサイズ検証
- E-14: `AsyncSinkWriter.java` 480-551行目 - AsyncSinkWriterResultHandler
- E-15: `AsyncSinkBaseBuilder.java` 33-141行目 - ビルダー全体
- E-16: `ElementConverter.java` 35-41行目 - インターフェース定義
- E-17: `HybridSource.java` 92-269行目 - クラス全体
- E-18: `RecordEmitter.java` 33-51行目 - インターフェース定義
- E-19: `機能一覧.csv` 41行目 - コネクタベース機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceReaderBaseはスプリットベースの並列読み取りを管理する | E-01, E-02, E-05 | ○ |
| C-02 | SplitReaderはスプリット単位でのデータ読み取りインターフェース | E-06 | ○ |
| C-03 | SplitFetcherManagerはフェッチャーのライフサイクル管理を行う | E-07, E-08, E-09 | ○ |
| C-04 | AsyncSinkWriterは非同期バッチ書き込みを行う | E-10, E-11, E-12 | ○ |
| C-05 | HybridSourceは複数ソースを順次切り替える | E-17 | ○ |
| C-06 | RecordEmitterはレコードのダウンストリームへの発行を行う | E-18 | ○ |
| C-07 | maxBatchSizeは0より大きい必要がある | E-10 (253行目) | ○ |
| C-08 | maxBufferedRequestsはmaxBatchSizeより大きい必要がある | E-10 (258-261行目) | ○ |
| C-09 | maxBatchSizeInBytesはmaxRecordSizeInBytes以上必要 | E-10 (263-265行目) | ○ |
| C-10 | maxRecordSizeInBytes超過時はIllegalArgumentException | E-13 (415-420行目) | ○ |
| C-11 | ResultHandlerでリトライ、完了、例外処理が可能 | E-14 | ○ |
| C-12 | タイムアウト時にfailOnTimeoutでリトライか例外を選択 | E-14 (531-547行目) | ○ |
| C-13 | pollNextはInputStatusを返す | E-02 | ○ |
| C-14 | snapshotStateで全スプリットの状態を返す | E-04 | ○ |
| C-15 | addSplitsでスプリット状態を初期化しフェッチャーに追加 | E-05 | ○ |
| C-16 | SplitReader.fetch()はブロッキング可能でwakeUp()で中断可能 | E-06 (38-52行目, 70-71行目) | ○ |
| C-17 | SplitReader.pauseOrResumeSplits()のデフォルト実装はUnsupportedOperationException | E-06 (90-100行目) | ○ |
| C-18 | ElementConverterはInputTをRequestEntryTに変換 | E-16 | ○ |
| C-19 | HybridSourceの最終ソース以外はBOUNDED必須 | E-17 (253-256行目) | ○ |
| C-20 | SourceSwitchContextで前ソースのenumeratorを参照可能 | E-17 (163-175行目) | ○ |
| C-21 | writeでバッファがmaxBufferedRequests以上ならflushまでブロック | E-11 (313-315行目) | ○ |
| C-22 | 登録タイマーでmaxTimeInBufferMS経過後に自動flush | E-10 (299-309行目) | ○ |
| C-23 | レート制限が有効な場合RateLimiterでパーミッション取得 | E-02 (186-190行目), E-01 (163-166行目) | ○ |
| C-24 | flush(boolean)で全in-flightリクエスト完了を待機 | E-12 (433-441行目) | ○ |
| C-25 | BatchCreatorでバッチを作成する | E-12 (360-362行目) | ○ |
| C-26 | AsyncSinkWriterはStatefulSinkWriterを実装 | E-10 (58-59行目) | ○ |
| C-27 | パフォーマンス要件のデフォルト値 | **根拠なし** | △ |
| C-28 | Exactly-once保証の詳細な実現方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的なデフォルト値について
  - 候補：SourceReaderOptions.java / 設定ドキュメント / テストコード
- Exactly-once保証の具体的な実現方法について
  - 候補：チェックポイント関連ドキュメント / 個別コネクタ実装例

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 主要な機能説明はすべてソースコードで確認済み
- 1（中リスク）: パフォーマンス要件の具体値は設定依存のため要確認
- 0（低リスク）: API構造とデータフローは正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] SourceReaderBaseの抽象メソッド（onSplitFinished, initializedState, toSplitType）の説明が十分か確認
- [ ] AsyncSinkWriterのsubmitRequestEntries()実装例が適切か確認
- [ ] パフォーマンス要件のデフォルト値を補完すべきか検討
- [ ] 個別コネクタ（Kafka, Kinesis等）での利用例との整合性確認
