---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-JSON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス比較の定量的データ**：JsonParser vs ObjectMapper の性能差の具体値

## 2) 参照した情報（Evidence一覧）

- E-01: `JsonFormatOptions.java` 29-34行目 - FAIL_ON_MISSING_FIELD 定義
- E-02: `JsonFormatOptions.java` 36-42行目 - IGNORE_PARSE_ERRORS 定義
- E-03: `JsonFormatOptions.java` 44-51行目 - MAP_NULL_KEY_MODE 定義
- E-04: `JsonFormatOptions.java` 53-58行目 - MAP_NULL_KEY_LITERAL 定義
- E-05: `JsonFormatOptions.java` 60-67行目 - TIMESTAMP_FORMAT 定義
- E-06: `JsonFormatOptions.java` 69-74行目 - ENCODE_DECIMAL_AS_PLAIN_NUMBER 定義
- E-07: `JsonFormatOptions.java` 76-81行目 - ENCODE_IGNORE_NULL_FIELDS 定義
- E-08: `JsonFormatOptions.java` 83-88行目 - DECODE_JSON_PARSER_ENABLED 定義
- E-09: `JsonFormatOptions.java` 95-99行目 - MapNullKeyMode enum 定義
- E-10: `JsonFormatFactory.java` 63行目 - IDENTIFIER = "json"
- E-11: `JsonFormatFactory.java` 66-116行目 - createDecodingFormat メソッド
- E-12: `JsonFormatFactory.java` 139-172行目 - createEncodingFormat メソッド
- E-13: `JsonRowDataSerializationSchema.java` 76-96行目 - コンストラクタ
- E-14: `JsonRowDataSerializationSchema.java` 99-107行目 - open メソッド
- E-15: `JsonRowDataSerializationSchema.java` 110-121行目 - serialize メソッド
- E-16: `JsonRowDataDeserializationSchema.java` 55-65行目 - コンストラクタ
- E-17: `JsonRowDataDeserializationSchema.java` 68-101行目 - deserialize メソッド
- E-18: `JsonRowDataDeserializationSchema.java` 74-88行目 - 配列処理ロジック
- E-19: `機能一覧.csv` 42行目 - JSON機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fail-on-missing-field のデフォルト値は false | E-01 | ○ |
| C-02 | ignore-parse-errors のデフォルト値は false | E-02 | ○ |
| C-03 | map-null-key.mode のデフォルト値は FAIL | E-03 | ○ |
| C-04 | map-null-key.literal のデフォルト値は "null" | E-04 | ○ |
| C-05 | timestamp-format.standard のデフォルト値は SQL | E-05 | ○ |
| C-06 | encode.decimal-as-plain-number のデフォルト値は false | E-06 | ○ |
| C-07 | encode.ignore-null-fields のデフォルト値は false | E-07 | ○ |
| C-08 | decode.json-parser.enabled のデフォルト値は true | E-08 | ○ |
| C-09 | MapNullKeyMode は FAIL, DROP, LITERAL の3値 | E-09 | ○ |
| C-10 | フォーマット識別子は "json" | E-10 | ○ |
| C-11 | JsonParser 有効時は JsonParserRowDataDeserializationSchema を使用 | E-11 (87-95行目) | ○ |
| C-12 | JsonParser 無効時は JsonRowDataDeserializationSchema を使用 | E-11 (96-103行目) | ○ |
| C-13 | ChangelogMode は insertOnly() | E-11 (107-109行目), E-12 (167-170行目) | ○ |
| C-14 | JsonParser 有効時はネストしたプロジェクションをサポート | E-11 (111-114行目) | ○ |
| C-15 | シリアライザは RowDataToJsonConverter を使用 | E-13 (89-95行目) | ○ |
| C-16 | ObjectMapper は BigDecimal 設定を適用 | E-14 (101-106行目) | ○ |
| C-17 | serialize は byte[] を返す | E-15 | ○ |
| C-18 | デシリアライザは JsonToRowDataConverter を使用 | E-16 (62-64行目) | ○ |
| C-19 | 配列入力は各要素を個別処理 | E-18 | ○ |
| C-20 | パースエラー時 ignoreParseErrors で継続可否を制御 | E-17 (83-86行目, 96-99行目) | ○ |
| C-21 | SQL タイムスタンプ形式は "yyyy-MM-dd HH:mm:ss.s{precision}" | E-05 | ○ |
| C-22 | ISO-8601 タイムスタンプ形式は "yyyy-MM-ddTHH:mm:ss.s{precision}" | E-05 | ○ |
| C-23 | CDC フォーマット（Debezium等）をサポート | ファイル構造確認 | ○ |
| C-24 | JsonParser は ObjectMapper より高性能 | **根拠なし（定量データなし）** | △ |

## 4) 不足情報（Unknown / Missing）
- JsonParser vs ObjectMapper のパフォーマンス比較データ
  - 候補：ベンチマークテスト / パフォーマンステスト結果 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 設定オプションはソースコードで全て確認済み
- 0（低リスク）: 処理フローはソースコードと整合
- 1（中リスク）: パフォーマンス比較の定量的根拠が不足

## 6) レビュアーチェックリスト（最小）
- [ ] CDC フォーマット（Debezium, Canal, Maxwell, Ogg）の詳細説明が必要か確認
- [ ] JsonParser の性能優位性について公式ドキュメントとの整合性確認
- [ ] 大きな JSON オブジェクトのメモリ制限について追加説明が必要か検討
