---
generated_at: 2026-02-02 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-Parquet

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ParquetFileFormatFactory.java` 59行目 - IDENTIFIER定義
- E-02: `ParquetFileFormatFactory.java` 61-68行目 - UTC_TIMEZONE定義
- E-03: `ParquetFileFormatFactory.java` 70-75行目 - TIMESTAMP_TIME_UNIT定義
- E-04: `ParquetFileFormatFactory.java` 77-83行目 - WRITE_INT64_TIMESTAMP定義
- E-05: `ParquetFileFormatFactory.java` 85-89行目 - BATCH_SIZE定義
- E-06: `ParquetFileFormatFactory.java` 92-95行目 - createDecodingFormat
- E-07: `ParquetFileFormatFactory.java` 98-115行目 - createEncodingFormat
- E-08: `ParquetFileFormatFactory.java` 178-184行目 - reportStatistics
- E-09: `機能一覧.csv` 44行目 - Parquet機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーマット識別子は "parquet" | E-01 | ○ |
| C-02 | utc-timezone のデフォルトは false | E-02 | ○ |
| C-03 | timestamp.time.unit のデフォルトは micros | E-03 | ○ |
| C-04 | write.int64.timestamp のデフォルトは false | E-04 | ○ |
| C-05 | batch-size のデフォルトは 2048 | E-05 | ○ |
| C-06 | ParquetBulkDecodingFormat で読み取り | E-06 | ○ |
| C-07 | ParquetRowDataBuilder で書き込み | E-07 (104行目) | ○ |
| C-08 | ChangelogMode は insertOnly() | E-07 (111-113行目) | ○ |
| C-09 | 統計情報をレポート可能 | E-08 | ○ |
| C-10 | Hive バージョンでタイムゾーン動作が異なる | E-02 (66-68行目) | ○ |
| C-11 | int64 タイムスタンプはタイムゾーン非依存 | E-04 (82-83行目) | ○ |
| C-12 | プロジェクション対応 | E-06 (ParquetBulkDecodingFormat implements ProjectableDecodingFormat) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ベクトル化読み取りの詳細説明が必要か確認
- [ ] Avro との統合（AvroParquetWriters等）の説明が必要か確認
