---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-S3（Hadoop）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：リトライポリシーの詳細設定値について根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-filesystems/flink-s3-fs-hadoop/src/main/java/org/apache/flink/fs/s3hadoop/S3FileSystemFactory.java`
- E-02: `flink-filesystems/flink-s3-fs-hadoop/src/main/java/org/apache/flink/fs/s3hadoop/S3AFileSystemFactory.java`
- E-03: `flink-filesystems/flink-s3-fs-hadoop/src/main/java/org/apache/flink/fs/s3hadoop/HadoopS3AccessHelper.java`
- E-04: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/util/HadoopConfigLoader.java`
- E-05: `機能一覧.csv` - No.51 の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | S3FileSystemFactory は AbstractS3FileSystemFactory を継承している | E-01 (37行目) | ○ |
| C-02 | スキーム "s3" を getScheme() で返す | E-01 (54-56行目) | ○ |
| C-03 | S3AFileSystemFactory は "s3a" スキームを返す | E-02 (24-26行目) | ○ |
| C-04 | 設定プレフィックスは s3., s3a., fs.s3a. | E-01 (41行目) | ○ |
| C-05 | MIRRORED_CONFIG_KEYS でアクセスキー等のマッピング定義 | E-01 (43-47行目) | ○ |
| C-06 | createHadoopFileSystem() で S3AFileSystem を生成 | E-01 (70-72行目) | ○ |
| C-07 | getS3AccessHelper() で HadoopS3AccessHelper を生成 | E-01 (94-98行目) | ○ |
| C-08 | HadoopS3AccessHelper は S3AccessHelper を実装 | E-03 (51行目) | ○ |
| C-09 | startMultiPartUpload メソッドが存在する | E-03 (70-72行目) | ○ |
| C-10 | uploadPart メソッドが存在する | E-03 (75-88行目) | ○ |
| C-11 | putObject メソッドが存在する | E-03 (91-94行目) | ○ |
| C-12 | commitMultiPartUpload メソッドが存在する | E-03 (97-106行目) | ○ |
| C-13 | deleteObject メソッドが存在する | E-03 (109-111行目) | ○ |
| C-14 | getObject メソッドが存在する | E-03 (114-139行目) | ○ |
| C-15 | getObjectMetadata メソッドが存在する | E-03 (142-148行目) | ○ |
| C-16 | InternalWriteOperationHelper がネストクラスとして定義 | E-03 (154-163行目) | ○ |
| C-17 | モジュール名は flink-s3-fs-hadoop | E-05 | ○ |
| C-18 | エクスポネンシャルバックオフのリトライポリシー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18 のリトライポリシーについて：Hadoop S3A の仕様を参照しているが、本コードベース内に明示的な記述がない
  - 候補：Hadoop S3A ドキュメント / AWS SDK 設定 / Flink ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はすべてコードベースに根拠あり
- 1: 中リスク - リトライポリシーの詳細は外部ドキュメント参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] S3FileSystemFactory の継承関係が正しいか確認
- [ ] 設定プレフィックスのマッピングが実際の動作と一致するか確認
- [ ] HadoopS3AccessHelper のマルチパートアップロード実装が正しく記述されているか確認
- [ ] リトライポリシーについてHadoop S3Aドキュメントとの整合性を確認
