---
generated_at: 2026-02-02 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-HDFS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFsFactory.java`
- E-02: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFileSystem.java`
- E-03: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopRecoverableWriter.java`
- E-04: `機能一覧.csv` - No.56 の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HadoopFsFactory は FileSystemFactory を実装 | E-01 (46行目) | ○ |
| C-02 | getScheme() は "*" を返す（任意スキーム対応） | E-01 (57-60行目) | ○ |
| C-03 | configure() で設定を保存 | E-01 (63-66行目) | ○ |
| C-04 | HadoopUtils.getHadoopConfiguration() で設定読み込み | E-01 (84行目) | ○ |
| C-05 | FileSystem.getFileSystemClass() でクラス取得 | E-01 (98行目) | ○ |
| C-06 | authority 未指定時は fs.defaultFS を使用 | E-01 (130-134行目) | ○ |
| C-07 | リフレクションでファイルシステムインスタンス生成 | E-01 (116行目) | ○ |
| C-08 | hadoopFs.initialize() で初期化 | E-01 (168行目) | ○ |
| C-09 | HadoopFileSystem でラップ | E-01 (178行目) | ○ |
| C-10 | limitIfConfigured() で接続制限適用 | E-01 (182行目, 208-226行目) | ○ |
| C-11 | HadoopFileSystem は Flink FileSystem を継承 | E-02 (38行目) | ○ |
| C-12 | コンストラクタで Hadoop FileSystem を受け取る | E-02 (55-57行目) | ○ |
| C-13 | createRecoverableWriter() で HadoopRecoverableWriter 生成 | E-02 (206-211行目) | ○ |
| C-14 | getKindForScheme() でファイルシステム種別判定 | E-02 (246-267行目) | ○ |
| C-15 | s3/emr/oss/wasb/gs は OBJECT_STORE と判定 | E-02 (249-256行目) | ○ |
| C-16 | http/ftp は OBJECT_STORE と判定 | E-02 (257-261行目) | ○ |
| C-17 | その他は FILE_SYSTEM と判定 | E-02 (263-265行目) | ○ |
| C-18 | モジュール名は flink-hadoop-fs | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ワイルドカードスキーム（"*"）の動作と他のファクトリとの優先順位を確認
- [ ] fs.defaultFS 解決ロジックの妥当性を確認
- [ ] getKindForScheme() の判定ロジックが網羅的か確認
- [ ] LimitedConnectionsFileSystem の接続制限設定を確認
