---
generated_at: 2026-02-02 11:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-スタンドアロン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-dist/src/main/flink-bin/bin/start-cluster.sh`
- E-02: `flink-dist/src/main/flink-bin/bin/config.sh`
- E-03: `flink-dist/src/main/flink-bin/bin/jobmanager.sh`
- E-04: `flink-dist/src/main/flink-bin/bin/taskmanager.sh`
- E-05: `flink-dist/src/main/flink-bin/bin/flink-daemon.sh`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | config.sh読み込み | E-01 (23行目), E-03 (47行目) | ○ |
| C-02 | HAモード判定（zookeeper） | E-01 (27行目) | ○ |
| C-03 | HAモード時mastersファイル読み込み | E-01 (29行目) | ○ |
| C-04 | SSH経由でリモートホスト起動 | E-01 (40行目) | ○ |
| C-05 | 非HAモード時ローカル起動 | E-01 (48行目) | ○ |
| C-06 | TMWorkers start呼び出し | E-01 (53行目) | ○ |
| C-07 | ENTRYPOINT=standalonesession | E-03 (49行目) | ○ |
| C-08 | ENTRYPOINT=taskexecutor | E-04 (37行目) | ○ |
| C-09 | デフォルトG1GC設定 | E-04 (42-44行目) | ○ |
| C-10 | NUMAノード毎にTM起動 | E-04 (63-79行目) | ○ |
| C-11 | constructFlinkClassPath関数 | E-02 (20-48行目) | ○ |
| C-12 | flink-dist.jar必須チェック | E-02 (39-45行目) | ○ |
| C-13 | デフォルトPIDディレクトリ/tmp | E-02 (122行目) | ○ |
| C-14 | デフォルトログ保持数10 | E-02 (123行目) | ○ |
| C-15 | デフォルトログレベルINFO | E-02 (124行目) | ○ |
| C-16 | StandaloneSessionClusterEntrypointクラス | E-05 (46行目) | ○ |
| C-17 | StandaloneApplicationClusterEntryPointクラス | E-05 (50行目) | ○ |
| C-18 | TaskManagerRunnerクラス | E-05 (34行目) | ○ |
| C-19 | PIDファイル管理 | E-05 (70-88行目) | ○ |
| C-20 | flockによるロック | E-05 (80-84行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してシェルスクリプトによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シェルスクリプトベースのシンプルな起動処理

## 6) レビュアーチェックリスト（最小）
- [ ] 設定ファイル読み込みロジックが正確か確認
- [ ] HAモード分岐が正しいか確認
- [ ] PIDファイル管理が適切か確認
- [ ] SSH接続パラメータが正しいか確認
