---
generated_at: 2026-02-02 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-クエリアブルステートクライアント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（低）
  - 全ての主張にソースコードの根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-queryable-state/flink-queryable-state-client-java/src/main/java/org/apache/flink/queryablestate/client/QueryableStateClient.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Flink 1.18以降非推奨 | E-01 (76-78行目 @Deprecated) | ○ |
| C-02 | 実行中ジョブのステートをクエリする | E-01 (61-75行目 Javadoc) | ○ |
| C-03 | Client Proxyに接続 | E-01 (67-69行目 Javadoc) | ○ |
| C-04 | コンストラクタでNetty Clientを作成 | E-01 (146-157行目) | ○ |
| C-05 | ポート範囲は0-65535 | E-01 (140-142行目) | ○ |
| C-06 | shutdownAndHandle()で非同期シャットダウン | E-01 (168-170行目) | ○ |
| C-07 | shutdownAndWait()で同期シャットダウン | E-01 (177-184行目) | ○ |
| C-08 | getKvState()でステートをクエリ | E-01 (226-237行目, 250-265行目) | ○ |
| C-09 | キーとネームスペースをシリアライズ | E-01 (304-310行目) | ○ |
| C-10 | KvStateRequestを作成して送信 | E-01 (358-361行目) | ○ |
| C-11 | STATE_FACTORIESでステート種別ごとに生成 | E-01 (85-102行目) | ○ |
| C-12 | VALUE, LIST, MAP, REDUCING, AGGREGATINGをサポート | E-01 (87-101行目) | ○ |
| C-13 | ImmutableValueStateを生成 | E-01 (88-89行目) | ○ |
| C-14 | ImmutableListStateを生成 | E-01 (90-92行目) | ○ |
| C-15 | ImmutableMapStateを生成 | E-01 (93-95行目) | ○ |
| C-16 | createState()でImmutable State生成 | E-01 (324-339行目) | ○ |
| C-17 | サポートされていないステート種別でFlinkRuntimeException | E-01 (327-333行目) | ○ |
| C-18 | キーのhashCode()を使用 | E-01 (316行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコードからの根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠がある
- 注意: 非推奨機能のため、ドキュメントの必要性を検討

## 6) レビュアーチェックリスト（最小）
- [ ] QueryableStateClient の非推奨警告が正確か確認
- [ ] サポートされるステート種別が正確か確認
- [ ] エラーハンドリングの説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
