---
generated_at: 2026-02-02 11:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-PyFlinkコネクタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（低）
  - 全ての主張にソースコードの根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-python/pyflink/datastream/connectors/base.py`
- E-02: `flink-python/pyflink/datastream/connectors/kafka.py`
- E-03: `flink-python/pyflink/datastream/connectors/file_system.py`
- E-04: `flink-python/pyflink/datastream/connectors/jdbc.py`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Source は JavaFunctionWrapper を継承 | E-01 (28-39行目) | ○ |
| C-02 | Sink は JavaFunctionWrapper を継承 | E-01 (42-53行目) | ○ |
| C-03 | DeliveryGuarantee は EXACTLY_ONCE, AT_LEAST_ONCE, NONE を持つ | E-01 (56-85行目) | ○ |
| C-04 | FlinkKafkaConsumer は 1.16 以降非推奨 | E-02 (200行目 DeprecationWarning) | ○ |
| C-05 | FlinkKafkaConsumerBase に set_start_from_earliest() | E-02 (76-86行目) | ○ |
| C-06 | FlinkKafkaConsumerBase に set_start_from_latest() | E-02 (88-98行目) | ○ |
| C-07 | FlinkKafkaConsumerBase に set_start_from_timestamp() | E-02 (100-119行目) | ○ |
| C-08 | Semantic は EXACTLY_ONCE, AT_LEAST_ONCE, NONE を持つ | E-02 (211-251行目) | ○ |
| C-09 | KafkaSource.builder() で KafkaSourceBuilder を返す | E-02 (380-387行目) | ○ |
| C-10 | KafkaSourceBuilder.build() で KafkaSource を生成 | E-02 (432-433行目) | ○ |
| C-11 | set_bootstrap_servers() でブローカー設定 | E-02 (435-443行目) | ○ |
| C-12 | set_topics() でトピック設定 | E-02 (455-465行目) | ○ |
| C-13 | set_starting_offsets() で開始オフセット設定 | E-02 (500-528行目) | ○ |
| C-14 | set_unbounded() で停止オフセット設定 | E-02 (530-563行目) | ○ |
| C-15 | FileEnumeratorProvider でファイル列挙 | E-03 (55-86行目) | ○ |
| C-16 | StreamFormat.text_line_format() でテキスト行フォーマット | E-03 (128-146行目) | ○ |
| C-17 | FileSourceBuilder.monitor_continuously() で継続監視 | E-03 (180-195行目) | ○ |
| C-18 | FileSourceBuilder.process_static_file_set() で静的処理 | E-03 (197-208行目) | ○ |
| C-19 | JdbcSink.sink() で JDBC シンク生成 | E-04 (36-72行目) | ○ |
| C-20 | JdbcConnectionOptions.JdbcConnectionOptionsBuilder でビルダー | E-04 (94-122行目) | ○ |
| C-21 | JdbcExecutionOptions.defaults() でデフォルトオプション | E-04 (141-145行目) | ○ |
| C-22 | JdbcExecutionOptions.Builder で with_batch_size/with_max_retries | E-04 (151-172行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコードからの根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠がある
- 注意: FlinkKafkaConsumer/Producer は非推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Source/Sink 基底クラスの説明が正確か確認
- [ ] KafkaSource ビルダーパターンの説明が正確か確認
- [ ] FileSource のモード（継続/静的）の説明が正確か確認
- [ ] JdbcSink の設定オプションの説明が正確か確認
- [ ] 非推奨 API（FlinkKafkaConsumer/Producer）の警告が明記されているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
