---
generated_at: 2026-02-02 17:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：81-Flink_CLI.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **REST APIリトライ仕様**：ExponentialWaitStrategyの詳細設定は要確認
  2. **パフォーマンス要件の数値**：「数秒以内」は一般的な期待値であり、明示的な要件ではない
  3. **セキュリティ考慮事項**：Kerberos/SSL設定の詳細は設定ファイルを参照のこと

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-clients/src/main/java/org/apache/flink/client/cli/CliFrontend.java`
- E-02: `flink-clients/src/main/java/org/apache/flink/client/cli/CliFrontendParser.java`
- E-03: `flink-clients/src/main/java/org/apache/flink/client/program/PackagedProgram.java`
- E-04: `flink-clients/src/main/java/org/apache/flink/client/cli/ProgramOptions.java`
- E-05: `flink-clients/src/main/java/org/apache/flink/client/cli/ClientOptions.java`
- E-06: 機能一覧.csv（機能No.81の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 7つのアクション（run, list, info, cancel, stop, savepoint, checkpoint）をサポート | E-01（100-106行目） | ○ |
| C-02 | runアクションはJARファイルからFlinkプログラムを実行する | E-01（175-233行目）、E-03 | ○ |
| C-03 | listアクションは実行中・スケジュール済み・完了済みのジョブ一覧を表示 | E-01（390-426行目, 428-495行目） | ○ |
| C-04 | infoアクションはプログラムの実行計画をJSON形式で表示 | E-01（312-383行目） | ○ |
| C-05 | cancelアクションは実行中のジョブをキャンセル | E-01（603-707行目） | ○ |
| C-06 | stopアクションはセーブポイントを取得してジョブを停止 | E-01（534-596行目） | ○ |
| C-07 | savepointアクションは手動でセーブポイントをトリガーまたは破棄 | E-01（722-799行目） | ○ |
| C-08 | checkpointアクションは手動でチェックポイントをトリガー | E-01（935-973行目） | ○ |
| C-09 | -j/--jarfileオプションでJARファイルを指定 | E-02（50-51行目） | ○ |
| C-10 | -c/--classオプションでエントリーポイントクラスを指定 | E-02（52-58行目） | ○ |
| C-11 | -p/--parallelismオプションで並列度を指定 | E-02（71-77行目） | ○ |
| C-12 | -d/--detachedオプションでデタッチモードを指定 | E-02（78-79行目） | ○ |
| C-13 | -s/--fromSavepointオプションでセーブポイントからリストア | E-02（104-109行目） | ○ |
| C-14 | -m/--jobmanagerオプションでJobManagerアドレスを指定 | E-02（96-102行目） | ○ |
| C-15 | mainメソッドがエントリーポイントである | E-01（1320-1327行目） | ○ |
| C-16 | FLINK_CONF_DIR環境変数で設定ディレクトリを指定 | E-01（1369-1395行目） | ○ |
| C-17 | GenericCLI、FlinkYarnSessionCli、DefaultCLIの順でカスタムコマンドラインをロード | E-01（1410-1442行目） | ○ |
| C-18 | parseAndRunメソッドでアクションを振り分け | E-01（1242-1317行目） | ○ |
| C-19 | PackagedProgramはJARファイルのマニフェストからエントリークラスを取得 | E-03（386-456行目） | ○ |
| C-20 | program-classまたはMain-Classマニフェスト属性を使用 | E-03（74-80行目） | ○ |
| C-21 | runClusterActionでClusterClientを取得してアクションを実行 | E-01（1183-1210行目） | ○ |
| C-22 | 終了コード0は成功、1はエラーを示す | E-01（1087-1148行目, 1262-1280行目） | ○ |
| C-23 | cancel -sオプション使用時に非推奨警告を表示 | E-01（623-624行目） | ○ |
| C-24 | Pythonプログラム実行をサポート（--python, --pyFilesオプション） | E-02（216-298行目） | ○ |
| C-25 | REST APIリトライにExponentialWaitStrategyを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25のExponentialWaitStrategyの使用：RestClusterClientの内部実装を確認する必要がある
  - 候補：`flink-clients/src/main/java/org/apache/flink/client/program/rest/RestClusterClient.java` / `flink-clients/src/main/java/org/apache/flink/client/program/rest/retry/ExponentialWaitStrategy.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで裏付けられている
- 1: 中リスク - パフォーマンス要件の数値（「数秒以内」）は実測値ではなく一般的な期待値
- 0: 低リスク - セキュリティ関連の記述は概要レベルだが、詳細は設定ドキュメントを参照すべき

## 6) レビュアーチェックリスト（最小）
- [ ] 7つのアクション（run, list, info, cancel, stop, savepoint, checkpoint）が正しく記載されているか確認
- [ ] 入力パラメータの説明がCliFrontendParser.javaのオプション定義と一致するか確認
- [ ] 処理フローがCliFrontend.javaの実装と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
