---
generated_at: 2026-02-02 17:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-ストリーム例.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. 行番号の確認 - 最新ソースコードとの整合性を要確認
  3. サンプルプログラムの網羅性 - 新規追加されたサンプルがないか確認

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-examples/flink-examples-streaming/src/main/java/org/apache/flink/streaming/examples/wordcount/WordCount.java`
- E-02: `flink-examples/flink-examples-streaming/src/main/java/org/apache/flink/streaming/examples/windowing/TopSpeedWindowing.java`
- E-03: `flink-examples/flink-examples-streaming/src/main/java/org/apache/flink/streaming/examples/async/AsyncIOExample.java`
- E-04: `flink-examples/flink-examples-streaming/src/main/java/org/apache/flink/streaming/examples/statemachine/StateMachineExample.java`
- E-05: 機能一覧.csv（機能No.82の定義）
- E-06: Globパターン結果（サンプルファイル一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WordCountサンプルが存在する | E-01、E-06 | ○ |
| C-02 | 入力テキストを小文字変換して単語分割 | E-01（197行目） | ○ |
| C-03 | --inputオプションで入力パスを指定 | E-01（43-58行目Javadoc） | ○ |
| C-04 | --outputオプションで出力パスを指定 | E-01（43-58行目Javadoc） | ○ |
| C-05 | --execution-modeオプションで実行モード指定 | E-01（59-60行目Javadoc） | ○ |
| C-06 | --async-stateオプションで非同期ステート有効化 | E-01（61行目Javadoc、86-92行目） | ○ |
| C-07 | StreamExecutionEnvironment.getExecutionEnvironment()でEnvironment取得 | E-01（83行目） | ○ |
| C-08 | FileSourceでファイル入力 | E-01（123-131行目） | ○ |
| C-09 | fromDataでインメモリデータ入力 | E-01（133行目） | ○ |
| C-10 | flatMapでTokenizer適用 | E-01（140-141行目） | ○ |
| C-11 | keyByで単語ごとにグループ化 | E-01（146行目） | ○ |
| C-12 | sum(1)でカウント集計 | E-01（156-157行目） | ○ |
| C-13 | FileSinkでファイル出力 | E-01（163-172行目） | ○ |
| C-14 | print()で標準出力 | E-01（174行目） | ○ |
| C-15 | env.execute()でジョブ実行 | E-01（179行目） | ○ |
| C-16 | Tokenizerがvalue.toLowerCase().split("\\W+")を使用 | E-01（197行目） | ○ |
| C-17 | 長さ0の単語をスキップ | E-01（201行目） | ○ |
| C-18 | AsyncIOExampleが存在する | E-03、E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている
- 0: 低リスク - サンプルコードは実際に動作するコードである

## 6) レビュアーチェックリスト（最小）
- [ ] WordCount.javaの主要処理行番号が最新と一致するか確認
- [ ] サンプルプログラム一覧が最新のモジュール内容と一致するか確認
- [ ] DSv2サンプルの存在を確認
