---
generated_at: 2026-02-02 17:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-プロジェクトテンプレート.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/src/main/java/DataStreamJob.java`
- E-02: `flink-quickstart/flink-quickstart-java/src/main/resources/META-INF/maven/archetype-metadata.xml`
- E-03: `flink-quickstart/flink-quickstart-java/src/main/resources/archetype-resources/pom.xml`
- E-04: `flink-quickstart/pom.xml`
- E-05: `flink-quickstart/flink-quickstart-java/pom.xml`
- E-06: 機能一覧.csv（機能No.89の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DataStreamJob.javaテンプレートが存在する | E-01 | ○ |
| C-02 | ${package}でパッケージ名を動的設定 | E-01（19行目） | ○ |
| C-03 | StreamExecutionEnvironment.getExecutionEnvironment()でenv取得 | E-01（40行目） | ○ |
| C-04 | env.execute()でジョブ実行 | E-01（63行目） | ○ |
| C-05 | archetype-metadata.xmlでArchetype構造定義 | E-02（20-35行目） | ○ |
| C-06 | filtered="true"でテンプレート変数置換 | E-02（26行目） | ○ |
| C-07 | packaged="true"でパッケージディレクトリ変換 | E-02（26行目） | ○ |
| C-08 | flink-streaming-javaがprovided scope | E-03（57-62行目） | ○ |
| C-09 | flink-clientsがprovided scope | E-03（63-68行目） | ○ |
| C-10 | @project.version@でFlinkバージョン置換 | E-03（32行目） | ○ |
| C-11 | maven-shade-pluginでfat JAR生成 | E-03（119-161行目） | ○ |
| C-12 | maven-archetype-pluginを使用 | E-04（50-52行目）、E-05（39-50行目） | ○ |
| C-13 | packaging=maven-archetype | E-05（34行目） | ○ |
| C-14 | @デリミタを使用してリソースフィルタリング | E-04（79-82行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] archetype-metadata.xmlのファイルセット定義が正確か確認
- [ ] pom.xmlテンプレートの依存関係バージョンが最新か確認
- [ ] maven-shade-pluginの除外設定が適切か確認
