---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：92-機械学習モデル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **Azure OpenAI 互換性**：根拠不足
  2. **API キーの環境変数取得推奨**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIModelProviderFactory.java`
- E-02: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/AbstractOpenAIModelFunction.java`
- E-03: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIChatModelFunction.java`
- E-04: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIEmbeddingModelFunction.java`
- E-05: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIOptions.java`
- E-06: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIUtils.java`
- E-07: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/ContextOverflowAction.java`
- E-08: `flink-models/pom.xml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | flink-models は OpenAI API をサポート | E-08 (pom.xml の modules) | ○ |
| C-02 | IDENTIFIER は "openai" | E-01 (32行目) | ○ |
| C-03 | Chat Completion と Embedding をサポート | E-01 (43-48行目) | ○ |
| C-04 | endpoint は必須パラメータ | E-01 (59-65行目), E-05 (37-47行目) | ○ |
| C-05 | api-key は必須パラメータ | E-01 (59-65行目), E-05 (50-54行目) | ○ |
| C-06 | model は必須パラメータ | E-01 (59-65行目), E-05 (57-66行目) | ○ |
| C-07 | max-context-size はオプション | E-05 (69-74行目) | ○ |
| C-08 | context-overflow-action のデフォルトは TRUNCATED_TAIL | E-05 (77-84行目) | ○ |
| C-09 | error-handling-strategy のデフォルトは RETRY | E-05 (87-92行目) | ○ |
| C-10 | retry-num のデフォルトは 100 | E-05 (97-101行目) | ○ |
| C-11 | system-prompt のデフォルトは "You are a helpful assistant." | E-05 (119-124行目) | ○ |
| C-12 | 入力スキーマは単一 VARCHAR カラム | E-02 (95-98行目) | ○ |
| C-13 | 出力スキーマは単一物理カラム | E-02 (143-195行目) | ○ |
| C-14 | open() でクライアントを初期化 | E-02 (104-110行目) | ○ |
| C-15 | asyncPredict() で NULL チェック | E-02 (114-117行目) | ○ |
| C-16 | processTokensWithLimit() でコンテキスト制限 | E-02 (120-121行目), E-07 (156-169行目) | ○ |
| C-17 | handleErrorsAndRespond() でエラー処理 | E-02 (197-224行目) | ○ |
| C-18 | ErrorHandlingStrategy に RETRY, FAILOVER, IGNORE | E-02 (227-243行目) | ○ |
| C-19 | RetryFallbackStrategy に FAILOVER, IGNORE | E-02 (249-262行目) | ○ |
| C-20 | Chat Completion の ENDPOINT_SUFFIX は "chat/completions" | E-03 (44行目) | ○ |
| C-21 | Embedding の ENDPOINT_SUFFIX は "embeddings" | E-04 (43行目) | ○ |
| C-22 | ChatCompletionCreateParams を使用 | E-03 (87-105行目) | ○ |
| C-23 | EmbeddingCreateParams を使用 | E-04 (83-91行目) | ○ |
| C-24 | Embedding は ARRAY<FLOAT> を返す | E-04 (55-58行目, 100-113行目) | ○ |
| C-25 | クライアント参照カウント管理 | E-06 (42-77行目) | ○ |
| C-26 | ContextOverflowAction に TRUNCATED_TAIL/HEAD, SKIPPED | E-07 (44-109行目) | ○ |
| C-27 | jtokkit でトークンカウント | E-07 (23-28行目) | ○ |
| C-28 | ErrorMessageMetadata でエラー情報取得 | E-02 (268-336行目) | ○ |
| C-29 | Experimental アノテーション | E-05 (29行目) | ○ |
| C-30 | SPI で Factory を登録 | E-01, META-INF/services | ○ |
| C-31 | Azure OpenAI 互換エンドポイント対応 | **根拠なし** | △ |
| C-32 | API キーを環境変数から取得推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Azure OpenAI 互換性**：エンドポイント URL を変更することで Azure OpenAI でも使用可能と推測されるが、明示的なドキュメントや実装確認がない
  - 候補：公式ドキュメント / 統合テスト / サンプルコード
- **API キーの環境変数取得推奨**：セキュリティベストプラクティスとして記載したが、実装上の推奨はない
  - 候補：セキュリティドキュメント / サンプル設定 / Flink Configuration のシークレット管理機能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定オプションのデフォルト値（E-05 から確認済み）
- 0: 低リスク - エラーハンドリング戦略（E-02 から確認済み）
- 0: 低リスク - コンテキストオーバーフロー処理（E-07 から確認済み）
- 1: 中リスク - Azure OpenAI 互換性（根拠なし）
- 1: 中リスク - API キーの取り扱い推奨（根拠なし）

## 6) レビュアーチェックリスト（最小）
- [ ] OpenAIOptions.java の設定オプション定義とドキュメントの一致確認
- [ ] AbstractOpenAIModelFunction.java のエラーハンドリング戦略の正確性確認
- [ ] ContextOverflowAction.java のトークン処理ロジックの理解確認
- [ ] Azure OpenAI 互換性に関する記述の削除または根拠の追加
- [ ] API キー取り扱いに関するセキュリティ記述の適切性確認
- [ ] コードリーディングガイドの行番号の最新版との整合性確認
- [ ] retry-num のデフォルト値 100 がレートリミット対応として適切か確認
