---
generated_at: 2026-02-02 16:20:00
metrics:
  claims_total: 43
  claims_with_evidence: 43
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **1.00**
  - 根拠あり: 43 / 43、根拠なし: 0
- 優先レビュー（高）
  1. なし - すべての画面情報はソースコードから直接抽出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime-web/web-dashboard/src/app/routes.ts` - メインルーティング定義
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/routes.ts` - JobManagerルーティング
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/routes.ts` - TaskManagerルーティング
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/job/routes.ts` - ジョブルーティング
- E-05: `flink-runtime-web/web-dashboard/src/app/pages/job/modules/running-job/routes.ts` - 実行中ジョブルーティング
- E-06: `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/routes.ts` - 完了済みジョブルーティング
- E-07: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/routes.ts` - ジョブ概要ルーティング
- E-08: `flink-runtime-web/web-dashboard/src/app/pages/application/routes.ts` - アプリケーションルーティング
- E-09: `flink-runtime-web/web-dashboard/src/app/pages/application/modules/running-application/routes.ts` - 実行中アプリケーションルーティング
- E-10: `flink-runtime-web/web-dashboard/src/app/pages/application/modules/completed-application/routes.ts` - 完了済みアプリケーションルーティング
- E-11: `flink-runtime-web/web-dashboard/src/app/pages/application/overview/routes.ts` - アプリケーション概要ルーティング
- E-12: `flink-runtime-web/web-dashboard/src/app/pages/overview/overview.component.ts` - オーバービューコンポーネント
- E-13: `flink-runtime-web/web-dashboard/src/app/pages/submit/submit.component.ts` - サブミットコンポーネント
- E-14: `flink-runtime-web/web-dashboard/src/app/pages/job/job.component.ts` - ジョブコンポーネント
- E-15: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.ts` - JobManagerコンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オーバービュー画面の存在 | E-01, E-12 | ○ |
| C-02 | ジョブサブミット画面の存在 | E-01, E-13 | ○ |
| C-03 | 実行中ジョブ一覧画面の存在 | E-04, E-14 | ○ |
| C-04 | 完了済みジョブ一覧画面の存在 | E-04, E-14 | ○ |
| C-05 | ジョブ詳細画面の存在 | E-05, E-06 | ○ |
| C-06 | ジョブ概要（DAGグラフ）画面の存在 | E-05, E-06, E-07 | ○ |
| C-07 | タイムライン画面の存在 | E-05, E-06 | ○ |
| C-08 | 例外情報画面の存在 | E-05, E-06 | ○ |
| C-09 | データスキュー画面の存在 | E-05, E-06 | ○ |
| C-10 | チェックポイント画面の存在 | E-05, E-06 | ○ |
| C-11 | ジョブ設定画面の存在 | E-05, E-06 | ○ |
| C-12 | クラスター設定画面の存在（完了済みジョブのみ） | E-06 | ○ |
| C-13 | 頂点詳細ドロワーの存在 | E-07 | ○ |
| C-14 | 頂点詳細タブの存在 | E-07 | ○ |
| C-15 | サブタスク一覧タブの存在 | E-07 | ○ |
| C-16 | TaskManager一覧タブの存在 | E-07 | ○ |
| C-17 | ウォーターマークタブの存在 | E-07 | ○ |
| C-18 | アキュムレータータブの存在 | E-07 | ○ |
| C-19 | メトリクスチャートタブの存在 | E-07 | ○ |
| C-20 | バックプレッシャータブの存在 | E-07 | ○ |
| C-21 | フレームグラフタブの存在 | E-07 | ○ |
| C-22 | JobManager画面の存在 | E-02, E-15 | ○ |
| C-23 | JobManagerメトリクス画面の存在 | E-02 | ○ |
| C-24 | JobManager設定画面の存在 | E-02 | ○ |
| C-25 | JobManagerログ画面の存在 | E-02 | ○ |
| C-26 | JobManager標準出力画面の存在 | E-02 | ○ |
| C-27 | JobManagerログ一覧画面の存在 | E-02 | ○ |
| C-28 | JobManagerログ詳細画面の存在 | E-02 | ○ |
| C-29 | JobManagerスレッドダンプ画面の存在 | E-02 | ○ |
| C-30 | JobManagerプロファイラ画面の存在 | E-02 | ○ |
| C-31 | TaskManager一覧画面の存在 | E-03 | ○ |
| C-32 | TaskManager詳細画面の存在 | E-03 | ○ |
| C-33 | TaskManagerメトリクス画面の存在 | E-03 | ○ |
| C-34 | TaskManagerログ一覧画面の存在 | E-03 | ○ |
| C-35 | TaskManagerログ詳細画面の存在 | E-03 | ○ |
| C-36 | TaskManagerスレッドダンプ画面の存在 | E-03 | ○ |
| C-37 | TaskManagerプロファイラ画面の存在 | E-03 | ○ |
| C-38 | TaskManagerログ画面の存在 | E-03 | ○ |
| C-39 | TaskManager標準出力画面の存在 | E-03 | ○ |
| C-40 | 実行中アプリケーション一覧画面の存在 | E-08, E-09 | ○ |
| C-41 | 完了済みアプリケーション一覧画面の存在 | E-08, E-10 | ○ |
| C-42 | アプリケーション詳細画面の存在 | E-09, E-10 | ○ |
| C-43 | アプリケーション概要画面の存在 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報なし
- すべての画面情報はAngularルーティング定義およびコンポーネントファイルから直接抽出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての画面情報がソースコードに基づいている
- 注意点:
  - 動的に生成される画面（モーダル、ダイアログ等）は本一覧に含まれていない可能性がある
  - 条件付きで表示される画面（例: クラスター設定はHistory Serverのみ）が存在する

## 6) レビュアーチェックリスト（最小）
- [ ] 全43画面がソースコードのルーティング定義と一致しているか確認
- [ ] 画面遷移図がルーティング構造を正しく反映しているか確認
- [ ] カテゴリ分類が適切か確認
- [ ] History Server専用画面の条件が正しく記載されているか確認
- [ ] テンプレートファイルパスが実在するか確認
