# 画面遷移図

## Apache Flink Web Dashboard 画面遷移図

```mermaid
flowchart TB
    subgraph "メイン画面"
        Overview["オーバービュー<br>/overview"]
        Submit["ジョブサブミット<br>/submit"]
    end

    subgraph "JobManager管理"
        JM["JobManager<br>/job-manager"]
        JM_Metrics["JobManagerメトリクス<br>/job-manager/metrics"]
        JM_Config["JobManager設定<br>/job-manager/config"]
        JM_Logs["JobManagerログ<br>/job-manager/logs"]
        JM_Stdout["JobManager標準出力<br>/job-manager/stdout"]
        JM_LogList["JobManagerログ一覧<br>/job-manager/log"]
        JM_LogDetail["JobManagerログ詳細<br>/job-manager/log/:logName"]
        JM_ThreadDump["JobManagerスレッドダンプ<br>/job-manager/thread-dump"]
        JM_Profiler["JobManagerプロファイラ<br>/job-manager/profiler"]
    end

    subgraph "TaskManager管理"
        TM_List["TaskManager一覧<br>/task-manager"]
        TM["TaskManager詳細<br>/task-manager/:id"]
        TM_Metrics["TaskManagerメトリクス<br>/task-manager/:id/metrics"]
        TM_LogList["TaskManagerログ一覧<br>/task-manager/:id/log-list"]
        TM_LogDetail["TaskManagerログ詳細<br>/task-manager/:id/log-list/:logName"]
        TM_ThreadDump["TaskManagerスレッドダンプ<br>/task-manager/:id/thread-dump"]
        TM_Profiler["TaskManagerプロファイラ<br>/task-manager/:id/profiler"]
        TM_Logs["TaskManagerログ<br>/task-manager/:id/logs"]
        TM_Stdout["TaskManager標準出力<br>/task-manager/:id/stdout"]
    end

    subgraph "ジョブ管理"
        RunningJobs["実行中ジョブ一覧<br>/job/running"]
        CompletedJobs["完了済みジョブ一覧<br>/job/completed"]

        subgraph "ジョブ詳細"
            JobDetail["ジョブ詳細<br>/job/:status/:jid"]
            Job_Overview["ジョブ概要（DAGグラフ）<br>overview"]
            Job_Timeline["タイムライン<br>timeline"]
            Job_Exceptions["例外情報<br>exceptions"]
            Job_DataSkew["データスキュー<br>dataskew"]
            Job_Checkpoints["チェックポイント<br>checkpoints"]
            Job_Config["ジョブ設定<br>configuration"]
            Job_ClusterConfig["クラスター設定<br>cluster_configuration"]
        end

        subgraph "頂点詳細（Drawer）"
            Vertex_Drawer["頂点詳細ドロワー<br>:vertexId"]
            Vertex_Detail["頂点詳細<br>detail"]
            Vertex_Subtasks["サブタスク一覧<br>subtasks"]
            Vertex_TMs["TaskManager一覧<br>taskmanagers"]
            Vertex_Watermarks["ウォーターマーク<br>watermarks"]
            Vertex_Accumulators["アキュムレーター<br>accumulators"]
            Vertex_Chart["メトリクスチャート<br>metrics"]
            Vertex_Backpressure["バックプレッシャー<br>backpressure"]
            Vertex_Flamegraph["フレームグラフ<br>flamegraph"]
        end
    end

    subgraph "アプリケーション管理"
        RunningApps["実行中アプリケーション一覧<br>/application/running"]
        CompletedApps["完了済みアプリケーション一覧<br>/application/completed"]
        AppDetail["アプリケーション詳細<br>/application/:status/:id"]
        App_Overview["アプリケーション概要<br>overview"]
    end

    %% メインナビゲーション
    Overview --> Submit
    Overview --> JM
    Overview --> TM_List
    Overview --> RunningJobs
    Overview --> CompletedJobs
    Overview --> RunningApps
    Overview --> CompletedApps

    %% JobManager内遷移
    JM --> JM_Metrics
    JM --> JM_Config
    JM --> JM_Logs
    JM --> JM_Stdout
    JM --> JM_LogList
    JM --> JM_ThreadDump
    JM --> JM_Profiler
    JM_LogList --> JM_LogDetail

    %% TaskManager内遷移
    TM_List --> TM
    TM --> TM_Metrics
    TM --> TM_LogList
    TM --> TM_ThreadDump
    TM --> TM_Profiler
    TM --> TM_Logs
    TM --> TM_Stdout
    TM_LogList --> TM_LogDetail

    %% ジョブ内遷移
    RunningJobs --> JobDetail
    CompletedJobs --> JobDetail
    JobDetail --> Job_Overview
    JobDetail --> Job_Timeline
    JobDetail --> Job_Exceptions
    JobDetail --> Job_DataSkew
    JobDetail --> Job_Checkpoints
    JobDetail --> Job_Config
    JobDetail --> Job_ClusterConfig

    %% 頂点詳細遷移
    Job_Overview --> Vertex_Drawer
    Vertex_Drawer --> Vertex_Detail
    Vertex_Drawer --> Vertex_Subtasks
    Vertex_Drawer --> Vertex_TMs
    Vertex_Drawer --> Vertex_Watermarks
    Vertex_Drawer --> Vertex_Accumulators
    Vertex_Drawer --> Vertex_Chart
    Vertex_Drawer --> Vertex_Backpressure
    Vertex_Drawer --> Vertex_Flamegraph

    %% アプリケーション内遷移
    RunningApps --> AppDetail
    CompletedApps --> AppDetail
    AppDetail --> App_Overview

    %% ジョブサブミットからジョブ詳細への遷移
    Submit -->|"ジョブ実行後"| RunningJobs

    %% オーバービューからの直接遷移
    Overview -->|"アプリケーション選択"| AppDetail
```

## 画面カテゴリ別構成

### 1. メイン画面
- **オーバービュー** (`/overview`): アプリケーションのダッシュボード。デフォルトのランディングページ
- **ジョブサブミット** (`/submit`): JARファイルのアップロードとジョブ実行

### 2. JobManager管理
JobManagerの監視・管理機能を提供する画面群

| パス | 画面名 | 説明 |
|------|--------|------|
| `/job-manager/metrics` | メトリクス | JVMメモリ、CPU使用率などのメトリクス表示 |
| `/job-manager/config` | 設定 | JobManagerの設定パラメータ表示 |
| `/job-manager/logs` | ログ | ログ内容のリアルタイム表示 |
| `/job-manager/stdout` | 標準出力 | 標準出力の表示 |
| `/job-manager/log` | ログ一覧 | ログファイルの一覧表示 |
| `/job-manager/log/:logName` | ログ詳細 | 選択したログファイルの内容表示 |
| `/job-manager/thread-dump` | スレッドダンプ | JVMスレッドダンプの取得・表示 |
| `/job-manager/profiler` | プロファイラ | CPUプロファイリング機能 |

### 3. TaskManager管理
TaskManagerの監視・管理機能を提供する画面群

| パス | 画面名 | 説明 |
|------|--------|------|
| `/task-manager` | 一覧 | 登録されているTaskManagerの一覧 |
| `/task-manager/:id/metrics` | メトリクス | 個別TaskManagerのメトリクス |
| `/task-manager/:id/log-list` | ログ一覧 | ログファイル一覧 |
| `/task-manager/:id/log-list/:logName` | ログ詳細 | 選択したログの内容 |
| `/task-manager/:id/thread-dump` | スレッドダンプ | スレッドダンプ取得・表示 |
| `/task-manager/:id/profiler` | プロファイラ | CPUプロファイリング |
| `/task-manager/:id/logs` | ログ | ログのリアルタイム表示 |
| `/task-manager/:id/stdout` | 標準出力 | 標準出力の表示 |

### 4. ジョブ管理
Flinkジョブの監視・管理機能を提供する画面群

#### ジョブ一覧
| パス | 画面名 | 説明 |
|------|--------|------|
| `/job/running` | 実行中ジョブ一覧 | 現在実行中のジョブ |
| `/job/completed` | 完了済みジョブ一覧 | 完了したジョブ（成功・失敗・キャンセル） |

#### ジョブ詳細タブ
| タブ | 画面名 | 説明 |
|------|--------|------|
| `overview` | ジョブ概要 | DAGグラフ表示 |
| `timeline` | タイムライン | 実行タイムライン |
| `exceptions` | 例外情報 | エラー・例外情報 |
| `dataskew` | データスキュー | データ偏り分析 |
| `checkpoints` | チェックポイント | チェックポイント情報 |
| `configuration` | ジョブ設定 | ジョブ設定パラメータ |
| `cluster_configuration` | クラスター設定 | クラスター設定（History Serverのみ） |

#### 頂点詳細（DAGグラフ上のノード選択時）
| タブ | 画面名 | 説明 |
|------|--------|------|
| `detail` | 詳細 | 頂点の基本情報 |
| `subtasks` | サブタスク | サブタスク一覧 |
| `taskmanagers` | TaskManagers | 実行TaskManager一覧 |
| `watermarks` | ウォーターマーク | ウォーターマーク情報 |
| `accumulators` | アキュムレーター | 集計値情報 |
| `metrics` | メトリクス | メトリクスチャート |
| `backpressure` | バックプレッシャー | バックプレッシャー状態 |
| `flamegraph` | フレームグラフ | CPU使用率分析 |

### 5. アプリケーション管理
Flinkアプリケーションの監視機能を提供する画面群

| パス | 画面名 | 説明 |
|------|--------|------|
| `/application/running` | 実行中アプリケーション一覧 | 実行中のアプリケーション |
| `/application/completed` | 完了済みアプリケーション一覧 | 完了したアプリケーション |
| `/application/:status/:id/overview` | アプリケーション概要 | アプリケーション詳細情報 |

## 遷移パターン

### グローバルナビゲーション
オーバービュー画面のサイドナビゲーションから以下の画面にアクセス可能:
- オーバービュー
- ジョブサブミット
- JobManager
- TaskManager
- 実行中ジョブ/完了済みジョブ
- 実行中アプリケーション/完了済みアプリケーション

### ジョブ実行フロー
1. ジョブサブミット画面でJARをアップロード
2. 実行パラメータを設定
3. 実行計画をプレビュー（任意）
4. ジョブを実行
5. 自動的に実行中ジョブ詳細画面に遷移

### ログ閲覧フロー
1. ログ一覧画面でファイルを選択
2. ログ詳細画面で内容を確認
