---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 86
  claims_with_evidence: 82
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：82 / 86、根拠なし：4
- 優先レビュー（高）
  1. **データスキュー画面の主機能**: コンポーネントファイルの詳細未確認
  2. **タイムライン画面の詳細処理**: タイムライン固有のAPIエンドポイント未確認
  3. **アプリケーション関連画面のAPI連携**: 一部推定含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（43画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（92機能）
- E-03: `flink-runtime-web/web-dashboard/src/app/routes.ts` - メインルーティング設定
- E-04: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` - JobService（ジョブ関連API）
- E-05: `flink-runtime-web/web-dashboard/src/app/services/overview.service.ts` - OverviewService（概要API）
- E-06: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` - JobManagerService（JM管理API）
- E-07: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` - TaskManagerService（TM管理API）
- E-08: `flink-runtime-web/web-dashboard/src/app/services/jar.service.ts` - JarService（JAR管理API）
- E-09: `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` - ApplicationService（アプリAPI）
- E-10: `flink-runtime-web/web-dashboard/src/app/services/metrics.service.ts` - MetricsService（メトリクスAPI）
- E-11: `flink-runtime-web/web-dashboard/src/app/pages/overview/overview.component.ts` - オーバービュー画面
- E-12: `flink-runtime-web/web-dashboard/src/app/pages/submit/submit.component.ts` - ジョブサブミット画面
- E-13: `flink-runtime-web/web-dashboard/src/app/pages/job/job.component.ts` - ジョブ一覧画面
- E-14: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/job-overview.component.ts` - ジョブ概要画面
- E-15: `flink-runtime-web/web-dashboard/src/app/pages/job/checkpoints/job-checkpoints.component.ts` - チェックポイント画面
- E-16: `flink-runtime-web/web-dashboard/src/app/pages/job/exceptions/job-exceptions.component.ts` - 例外情報画面
- E-17: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.ts` - JMメトリクス画面
- E-18: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.ts` - TM一覧画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オーバービュー画面がREST APIを主機能として使用 | E-05, E-11 | ○ |
| C-02 | オーバービュー画面がジョブ管理機能と連携 | E-09, E-11 | ○ |
| C-03 | オーバービュー画面がメトリクスコア機能とAPI連携 | E-10, E-11 | ○ |
| C-04 | ジョブサブミット画面がREST APIを主機能として使用 | E-08, E-12 | ○ |
| C-05 | ジョブサブミット画面が実行中ジョブ画面へ遷移 | E-12 (navigateメソッド) | ○ |
| C-06 | 実行中ジョブ一覧がREST APIを使用 | E-04, E-13 | ○ |
| C-07 | 完了済みジョブ一覧がREST APIを使用 | E-04, E-13 | ○ |
| C-08 | ジョブ詳細画面がREST APIを使用 | E-04 | ○ |
| C-09 | ジョブ概要画面がDAGグラフを表示 | E-14 (DagreComponent使用) | ○ |
| C-10 | ジョブ概要画面がメトリクスと連携 | E-10, E-14 | ○ |
| C-11 | ジョブ概要画面がリスケール機能を持つ | E-04, E-14 (onRescaleメソッド) | ○ |
| C-12 | タイムライン画面がREST APIを使用 | E-04 | ○ |
| C-13 | タイムライン画面がサブタスク時間情報を取得 | E-04 (loadSubTaskTimes) | △ |
| C-14 | 例外情報画面がREST APIを使用 | E-04, E-16 | ○ |
| C-15 | 例外情報画面がTaskManager画面へ遷移可能 | E-16 (navigateToメソッド) | ○ |
| C-16 | データスキュー画面がREST APIを使用 | E-10 | △ |
| C-17 | チェックポイント画面がREST APIを使用 | E-04, E-15 | ○ |
| C-18 | チェックポイント画面がチェックポイント機能と連携 | E-15 (loadCheckpointStats, loadCheckpointConfig) | ○ |
| C-19 | ジョブ設定画面がREST APIを使用 | E-04 (loadJobConfig) | ○ |
| C-20 | クラスター設定画面がHistory Server経由で取得 | E-06 (loadHistoryServerConfig) | ○ |
| C-21-30 | 頂点詳細関連画面がREST APIを使用 | E-04, E-10 | ○ |
| C-31 | JobManager画面がREST APIを使用 | E-06 | ○ |
| C-32 | JobManagerメトリクス画面がメトリクスを取得 | E-06, E-17 | ○ |
| C-33 | JobManager設定画面が設定を取得 | E-06 (loadConfig) | ○ |
| C-34-39 | JobManagerログ関連画面がREST APIを使用 | E-06 | ○ |
| C-40 | JobManagerプロファイラ画面がプロファイリング機能と連携 | E-06 (loadProfilingList, createProfilingInstance) | ○ |
| C-41 | TaskManager一覧画面がREST APIを使用 | E-07, E-18 | ○ |
| C-42-49 | TaskManager関連画面がREST APIを使用 | E-07 | ○ |
| C-50 | TaskManagerプロファイラ画面がプロファイリング機能と連携 | E-07 (loadProfilingList, createProfilingInstance) | ○ |
| C-51-54 | アプリケーション関連画面がREST APIを使用 | E-09 | ○ |
| C-55 | アプリケーション詳細画面がキャンセル機能を持つ | E-09 (cancelApplication) | ○ |
| C-56-86 | 各画面の関連種別（主機能/補助機能/遷移先機能/API連携）の分類 | E-01〜E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- データスキュー画面（画面No.9）のコンポーネント詳細実装の確認が不足
  - 候補：`data-skew.component.ts`の詳細解析 / メトリクスAPI仕様書
- タイムライン画面の固有APIエンドポイントの詳細確認が不足
  - 候補：`job-timeline.component.ts`の詳細解析 / REST API仕様書
- アプリケーション概要画面の詳細実装確認が不足
  - 候補：`application-overview.component.ts`の詳細解析
- History Server固有機能の詳細仕様が不足
  - 候補：flink-runtime-webのREST handler実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面とREST API機能のマッピングは実装コードから直接確認可能
- 0: 低リスク - サービスクラスのメソッド定義からAPI連携を正確に特定
- 1: 中リスク - 一部画面（データスキュー、タイムライン）の詳細実装未確認
- 1: 中リスク - History Server機能は通常のREST APIと異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧（E-01）の全43画面がマッピングに含まれているか確認
- [ ] 機能一覧（E-02）で参照されている機能No（23, 24, 25, 26, 32, 57, 4, 10）が正しいか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] データスキュー画面のマッピング内容を実装コードと照合
- [ ] タイムライン画面のマッピング内容を実装コードと照合
- [ ] History Server関連機能（クラスター設定画面等）の動作確認
