# 画面設計書 1-オーバービュー

## 概要

本ドキュメントは、Apache Flink Web Dashboardのオーバービュー画面の設計仕様を記述したものである。本画面はFlinkクラスターのダッシュボードとして機能し、クラスター全体の統計情報およびアプリケーション一覧を表示する。

### 本画面の処理概要

オーバービュー画面は、Flink Web Dashboardのデフォルトランディングページとして、クラスターの健全性と稼働状況を一目で把握できる情報を提供する。

**業務上の目的・背景**：Flinkクラスターの運用管理者やデータエンジニアが、クラスターのリソース状況（TaskManager数、スロット数）およびアプリケーションの稼働状況を即座に確認し、問題の早期発見や容量計画に活用するために設計されている。特に大規模クラスター環境において、全体状況の俯瞰把握は運用上不可欠である。

**画面へのアクセス方法**：ブラウザから`/overview`パスにアクセスするか、ナビゲーションメニューの「Overview」をクリックすることでアクセスできる。ルートパス（`/`）や`/**`へのアクセスは本画面にリダイレクトされる。

**主要な操作・処理内容**：
1. クラスター概要統計の自動取得・表示（TaskManager数、スロット数、Flinkバージョン）
2. 実行中アプリケーション一覧の表示とフィルタリング
3. 完了済みアプリケーション一覧の表示
4. アプリケーション行クリックによる詳細画面への遷移

**画面遷移**：
- 遷移元：ナビゲーションメニュー、ルートパスからのリダイレクト
- 遷移先：アプリケーション詳細画面（`/application/running/:id` または `/application/completed/:id`）

**権限による表示制御**：本画面に関しては、特別な権限制御は実装されていない。REST APIへのアクセス権があれば全ての情報が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | クラスター概要情報（TaskManager数、スロット数、Flinkバージョン）の取得・表示 |
| 23 | ジョブ管理 | 補助機能 | アプリケーション一覧の取得とジョブ状態統計の表示 |
| 57 | メトリクスコア | API連携 | クラスター統計データのメトリクス収集 |

## 画面種別

ダッシュボード / 一覧

## URL/ルーティング

- パス: `/overview`
- リダイレクト元: `/`, `/**`（未定義パス）

## 入出力項目

| 項目名 | 種別 | データ型 | 説明 |
|--------|------|----------|------|
| なし | - | - | 本画面は入力項目を持たない（表示専用） |

## 表示項目

### クラスター統計セクション

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| TaskManager数 | number | 稼働中のTaskManager数 | `/overview` API |
| ブロック中TaskManager数 | number | ブロック状態のTaskManager数（非ゼロ時のみ表示） | `/overview` API |
| 総スロット数 | number | クラスター全体のスロット数 | `/overview` API |
| 利用可能スロット数 | number | 現在利用可能なスロット数 | `/overview` API |
| 空きブロックスロット数 | number | 空きかつブロック中のスロット数（非ゼロ時のみ表示） | `/overview` API |
| 実行中アプリケーション数 | number | RUNNING状態のアプリケーション数 | `/applications/overview` API |
| 完了アプリケーション数 | number | FINISHED状態のアプリケーション数 | `/applications/overview` API |
| キャンセルアプリケーション数 | number | CANCELED状態のアプリケーション数 | `/applications/overview` API |
| 失敗アプリケーション数 | number | FAILED状態のアプリケーション数 | `/applications/overview` API |
| Flinkバージョン | string | Flinkのバージョン番号 | `/overview` API |
| Flinkコミット | string | Flinkのコミットハッシュ | `/overview` API |

### アプリケーション一覧セクション（実行中/完了済み）

| 項目名 | データ型 | 説明 | ソート可能 |
|--------|----------|------|------------|
| アプリケーション名 | string | アプリケーションの名前 | 可 |
| ステータス | string | アプリケーションの状態（RUNNING/FINISHED/CANCELED/FAILED） | 可 |
| 開始時刻 | timestamp | アプリケーションの開始日時 | 可 |
| 終了時刻 | timestamp | アプリケーションの終了日時（完了済みのみ） | 可 |
| 実行時間 | duration | アプリケーションの実行時間 | 可 |
| ジョブ統計 | object | 含まれるジョブの状態別カウント | 不可 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化時（ngOnInit）

**処理フロー**:
1. StatusServiceのrefresh$をサブスクライブ
2. ApplicationServiceを通じてアプリケーション一覧を取得
3. OverviewServiceを通じてクラスター概要を取得
4. 取得データを結合してOverviewWithApplicationStatistics型に変換
5. アプリケーションをRUNNING状態と完了状態でフィルタリング
6. 画面に統計情報とアプリケーション一覧を表示

**API呼び出し**:
- GET `/overview`
- GET `/applications/overview`

### 2-アプリケーション行クリック

**トリガー**: アプリケーション一覧の行をクリック

**処理フロー**:
1. クリックされたアプリケーションのIDを取得
2. アプリケーションの状態に応じてルーティングパスを決定
3. `navigateToApplication`メソッドで画面遷移を実行

**遷移先**:
- 実行中アプリケーション: `/application/running/{applicationId}`
- 完了済みアプリケーション: `/application/completed/{applicationId}`

### 3-自動リフレッシュ

**トリガー**: StatusServiceのrefresh$イベント発火

**処理フロー**:
1. 定期的にrefresh$イベントが発火
2. 最新のアプリケーション一覧とクラスター概要を再取得
3. 画面表示を更新

## データベース更新仕様

本画面はデータ参照のみを行い、データベースへの更新処理は発生しない。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 該当なし | - | SELECT | 全ての操作は参照のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| なし | - | - | 本画面では明示的なメッセージ表示は行われない |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| API通信エラー | REST APIへの接続失敗 | catchError演算子でEMPTYを返却し、エラーを握りつぶす |
| データ取得エラー | サーバーからのレスポンスエラー | 同上 |

## 備考

- 本画面はChangeDetectionStrategy.OnPushを使用しており、パフォーマンス最適化されている
- RxJSのcombineLatestを使用して、複数のAPIレスポンスを結合している
- コンポーネント破棄時にはdestroy$サブジェクトを使用してサブスクリプションを適切にクリーンアップしている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | overview.ts | `src/app/interfaces/overview.ts` | Overview型とOverviewWithApplicationStatistics型の定義。クラスター概要とアプリケーション統計の構造を把握する |
| 1-2 | application-overview.ts | `src/app/interfaces/application-overview.ts` | ApplicationItem型の定義。アプリケーション一覧のデータ構造を理解する |

**読解のコツ**: TypeScriptのinterface定義を確認し、各プロパティの意味とオプショナル性を把握する。特に`?`が付いた項目は条件付きで存在するプロパティである。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | overview.component.ts | `src/app/pages/overview/overview.component.ts` | メインコンポーネント。ngOnInit()が処理の起点となる |

**主要処理フロー**:
1. **49-78行目**: ngOnInit()でデータ取得ストリームを構築
2. **50-54行目**: アプリケーション一覧の取得（ApplicationService.loadApplications）
3. **57-77行目**: クラスター概要とアプリケーション統計の結合処理

#### Step 3: サービス層を理解する

データ取得を担当するサービスクラスを解析する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | overview.service.ts | `src/app/services/overview.service.ts` | loadOverview()メソッドでREST API呼び出し |
| 3-2 | application.service.ts | `src/app/services/application.service.ts` | loadApplications()メソッドでアプリケーション一覧取得 |

**主要処理フロー**:
- **34-36行目** (overview.service.ts): `/overview`エンドポイントへのGETリクエスト
- **44-58行目** (application.service.ts): `/applications/overview`エンドポイントへのGETリクエストとデータ変換

#### Step 4: 子コンポーネントを理解する

画面を構成する子コンポーネントの役割を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | overview-statistic.component.ts | `src/app/pages/overview/statistic/overview-statistic.component.ts` | 統計情報表示コンポーネント。Inputプロパティでデータを受け取る |
| 4-2 | application-list.component.ts | `src/app/components/application-list/application-list.component.ts` | アプリケーション一覧表示。completedフラグで表示対象をフィルタリング |

### プログラム呼び出し階層図

```
OverviewComponent
    │
    ├─ StatusService.refresh$（イベント監視）
    │
    ├─ ApplicationService.loadApplications()
    │      └─ HttpClient.get('/applications/overview')
    │
    ├─ OverviewService.loadOverview()
    │      └─ HttpClient.get('/overview')
    │
    ├─ OverviewStatisticComponent（子）
    │      └─ 統計データ表示
    │
    └─ ApplicationListComponent（子）×2
           ├─ 実行中アプリ一覧
           └─ 完了済みアプリ一覧
```

### データフロー図

```
[入力]                    [処理]                           [出力]

StatusService.refresh$ ───┬─▶ ApplicationService ───────┬─▶ statisticData$
                          │       │                      │      │
                          │       ▼                      │      ▼
                          │   /applications/overview    │  OverviewStatisticComponent
                          │                              │
                          └─▶ OverviewService ──────────┘
                                  │
                                  ▼
                              /overview
                                  │
                                  ▼
                          applicationData$ ──────────────▶ ApplicationListComponent
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| overview.component.ts | `src/app/pages/overview/overview.component.ts` | ソース | メインコンポーネント |
| overview.component.html | `src/app/pages/overview/overview.component.html` | テンプレート | 画面レイアウト定義 |
| overview.component.less | `src/app/pages/overview/overview.component.less` | スタイル | 画面スタイル定義 |
| overview-statistic.component.ts | `src/app/pages/overview/statistic/overview-statistic.component.ts` | ソース | 統計表示コンポーネント |
| application-list.component.ts | `src/app/components/application-list/application-list.component.ts` | ソース | アプリ一覧コンポーネント |
| overview.service.ts | `src/app/services/overview.service.ts` | ソース | 概要取得サービス |
| application.service.ts | `src/app/services/application.service.ts` | ソース | アプリ情報サービス |
| status.service.ts | `src/app/services/status.service.ts` | ソース | リフレッシュ管理サービス |
| overview.ts | `src/app/interfaces/overview.ts` | 型定義 | データ型定義 |
| application-overview.ts | `src/app/interfaces/application-overview.ts` | 型定義 | アプリ型定義 |
